/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StrippedIntOpenHashMap;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

@ApiStatus.Internal
public final class MostlyUShortIntList
implements IntUnaryOperator {
    private char[] myData;
    private int mySize;
    private StrippedIntOpenHashMap myMap;

    MostlyUShortIntList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    void add(int value2) {
        if (value2 < 0 || value2 >= 65535) {
            this.initMap().put(this.mySize, value2);
            value2 = 65535;
        }
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = (char)value2;
    }

    void set(int index, int value2) {
        if (value2 < 0 || value2 >= 65535) {
            this.initMap().put(index, value2);
            value2 = 65535;
        }
        this.myData[index] = (char)value2;
    }

    private StrippedIntOpenHashMap initMap() {
        if (this.myMap == null) {
            this.myMap = new StrippedIntOpenHashMap();
        }
        return this.myMap;
    }

    @Override
    public int applyAsInt(int index) {
        return this.get(index);
    }

    public int get(int index) {
        int value2 = this.myData[index];
        return value2 == 65535 ? this.myMap.get(index, 0) : value2;
    }

    int size() {
        return this.mySize;
    }

    void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }
}

