/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElementRegistryService;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@ApiStatus.Internal
public final class StubFieldAccessor
implements Supplier<ObjectStubSerializer<?, ? extends Stub>> {
    public final String externalId;
    private final Field myField;
    private volatile ObjectStubSerializer<?, Stub> myFieldValue;

    @Override
    public ObjectStubSerializer<?, Stub> get() {
        ObjectStubSerializer<?, Stub> delegate = this.myFieldValue;
        if (delegate == null) {
            try {
                ObjectStubSerializer<?, Stub> serializer;
                Object object = this.myField.get(null);
                if (object instanceof ObjectStubSerializer) {
                    serializer = (ObjectStubSerializer<?, Stub>)object;
                } else if (object instanceof IElementType) {
                    IElementType elementType = (IElementType)object;
                    serializer = StubElementRegistryService.getInstance().getStubSerializer(elementType);
                } else {
                    throw new IllegalStateException(object + " is not an instance of ObjectStubSerializer nor IElementType with registered stub serializer");
                }
                this.myFieldValue = delegate = serializer;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(this.myField + " is not assignable to 'ObjectStubSerializer'", e);
            }
            if (!delegate.getExternalId().equals(this.externalId)) {
                throw new IllegalStateException("External id mismatch in " + this + ". Judging by extension declaration it should be " + this.externalId + " but " + delegate.getExternalId() + " is returned.");
            }
        }
        return delegate;
    }

    public String toString() {
        return this.myField.toString();
    }
}

