/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubRegistry;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001Bw\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0003\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0003\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\u0003\u0012\u001a\u0010\n\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0016J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016R\"\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubRegistryImpl;", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubRegistry;", "factories", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElementFactory;", "lightFactories", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/LightStubElementFactory;", "type2serializerMap", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/ObjectStubSerializer;", "serializer2typeMap", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "registerStubFactory", "", "type", "factory", "registerLightStubFactory", "registerStubSerializer", "serializer", "intellij.platform.core.impl"})
final class StubRegistryImpl
implements StubRegistry {
    @NotNull
    private final Map<IElementType, StubElementFactory<?, ?>> factories;
    @NotNull
    private final Map<IElementType, LightStubElementFactory<?, ?>> lightFactories;
    @NotNull
    private final Map<IElementType, ObjectStubSerializer<?, ?>> type2serializerMap;
    @NotNull
    private final Map<ObjectStubSerializer<?, ?>, IElementType> serializer2typeMap;

    public StubRegistryImpl(@NotNull Map<IElementType, StubElementFactory<?, ?>> factories, @NotNull Map<IElementType, LightStubElementFactory<?, ?>> lightFactories, @NotNull Map<IElementType, ObjectStubSerializer<?, ?>> type2serializerMap, @NotNull Map<ObjectStubSerializer<?, ?>, IElementType> serializer2typeMap) {
        Intrinsics.checkNotNullParameter(factories, (String)"factories");
        Intrinsics.checkNotNullParameter(lightFactories, (String)"lightFactories");
        Intrinsics.checkNotNullParameter(type2serializerMap, (String)"type2serializerMap");
        Intrinsics.checkNotNullParameter(serializer2typeMap, (String)"serializer2typeMap");
        this.factories = factories;
        this.lightFactories = lightFactories;
        this.type2serializerMap = type2serializerMap;
        this.serializer2typeMap = serializer2typeMap;
    }

    @Override
    public void registerStubFactory(@NotNull IElementType type, @NotNull StubElementFactory<?, ?> factory) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        if (factory instanceof LightStubElementFactory) {
            throw new IllegalArgumentException("Light stub element factory must be registered in registerLightSTubFactory");
        }
        this.factories.put(type, factory);
    }

    @Override
    public void registerLightStubFactory(@NotNull IElementType type, @NotNull LightStubElementFactory<?, ?> factory) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.lightFactories.put(type, factory);
        this.factories.put(type, factory);
    }

    @Override
    public void registerStubSerializer(@NotNull IElementType type, @NotNull ObjectStubSerializer<?, ?> serializer) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.type2serializerMap.put(type, serializer);
        this.serializer2typeMap.put(serializer, type);
    }
}

