/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFragment;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiLiteralUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public final class JavaPsiStringTemplateUtil {
    @Contract(value="null -> false")
    public static boolean isStrTemplate(@Nullable PsiExpression processor) {
        return JavaPsiStringTemplateUtil.isStrTemplate(processor, false);
    }

    @Contract(value="null, _ -> false")
    public static boolean isStrTemplate(@Nullable PsiExpression processor, boolean allowUnresolved) {
        if (!((processor = PsiUtil.skipParenthesizedExprDown(processor)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)processor;
        if (!"STR".equals(referenceExpression.getReferenceName())) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (allowUnresolved && target == null && referenceExpression.getQualifierExpression() == null) {
            return true;
        }
        if (!(target instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)target;
        PsiClass containingClass = field.getContainingClass();
        return containingClass != null && "java.lang.StringTemplate".equals(containingClass.getQualifiedName());
    }

    public static TextRange getContentRange(PsiFragment fragment) {
        IElementType tokenType = fragment.getTokenType();
        if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 1);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            TextRange fragmentRange = fragment.getTextRange();
            String text = fragment.getText();
            int index = 3;
            while (PsiLiteralUtil.isTextBlockWhiteSpace(text.charAt(index))) {
                ++index;
            }
            return new TextRange(fragmentRange.getStartOffset() + ++index, fragmentRange.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 3);
        }
        throw new AssertionError();
    }
}

