/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimaryPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.NotNullFunction;

public class PsiExpressionTrimRenderer
extends JavaRecursiveElementWalkingVisitor {
    private final StringBuilder myBuf;

    public PsiExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    @Override
    public void visitExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(0);
        }
        this.myBuf.append(expression2.getText());
    }

    @Override
    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
        PsiPrimaryPattern pattern;
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(1);
        }
        expression2.getOperand().accept(this);
        this.myBuf.append(" ").append("instanceof").append(" ");
        PsiTypeElement checkType = expression2.getCheckType();
        if (checkType != null) {
            this.myBuf.append(checkType.getText());
        }
        if ((pattern = expression2.getPattern()) != null) {
            this.myBuf.append(pattern.getText());
        }
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(2);
        }
        this.myBuf.append("(");
        PsiExpression expr = expression2.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        this.myBuf.append(")");
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
        PsiExpression operand;
        PsiTypeElement castType;
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(3);
        }
        if ((castType = expression2.getCastType()) != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand = expression2.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(4);
        }
        expression2.getArrayExpression().accept(this);
        this.myBuf.append("[");
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(5);
        }
        this.myBuf.append(expression2.getOperationSign().getText());
        PsiExpression operand = expression2.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(6);
        }
        expression2.getOperand().accept(this);
        this.myBuf.append(expression2.getOperationSign().getText());
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(7);
        }
        for (PsiElement child : expression2.getChildren()) {
            if (child instanceof PsiExpression) {
                child.accept(this);
                continue;
            }
            if (!(child instanceof PsiJavaToken)) continue;
            this.myBuf.append(" ").append(child.getText()).append(" ");
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(8);
        }
        PsiParameterList parameterList2 = expression2.getParameterList();
        PsiParameter[] parameters = parameterList2.getParameters();
        PsiElement firstChild = parameterList2.getFirstChild();
        boolean addParenthesis = PsiUtil.isJavaToken(firstChild, JavaTokenType.LPARENTH);
        if (addParenthesis) {
            this.myBuf.append('(');
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiTypeElement typeElement;
            PsiParameter parameter = parameters[i];
            if (i != 0) {
                this.myBuf.append(", ");
            }
            int formatOptions = 1 | ((typeElement = parameter.getTypeElement()) == null ? 0 : 2);
            this.myBuf.append(PsiFormatUtil.formatVariable(parameter, formatOptions, PsiSubstitutor.EMPTY));
        }
        if (addParenthesis) {
            this.myBuf.append(')');
        }
        this.myBuf.append(" -> {...}");
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(9);
        }
        expression2.getCondition().accept(this);
        this.myBuf.append(" ? ");
        PsiExpression thenExpression = expression2.getThenExpression();
        if (thenExpression != null) {
            thenExpression.accept(this);
        }
        this.myBuf.append(" : ");
        PsiExpression elseExpression = expression2.getElseExpression();
        if (elseExpression != null) {
            elseExpression.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(10);
        }
        expression2.getLExpression().accept(this);
        this.myBuf.append(expression2.getOperationSign().getText());
        PsiExpression rExpression = expression2.getRExpression();
        if (rExpression != null) {
            rExpression.accept(this);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expr) {
        PsiExpression qualifierExpression;
        if (expr == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(11);
        }
        if ((qualifierExpression = expr.getQualifierExpression()) != null) {
            qualifierExpression.accept(this);
            this.myBuf.append(".");
        }
        this.myBuf.append(expr.getReferenceName());
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expr) {
        if (expr == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(12);
        }
        expr.getMethodExpression().accept(this);
        expr.getArgumentList().accept(this);
    }

    @Override
    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
        PsiElement qualifier;
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(13);
        }
        if ((qualifier = expression2.getQualifier()) != null) {
            qualifier.accept(this);
        }
        this.myBuf.append("::");
        this.myBuf.append(expression2.getReferenceName());
    }

    @Override
    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(14);
        }
        if ((initializers = expression2.getInitializers()).length > 1) {
            this.myBuf.append("{...}");
        } else {
            this.myBuf.append("{");
            if (initializers.length > 0) {
                initializers[0].accept(this);
            }
            this.myBuf.append("}");
        }
    }

    @Override
    public void visitExpressionList(@NotNull PsiExpressionList list) {
        PsiExpression[] args;
        if (list == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(15);
        }
        if ((args = list.getExpressions()).length > 0) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    @Override
    public void visitSwitchExpression(@NotNull PsiSwitchExpression switchExpression) {
        if (switchExpression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(16);
        }
        this.myBuf.append("switch (");
        PsiExpression expression2 = switchExpression.getExpression();
        if (expression2 != null) {
            expression2.accept(this);
        }
        this.myBuf.append(") {...}");
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression expr) {
        if (expr == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(17);
        }
        PsiAnonymousClass anonymousClass = expr.getAnonymousClass();
        PsiExpressionList argumentList = expr.getArgumentList();
        if (anonymousClass != null) {
            this.myBuf.append("new").append(" ").append(anonymousClass.getBaseClassType().getPresentableText());
            if (argumentList != null) {
                argumentList.accept(this);
            }
            this.myBuf.append(" {...}");
        } else {
            PsiJavaCodeReferenceElement reference2 = expr.getClassReference();
            if (reference2 != null) {
                PsiArrayInitializerExpression arrayInitializer;
                this.myBuf.append("new").append(" ").append(reference2.getText());
                PsiExpression[] arrayDimensions = expr.getArrayDimensions();
                PsiType type = expr.getType();
                for (PsiExpression dimension : arrayDimensions) {
                    this.myBuf.append("[");
                    dimension.accept(this);
                    this.myBuf.append("]");
                }
                if (type != null) {
                    int dimensions = type.getArrayDimensions() - arrayDimensions.length;
                    for (int i = 0; i < dimensions; ++i) {
                        this.myBuf.append("[]");
                    }
                }
                if (argumentList != null) {
                    argumentList.accept(this);
                }
                if ((arrayInitializer = expr.getArrayInitializer()) != null) {
                    this.myBuf.append(" ");
                    arrayInitializer.accept(this);
                }
            } else {
                this.myBuf.append(expr.getText());
            }
        }
    }

    public static String render(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(18);
        }
        return PsiExpressionTrimRenderer.render(expression2, 100);
    }

    public static String render(@NotNull PsiExpression expression2, int maxLength) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(19);
        }
        StringBuilder buf = new StringBuilder();
        expression2.accept(new PsiExpressionTrimRenderer(buf));
        String text = buf.toString();
        int firstNewLinePos = text.indexOf(10);
        String trimmedText = text.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(maxLength, text.length()));
        if (trimmedText.length() != text.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiExpressionTrimRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceOfExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParenthesizedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccessExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLambdaExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodReferenceExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayInitializerExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpressionList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RenderFunction
    implements NotNullFunction<PsiExpression, String> {
        @Override
        @NotNull
        public String fun(@NotNull PsiExpression psiExpression) {
            if (psiExpression == null) {
                RenderFunction.$$$reportNull$$$0(0);
            }
            String string = PsiExpressionTrimRenderer.render(psiExpression);
            if (string == null) {
                RenderFunction.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiExpressionTrimRenderer$RenderFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiExpressionTrimRenderer$RenderFunction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

