/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.util.AbstractQuery;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Functions;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.HashingStrategy;

public final class UniqueResultsQuery<T, M>
extends AbstractQuery<T> {
    @NotNull
    private final Query<? extends T> myOriginal;
    private final HashingStrategy<? super M> myHashingStrategy;
    @NotNull
    private final Function<? super T, ? extends M> myMapper;

    public UniqueResultsQuery(@NotNull Query<? extends T> original) {
        if (original == null) {
            UniqueResultsQuery.$$$reportNull$$$0(0);
        }
        this(original, Functions.identity());
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull HashingStrategy<? super M> hashingStrategy) {
        if (original == null) {
            UniqueResultsQuery.$$$reportNull$$$0(1);
        }
        if (hashingStrategy == null) {
            UniqueResultsQuery.$$$reportNull$$$0(2);
        }
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = Functions.identity();
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull Function<? super T, ? extends M> mapper) {
        if (original == null) {
            UniqueResultsQuery.$$$reportNull$$$0(3);
        }
        if (mapper == null) {
            UniqueResultsQuery.$$$reportNull$$$0(4);
        }
        this.myOriginal = original;
        this.myHashingStrategy = null;
        this.myMapper = mapper;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super T> consumer) {
        if (consumer == null) {
            UniqueResultsQuery.$$$reportNull$$$0(5);
        }
        return UniqueResultsQuery.delegateProcessResults(this.myOriginal, new MyProcessor(this.createSet(), consumer));
    }

    @NotNull
    private Set<M> createSet() {
        if (this.myHashingStrategy == null) {
            Set set = Collections.synchronizedSet(new HashSet());
            if (set == null) {
                UniqueResultsQuery.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<? super M> set = Collections.synchronizedSet(CollectionFactory.createCustomHashingStrategySet(this.myHashingStrategy));
        if (set == null) {
            UniqueResultsQuery.$$$reportNull$$$0(7);
        }
        return set;
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forEachAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processResults";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forEachAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyProcessor
    implements Processor<T> {
        private final Set<? super M> myProcessedElements;
        private final Processor<? super T> myConsumer;

        MyProcessor(@NotNull Set<? super M> processedElements, Processor<? super T> consumer) {
            if (processedElements == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        @Override
        public boolean process(T t) {
            ProgressManager.checkCanceled();
            Object m = UniqueResultsQuery.this.myMapper.fun(t);
            if (this.myProcessedElements.contains(m)) {
                return true;
            }
            boolean result2 = this.myConsumer.process(t);
            this.myProcessedElements.add(m);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processedElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery$MyProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

