/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentSoftHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentSoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.FastUtilHashingStrategies;
import org.jetbrains.kotlin.com.intellij.util.containers.FastUtilHashingStrategies$SerializableHashStrategy;
import org.jetbrains.kotlin.com.intellij.util.containers.HashingStrategy;
import org.jetbrains.kotlin.com.intellij.util.containers.SoftKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakHashMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap(null);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap(null);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.identity());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(3);
        }
        return new WeakHashMap(initialCapacity, loadFactor, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap();
    }

    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return CollectionFactory.createWeakMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(4);
        }
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        return CollectionFactory.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(6);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet<String>(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(@NotNull Map<String, V> source) {
        if (source == null) {
            CollectionFactory.$$$reportNull$$$0(9);
        }
        return new Object2ObjectOpenCustomHashMap<String, V>(source, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            CollectionFactory.$$$reportNull$$$0(15);
        }
        return new ObjectOpenHashSet<K>(collection);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap(null);
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(22);
        }
        return new Object2ObjectOpenCustomHashMap(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    private static <K> Hash.Strategy<K> adaptStrategy(final @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(23);
        }
        return new FastUtilHashingStrategies$SerializableHashStrategy<K>(){

            @Override
            public int hashCode(@Nullable K o) {
                return strategy.hashCode(o);
            }

            @Override
            public boolean equals(@Nullable K a, @Nullable K b) {
                return strategy.equals(a, b);
            }
        };
    }

    @NotNull
    public static <K> Set<K> createCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(25);
        }
        return new ObjectOpenCustomHashSet<K>(CollectionFactory.adaptStrategy(strategy));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evictionListener";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/CollectionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakValueMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftValueMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createWeakMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCharSequenceSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathLinkedSet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintSet";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createSoftMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "trimMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "trimSet";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHashingStrategyMap";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "adaptStrategy";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHashingStrategySet";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinkedCustomHashingStrategyMap";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinkedCustomHashingStrategySet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

