/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.storage;

import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.storage.AbstractRecordsTable;
import org.jetbrains.kotlin.com.intellij.util.io.storage.DataTable;
import org.jetbrains.kotlin.com.intellij.util.io.storage.IStorage;

@ApiStatus.Internal
public abstract class AbstractStorage
implements IStorage {
    public static final StorageLockContext SHARED = new StorageLockContext(true, true);
    public static final int PAGE_SIZE = SystemProperties.getIntProperty("idea.io.page.size", 8192);
    protected static final Logger LOG = Logger.getInstance(AbstractStorage.class);
    protected AbstractRecordsTable myRecordsTable;
    protected DataTable myDataTable;
    protected StorageLockContext myContext;

    @Override
    public void force() throws IOException {
        this.withWriteLock(() -> {
            this.myDataTable.force();
            this.myRecordsTable.force();
        });
    }

    @Override
    public boolean isDirty() {
        return this.myDataTable.isDirty() || this.myRecordsTable.isDirty();
    }

    @Override
    public void dispose() {
        this.withWriteLock(() -> {
            IOUtil.closeSafe(LOG, this.myRecordsTable);
            IOUtil.closeSafe(LOG, this.myDataTable);
        });
    }

    protected <E extends Throwable> void withWriteLock(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            AbstractStorage.$$$reportNull$$$0(15);
        }
        ConcurrencyUtil.withLock(this.myContext.writeLock(), runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFilePath";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/storage/AbstractStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInit";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "compact";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrTruncateFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBytes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceBytes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "withReadLock";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "withWriteLock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

