/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageHandler;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.BaseBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/BaseBusConnection;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/MessageBusConnection;", "bus", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl;", "<init>", "(Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "defaultHandler", "Lorg/jetbrains/kotlin/com/intellij/util/messages/MessageHandler;", "subscribe", "", "L", "", "topic", "Lorg/jetbrains/kotlin/com/intellij/util/messages/Topic;", "setDefaultHandler", "handler", "dispose", "disconnect", "deliverImmediately", "isMyHandler", "", "intellij.platform.core"})
@ApiStatus.Internal
public final class MessageBusConnectionImpl
extends BaseBusConnection
implements MessageBusConnection {
    @Nullable
    private MessageHandler defaultHandler;

    public MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        super(bus, null);
    }

    @Override
    public void dispose() {
        MessageBusImpl messageBusImpl = this.bus;
        if (messageBusImpl == null) {
            return;
        }
        MessageBusImpl bus = messageBusImpl;
        this.bus = null;
        this.defaultHandler = null;
        Object[] objectArray = this.subscriptions.getAndSet(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAndSet(...)");
        bus.notifyConnectionTerminated$intellij_platform_core(objectArray);
    }

    @Override
    public void deliverImmediately() {
        MessageBusImpl bus = this.bus;
        if (bus == null) {
            MessageBusImpl.LOG.error("Bus is already disposed");
        } else {
            bus.deliverImmediately$intellij_platform_core(this);
        }
    }

    public final boolean isMyHandler(@NotNull Topic<?> topic, @NotNull Object handler2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        if (this.defaultHandler == handler2) {
            return true;
        }
        Object[] topicAndHandlerPairs = (Object[])this.subscriptions.get();
        int n = topicAndHandlerPairs.length;
        for (int i = 0; i < n; i += 2) {
            if (topic != topicAndHandlerPairs[i] || handler2 != topicAndHandlerPairs[i + 1]) continue;
            return true;
        }
        return false;
    }
}

