/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function10;
import kotlin.jvm.functions.Function11;
import kotlin.jvm.functions.Function12;
import kotlin.jvm.functions.Function13;
import kotlin.jvm.functions.Function14;
import kotlin.jvm.functions.Function15;
import kotlin.jvm.functions.Function16;
import kotlin.jvm.functions.Function17;
import kotlin.jvm.functions.Function18;
import kotlin.jvm.functions.Function19;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function20;
import kotlin.jvm.functions.Function21;
import kotlin.jvm.functions.Function22;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u0002\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\u000b\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0002\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\r\u001a \u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u001f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\"&\u0010\u0013\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0002\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u0015*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0019\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0019\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\b*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"safeClassLoader", "Ljava/lang/ClassLoader;", "Ljava/lang/Class;", "getSafeClassLoader", "(Ljava/lang/Class;)Ljava/lang/ClassLoader;", "isEnumClassOrSpecializedEnumEntryClass", "", "PRIMITIVE_CLASSES", "", "Lkotlin/reflect/KClass;", "", "WRAPPER_TO_PRIMITIVE", "", "PRIMITIVE_TO_WRAPPER", "primitiveByWrapper", "getPrimitiveByWrapper", "(Ljava/lang/Class;)Ljava/lang/Class;", "wrapperByPrimitive", "getWrapperByPrimitive", "FUNCTION_CLASSES", "Lkotlin/Function;", "", "functionClassArity", "getFunctionClassArity", "(Ljava/lang/Class;)Ljava/lang/Integer;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/name/ClassId;", "desc", "", "getDesc", "(Ljava/lang/Class;)Ljava/lang/String;", "parameterizedTypeArguments", "Ljava/lang/reflect/Type;", "getParameterizedTypeArguments", "(Ljava/lang/reflect/Type;)Ljava/util/List;", "descriptors.runtime"})
@SourceDebugExtension(value={"SMAP\nreflectClassUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reflectClassUtil.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectClassUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1586#2:100\n1661#2,3:101\n1586#2:104\n1661#2,3:105\n1596#2:108\n1629#2,4:109\n*S KotlinDebug\n*F\n+ 1 reflectClassUtil.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectClassUtilKt\n*L\n34#1:100\n34#1:101,3\n35#1:104\n35#1:105,3\n50#1:108\n50#1:109,4\n*E\n"})
public final class ReflectClassUtilKt {
    @NotNull
    private static final List<KClass<? extends Object>> PRIMITIVE_CLASSES;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> WRAPPER_TO_PRIMITIVE;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> PRIMITIVE_TO_WRAPPER;
    @NotNull
    private static final Map<Class<? extends Function<?>>, Integer> FUNCTION_CLASSES;

    @NotNull
    public static final ClassLoader getSafeClassLoader(@NotNull Class<?> $this$safeClassLoader) {
        Intrinsics.checkNotNullParameter($this$safeClassLoader, (String)"<this>");
        ClassLoader classLoader = $this$safeClassLoader.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader(...)");
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(@NotNull Class<?> $this$isEnumClassOrSpecializedEnumEntryClass) {
        Intrinsics.checkNotNullParameter($this$isEnumClassOrSpecializedEnumEntryClass, (String)"<this>");
        return Enum.class.isAssignableFrom($this$isEnumClassOrSpecializedEnumEntryClass);
    }

    @Nullable
    public static final Class<?> getPrimitiveByWrapper(@NotNull Class<?> $this$primitiveByWrapper) {
        Intrinsics.checkNotNullParameter($this$primitiveByWrapper, (String)"<this>");
        return WRAPPER_TO_PRIMITIVE.get($this$primitiveByWrapper);
    }

    @Nullable
    public static final Class<?> getWrapperByPrimitive(@NotNull Class<?> $this$wrapperByPrimitive) {
        Intrinsics.checkNotNullParameter($this$wrapperByPrimitive, (String)"<this>");
        return PRIMITIVE_TO_WRAPPER.get($this$wrapperByPrimitive);
    }

    @Nullable
    public static final Integer getFunctionClassArity(@NotNull Class<?> $this$functionClassArity) {
        Intrinsics.checkNotNullParameter($this$functionClassArity, (String)"<this>");
        return FUNCTION_CLASSES.get($this$functionClassArity);
    }

    @NotNull
    public static final ClassId getClassId(@NotNull Class<?> $this$classId) {
        Class<?> clazz;
        block7: {
            block8: {
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter($this$classId, (String)"<this>");
                        if ($this$classId.isPrimitive()) {
                            throw new IllegalArgumentException("Can't compute ClassId for primitive type: " + $this$classId);
                        }
                        if ($this$classId.isArray()) {
                            throw new IllegalArgumentException("Can't compute ClassId for array type: " + $this$classId);
                        }
                        if ($this$classId.getEnclosingMethod() != null || $this$classId.getEnclosingConstructor() != null) break block5;
                        String string = $this$classId.getSimpleName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                        if (!(((CharSequence)string).length() == 0)) break block6;
                    }
                    String string = $this$classId.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    FqName fqName = new FqName(string);
                    clazz = new ClassId(fqName.parent(), FqName.Companion.topLevel(fqName.shortName()), true);
                    break block7;
                }
                clazz = $this$classId.getDeclaringClass();
                if (clazz == null || (clazz = ReflectClassUtilKt.getClassId(clazz)) == null) break block8;
                Name name2 = Name.identifier($this$classId.getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                if ((clazz = ((ClassId)((Object)clazz)).createNestedClassId(name2)) != null) break block7;
            }
            String string = $this$classId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            clazz = ClassId.Companion.topLevel(new FqName(string));
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String getDesc(@NotNull Class<?> $this$desc) {
        String string;
        block33: {
            Intrinsics.checkNotNullParameter($this$desc, (String)"<this>");
            if (!$this$desc.isPrimitive()) break block33;
            String string2 = $this$desc.getName();
            if (string2 == null) throw new IllegalArgumentException("Unsupported primitive type: " + $this$desc);
            int n = -1;
            switch (string2.hashCode()) {
                case 64711720: {
                    if (string2.equals("boolean")) {
                        n = 1;
                    }
                    break;
                }
                case 3625364: {
                    if (string2.equals("void")) {
                        n = 2;
                    }
                    break;
                }
                case 3039496: {
                    if (string2.equals("byte")) {
                        n = 3;
                    }
                    break;
                }
                case -1325958191: {
                    if (string2.equals("double")) {
                        n = 4;
                    }
                    break;
                }
                case 3052374: {
                    if (string2.equals("char")) {
                        n = 5;
                    }
                    break;
                }
                case 109413500: {
                    if (string2.equals("short")) {
                        n = 6;
                    }
                    break;
                }
                case 97526364: {
                    if (string2.equals("float")) {
                        n = 7;
                    }
                    break;
                }
                case 104431: {
                    if (string2.equals("int")) {
                        n = 8;
                    }
                    break;
                }
                case 3327612: {
                    if (string2.equals("long")) {
                        n = 9;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return "Z";
                }
                case 5: {
                    return "C";
                }
                case 3: {
                    return "B";
                }
                case 6: {
                    return "S";
                }
                case 8: {
                    return "I";
                }
                case 7: {
                    return "F";
                }
                case 9: {
                    return "J";
                }
                case 4: {
                    return "D";
                }
                case 2: {
                    return "V";
                }
                default: {
                    throw new IllegalArgumentException("Unsupported primitive type: " + $this$desc);
                }
            }
        }
        if ($this$desc.isArray()) {
            String string3 = $this$desc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            string = StringsKt.replace$default((String)string3, (char)'.', (char)'/', (boolean)false, (int)4, null);
            return string;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append('L');
            String string4 = $this$desc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            string = stringBuilder.append(StringsKt.replace$default((String)string4, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(';').toString();
        }
        return string;
    }

    @NotNull
    public static final List<Type> getParameterizedTypeArguments(@NotNull Type $this$parameterizedTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterizedTypeArguments, (String)"<this>");
        if (!($this$parameterizedTypeArguments instanceof ParameterizedType)) {
            return CollectionsKt.emptyList();
        }
        if (((ParameterizedType)$this$parameterizedTypeArguments).getOwnerType() == null) {
            Type[] typeArray = ((ParameterizedType)$this$parameterizedTypeArguments).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getActualTypeArguments(...)");
            return ArraysKt.toList((Object[])typeArray);
        }
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.generateSequence((Object)$this$parameterizedTypeArguments, ReflectClassUtilKt::_get_parameterizedTypeArguments_$lambda$0), ReflectClassUtilKt::_get_parameterizedTypeArguments_$lambda$1));
    }

    private static final ParameterizedType _get_parameterizedTypeArguments_$lambda$0(ParameterizedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Type type = it.getOwnerType();
        return type instanceof ParameterizedType ? (ParameterizedType)type : null;
    }

    private static final Sequence _get_parameterizedTypeArguments_$lambda$1(ParameterizedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Type[] typeArray = it.getActualTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getActualTypeArguments(...)");
        return ArraysKt.asSequence((Object[])typeArray);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapIndexedTo$iv$iv;
        KClass it;
        boolean bl;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE)};
        PRIMITIVE_CLASSES = CollectionsKt.listOf((Object[])objectArray);
        Object[] $this$map$iv = (Object[])PRIMITIVE_CLASSES;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            KClass kClass = (KClass)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(TuplesKt.to((Object)JvmClassMappingKt.getJavaObjectType((KClass)it), (Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)it)));
        }
        WRAPPER_TO_PRIMITIVE = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$map$iv = PRIMITIVE_CLASSES;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (KClass)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(TuplesKt.to((Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)it), (Object)JvmClassMappingKt.getJavaObjectType((KClass)it)));
        }
        PRIMITIVE_TO_WRAPPER = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$map$iv = new Class[]{Function0.class, Function1.class, Function2.class, Function3.class, Function4.class, Function5.class, Function6.class, Function7.class, Function8.class, Function9.class, Function10.class, Function11.class, Function12.class, Function13.class, Function14.class, Function15.class, Function16.class, Function17.class, Function18.class, Function19.class, Function20.class, Function21.class, Function22.class};
        Iterable $this$mapIndexed$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void clazz;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Class clazz2 = (Class)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to((Object)clazz, (Object)((int)i)));
        }
        FUNCTION_CLASSES = MapsKt.toMap((Iterable)((List)var3_3));
    }
}

