/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryN;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithSource;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithoutSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/diagnostics/impl/DeduplicatingDiagnosticReporter;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "inner", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "hasErrors", "", "getHasErrors", "()Z", "reported", "", "Lkotlin/Triple;", "", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryN;", "report", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;", "checkAndCommitReportsOn", "element", "frontend.common"})
public final class DeduplicatingDiagnosticReporter
extends DiagnosticReporter {
    @NotNull
    private final DiagnosticReporter inner;
    @NotNull
    private final Set<Triple<String, AbstractKtSourceElement, KtDiagnosticFactoryN>> reported;

    public DeduplicatingDiagnosticReporter(@NotNull DiagnosticReporter inner) {
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        this.inner = inner;
        this.reported = new LinkedHashSet();
    }

    @Override
    public boolean getHasErrors() {
        return this.inner.getHasErrors();
    }

    @Override
    public void report(@Nullable KtDiagnostic diagnostic, @NotNull DiagnosticContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtDiagnostic ktDiagnostic = diagnostic;
        if (ktDiagnostic != null) {
            if (ktDiagnostic instanceof KtDiagnosticWithoutSource) {
                this.inner.report(diagnostic, context2);
            } else if (ktDiagnostic instanceof KtDiagnosticWithSource) {
                if (this.reported.add((Triple<String, AbstractKtSourceElement, KtDiagnosticFactoryN>)new Triple((Object)context2.getContainingFilePath(), (Object)((KtDiagnosticWithSource)diagnostic).getElement(), (Object)((KtDiagnosticWithSource)diagnostic).getFactory()))) {
                    this.inner.report(diagnostic, context2);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void checkAndCommitReportsOn(@NotNull AbstractKtSourceElement element, @Nullable DiagnosticContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.inner.checkAndCommitReportsOn(element, context2);
    }
}

