/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.CliDiagnostics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirContextParametersLanguageVersionSettingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirLanguageVersionSettingsChecker;", "<init>", "()V", "DIAGNOSTIC_MESSAGE", "", "getDIAGNOSTIC_MESSAGE", "()Ljava/lang/String;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkers"})
public final class FirContextParametersLanguageVersionSettingsChecker
extends FirLanguageVersionSettingsChecker {
    @NotNull
    public static final FirContextParametersLanguageVersionSettingsChecker INSTANCE = new FirContextParametersLanguageVersionSettingsChecker();
    @NotNull
    private static final String DIAGNOSTIC_MESSAGE = "Experimental context receivers are superseded by context parameters.\nReplace the '-Xcontext-receivers' compiler argument with '-Xcontext-parameters' and migrate to the new syntax.\n\nSee the context parameters proposal for more details: https://kotl.in/context-parameters";

    private FirContextParametersLanguageVersionSettingsChecker() {
    }

    @NotNull
    public final String getDIAGNOSTIC_MESSAGE() {
        return DIAGNOSTIC_MESSAGE;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextReceivers)) {
            return;
        }
        String message2 = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextParameters) ? "Experimental language features for context receivers and context parameters cannot be enabled at the same time. Remove the '-Xcontext-receivers' compiler argument." : DIAGNOSTIC_MESSAGE;
        KtDiagnosticReportHelpersKt.report(context2, reporter, CliDiagnostics.INSTANCE.getCONTEXT_PARAMETERS_ARE_DEPRECATED(), message2);
    }
}

