/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnyDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnyDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n38#2:36\n1915#3,2:37\n*S KotlinDebug\n*F\n+ 1 FirAnyDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker\n*L\n23#1:36\n26#1:37,2\n*E\n"})
public final class FirAnyDeprecationChecker
extends FirDeclarationChecker<FirNamedFunction> {
    @NotNull
    public static final FirAnyDeprecationChecker INSTANCE = new FirAnyDeprecationChecker();

    private FirAnyDeprecationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirNamedFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirMemberDeclaration $this$isOverride$iv = declaration;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride() || !FirDeclarationUtilKt.isMethodOfAny(declaration.getSymbol())) {
            return;
        }
        Map<ClassId, Boolean> deprecationAnnotations = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(context2.getSession()).getDeprecationAnnotationsWithOverridesPropagation();
        Iterable $this$forEach$iv = declaration.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isOptInMarker;
            FirAnnotation annotation = (FirAnnotation)element$iv;
            boolean bl = false;
            boolean isDeprecationMarker = deprecationAnnotations.containsKey(FirAnnotationUtilsKt.toAnnotationClassId(annotation, context2.getSession()));
            boolean bl2 = isOptInMarker = FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context2.getSession()) != null;
            if (!isDeprecationMarker && !isOptInMarker) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getPOTENTIALLY_NON_REPORTED_ANNOTATION(), null, 8, null);
        }
    }
}

