/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirLocalPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0002H\u0002J/\u0010\u0011\u001a\u00020\u0007*\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "hasGetter", "", "hasSetter", "reportError", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "target", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Ljava/lang/String;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInapplicableLateinitChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,105:1\n56#2:106\n13#2:107\n*S KotlinDebug\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n*L\n29#1:106\n77#1:107\n*E\n"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();

    private FirInapplicableLateinitChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirMemberDeclaration $this$isLateInit$iv = declaration;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit() || declaration.getReturnTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (declaration.isVal()) {
            this.reportError(context2, reporter, declaration.getSource(), "is allowed only on mutable properties");
        }
        if (declaration.getInitializer() != null) {
            if (declaration.getSymbol() instanceof FirLocalPropertySymbol) {
                this.reportError(context2, reporter, declaration.getSource(), "is not allowed on local variables with initializer");
            } else {
                this.reportError(context2, reporter, declaration.getSource(), "is not allowed on properties with initializer");
            }
        }
        if (declaration.getDelegate() != null) {
            this.reportError(context2, reporter, declaration.getSource(), "is not allowed on delegated properties");
        }
        if (TypeUtilsKt.canBeNull$default(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context2.getSession(), false, null, 6, null)) {
            this.reportError(context2, reporter, declaration.getSource(), "is not allowed on properties of a type with nullable upper bound");
        }
        if (ConeBuiltinTypeUtilsKt.isPrimitive(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            if (declaration.getSymbol() instanceof FirLocalPropertySymbol) {
                this.reportError(context2, reporter, declaration.getSource(), "is not allowed on local variables of primitive types");
            } else {
                this.reportError(context2, reporter, declaration.getSource(), "is not allowed on properties of primitive types");
            }
        }
        if (DeclarationAttributesKt.getHasExplicitBackingField(declaration)) {
            this.reportError(context2, reporter, declaration.getSource(), "must be moved to the field declaration");
        }
        if ((this.hasGetter(declaration) || this.hasSetter(declaration)) && declaration.getDelegate() == null) {
            this.reportError(context2, reporter, declaration.getSource(), "is not allowed on properties with a custom getter or setter");
        }
        if (FirDeclarationUtilKt.isExtension(declaration)) {
            this.reportError(context2, reporter, declaration.getSource(), "is not allowed on extension properties");
        }
        if (!((Collection)declaration.getContextParameters()).isEmpty()) {
            this.reportError(context2, reporter, declaration.getSource(), "is not allowed on properties with context receivers");
        }
        FirMemberDeclaration $this$isAbstract$iv = declaration;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
            this.reportError(context2, reporter, declaration.getSource(), "is not allowed on abstract properties");
        }
        if (FirHelpersKt.isSingleFieldValueClass(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context2.getSession())) {
            ConeKotlinType declarationType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()));
            String variables2 = declaration.getSymbol() instanceof FirLocalPropertySymbol ? "local variables" : "properties";
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(declarationType)) {
                this.reportError(context2, reporter, declaration.getSource(), "is not allowed on " + variables2 + " of unsigned types");
            } else {
                this.reportError(context2, reporter, declaration.getSource(), "is not allowed on " + variables2 + " of inline class types");
            }
        }
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        return $this$hasGetter.getGetter() != null && !($this$hasGetter.getGetter() instanceof FirDefaultPropertyGetter);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        return $this$hasSetter.getSetter() != null && !($this$hasSetter.getSetter() instanceof FirDefaultPropertySetter);
    }

    private final void reportError(CheckerContext context2, DiagnosticReporter $this$reportError, KtSourceElement source, String target) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportError, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), (Object)target, null, 16, null);
    }
}

