/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00070\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0007`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/RedundantCallOfConversionMethodChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "unsafeNumberClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "isRedundant", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "qualifiedClassId", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "targetClassMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "checkers"})
public final class RedundantCallOfConversionMethodChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final RedundantCallOfConversionMethodChecker INSTANCE = new RedundantCallOfConversionMethodChecker();
    @NotNull
    private static final ClassId unsafeNumberClassId = ClassId.Companion.fromString$default(ClassId.Companion, "kotlinx.cinterop/UnsafeNumber", false, 2, null);
    @NotNull
    private static final HashMap<String, ClassId> targetClassMap;

    private RedundantCallOfConversionMethodChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        String string = expression2.getCalleeReference().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String functionName = string;
        ClassId classId = targetClassMap.get(functionName);
        if (classId == null) {
            return;
        }
        ClassId qualifiedTypeId = classId;
        FirExpression firExpression = expression2.getExplicitReceiver();
        boolean bl = firExpression != null ? this.isRedundant(context2, firExpression, qualifiedTypeId, context2.getSession()) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), null, 8, null);
        }
    }

    private final boolean isRedundant(CheckerContext context2, FirExpression $this$isRedundant, ClassId qualifiedClassId, FirSession session) {
        ClassId classId;
        if ($this$isRedundant instanceof FirLiteralExpression) {
            classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant));
        } else if (FirTypeUtilsKt.getResolvedType($this$isRedundant) instanceof ConeFlexibleType) {
            classId = null;
        } else if (ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant))) {
            classId = null;
        } else {
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toClassLikeSymbol((SessionHolder)context2, AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getResolvedType($this$isRedundant)));
            classId = (firClassLikeSymbol != null ? FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)firClassLikeSymbol, unsafeNumberClassId, session) : false) ? null : FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant), session);
        }
        ClassId thisTypeId = classId;
        return Intrinsics.areEqual((Object)thisTypeId, (Object)qualifiedClassId);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toString", (Object)StandardClassIds.INSTANCE.getString()), TuplesKt.to((Object)"toDouble", (Object)StandardClassIds.INSTANCE.getDouble()), TuplesKt.to((Object)"toFloat", (Object)StandardClassIds.INSTANCE.getFloat()), TuplesKt.to((Object)"toLong", (Object)StandardClassIds.INSTANCE.getLong()), TuplesKt.to((Object)"toInt", (Object)StandardClassIds.INSTANCE.getInt()), TuplesKt.to((Object)"toChar", (Object)StandardClassIds.INSTANCE.getChar()), TuplesKt.to((Object)"toShort", (Object)StandardClassIds.INSTANCE.getShort()), TuplesKt.to((Object)"toByte", (Object)StandardClassIds.INSTANCE.getByte()), TuplesKt.to((Object)"toULong", (Object)StandardClassIds.INSTANCE.getULong()), TuplesKt.to((Object)"toUInt", (Object)StandardClassIds.INSTANCE.getUInt()), TuplesKt.to((Object)"toUShort", (Object)StandardClassIds.INSTANCE.getUShort()), TuplesKt.to((Object)"toUByte", (Object)StandardClassIds.INSTANCE.getUByte())};
        targetClassMap = MapsKt.hashMapOf((Pair[])pairArray);
    }
}

