/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001f\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u001f\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\nR\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u001a\u0016\u0010\u0010\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0015\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0016\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u001f\u0010\u0019\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u001f\u0010\u001a\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u001f\u0010\u0015\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u001f\u0010\u0016\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u001f\u0010\u0010\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a \u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\"\u001c\u0010\u0012\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u001c\u0010\u0014\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006 "}, d2={"isEffectivelyExternalMember", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isEffectivelyExternal", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Z", "getJsName", "", "sanitizeName", "name", "isLibraryObject", "isPresentInGeneratedCode", "isExpect", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isActual", "isPredefinedObject", "isExportedObject", "getContainingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "isNativeObject", "isNativeInterface", "superClassNotAny", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getRootClassLikeSymbolOrSelf", "symbol", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsHelpersKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,151:1\n17#2:152\n26#2:164\n52#2:165\n25#2:166\n51#2:167\n777#3:153\n873#3,2:154\n1807#3,3:156\n832#3:169\n862#3,2:170\n1#4:159\n990#5:160\n1065#5,3:161\n22#6:168\n*S KotlinDebug\n*F\n+ 1 FirJsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsHelpersKt\n*L\n43#1:152\n73#1:164\n74#1:165\n80#1:166\n81#1:167\n47#1:153\n47#1:154,2\n48#1:156,3\n142#1:169\n142#1:170,2\n62#1:160\n62#1:161,3\n102#1:168\n*E\n"})
public final class FirJsHelpersKt {
    public static final boolean isEffectivelyExternalMember(@NotNull FirBasedSymbol<?> $this$isEffectivelyExternalMember, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyExternalMember, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return $this$isEffectivelyExternalMember.getFir() instanceof FirMemberDeclaration && FirWebCommonHelpersKt.isEffectivelyExternal($this$isEffectivelyExternalMember, session);
    }

    public static final boolean isEffectivelyExternal(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$isEffectivelyExternal) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isEffectivelyExternal, (String)"<this>");
        return FirWebCommonHelpersKt.isEffectivelyExternal($this$isEffectivelyExternal, context2.getSession());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isOverridingExternalWithOptionalParams(@NotNull CheckerContext context2, @NotNull FirFunctionSymbol<?> $this$isOverridingExternalWithOptionalParams) {
        void $this$filterTo$iv$iv;
        List<FirNamedFunctionSymbol> list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isOverridingExternalWithOptionalParams, (String)"<this>");
        if (!ClassMembersKt.isSubstitutionOrIntersectionOverride((FirCallableSymbol)$this$isOverridingExternalWithOptionalParams)) {
            FirCallableSymbol $this$modality$iv = $this$isOverridingExternalWithOptionalParams;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) {
                return false;
            }
        }
        Object object2 = object = $this$isOverridingExternalWithOptionalParams instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)$this$isOverridingExternalWithOptionalParams : null;
        if (object == null || (list = FirHelpersKt.directOverriddenFunctionsSafe(context2, (FirNamedFunctionSymbol)object)) == null) {
            return false;
        }
        List<FirNamedFunctionSymbol> overridden = list;
        Iterable $this$filter$iv = overridden;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv$iv;
            boolean bl = false;
            if (!FirJsHelpersKt.isEffectivelyExternal(context2, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FirNamedFunctionSymbol overriddenFunction : (List)destination$iv$iv) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = overriddenFunction.getValueParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!it.getHasDefaultValue()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final String getJsName(@NotNull FirBasedSymbol<?> $this$getJsName, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$getJsName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return FirHelpersKt.getAnnotationStringParameter($this$getJsName, JsStandardClassIds.Annotations.JsName, session);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (((CharSequence)name2).length() == 0) {
            return "_";
        }
        char it = StringsKt.first((CharSequence)name2);
        boolean $i$a$-let-FirJsHelpersKt$sanitizeName$first$22 = false;
        char first = IdentifierPolicyKt.isES5IdentifierStart(it) ? it : (char)'_';
        CharSequence charSequence = StringsKt.drop((String)name2, (int)1);
        StringBuilder stringBuilder = new StringBuilder().append(first);
        boolean $i$f$map = false;
        void $i$a$-let-FirJsHelpersKt$sanitizeName$first$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            char it2;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(IdentifierPolicyKt.isES5IdentifierPart(it2) ? it2 : (char)'_'));
        }
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
    }

    public static final boolean isLibraryObject(@NotNull FirBasedSymbol<?> $this$isLibraryObject, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isLibraryObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isLibraryObject, JsStandardClassIds.Annotations.JsLibrary, session);
    }

    public static final boolean isPresentInGeneratedCode(@NotNull FirBasedSymbol<?> $this$isPresentInGeneratedCode, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isPresentInGeneratedCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return !FirWebCommonHelpersKt.isNativeObject($this$isPresentInGeneratedCode, session) && !FirJsHelpersKt.isLibraryObject($this$isPresentInGeneratedCode, session);
    }

    public static final boolean isExpect(@NotNull FirBasedSymbol<?> $this$isExpect) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isExpect, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isExpect;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            FirCallableSymbol $this$isExpect$iv = (FirCallableSymbol)$this$isExpect;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else if (firBasedSymbol instanceof FirClassSymbol) {
            FirClassLikeSymbol $this$isExpect$iv = (FirClassLikeSymbol)$this$isExpect;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isActual(@NotNull FirBasedSymbol<?> $this$isActual) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isActual, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isActual;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            FirCallableSymbol $this$isActual$iv = (FirCallableSymbol)$this$isActual;
            boolean $i$f$isActual = false;
            bl = $this$isActual$iv.getRawStatus().isActual();
        } else if (firBasedSymbol instanceof FirClassSymbol) {
            FirClassLikeSymbol $this$isActual$iv = (FirClassLikeSymbol)$this$isActual;
            boolean $i$f$isActual = false;
            bl = $this$isActual$iv.getRawStatus().isActual();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isPredefinedObject(@NotNull FirBasedSymbol<?> $this$isPredefinedObject, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isPredefinedObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if ($this$isPredefinedObject.getFir() instanceof FirMemberDeclaration && FirJsHelpersKt.isExpect($this$isPredefinedObject)) {
            return true;
        }
        if (FirJsHelpersKt.isEffectivelyExternalMember($this$isPredefinedObject, session)) {
            return true;
        }
        for (PredefinedAnnotation annotation : PredefinedAnnotation.getEntries()) {
            if (!FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isPredefinedObject, annotation.getClassId(), session)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isExportedObject(@NotNull FirBasedSymbol<?> $this$isExportedObject, @NotNull FirSession session) {
        Object object;
        Intrinsics.checkNotNullParameter($this$isExportedObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object declaration = $this$isExportedObject.getFir();
        if (declaration instanceof FirMemberDeclaration) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            Visibility visibility = $this$visibility$iv.getStatus().getVisibility();
            if (!Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Public.INSTANCE) && !Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Protected.INSTANCE)) {
                return false;
            }
        }
        return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isExportedObject, JsStandardClassIds.Annotations.JsExportIgnore, session) ? false : (FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isExportedObject, JsStandardClassIds.Annotations.JsExport, session) || Intrinsics.areEqual((Object)FirHelpersKt.getAnnotationBooleanParameter($this$isExportedObject, JsStandardClassIds.Annotations.JsImplicitExport, session), (Object)true) || FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isExportedObject, JsStandardClassIds.Annotations.JsExportDefault, session) ? true : ((object = FirJsHelpersKt.getContainingFile($this$isExportedObject)) != null && (object = ((FirFile)object).getSymbol()) != null ? FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)object, JsStandardClassIds.Annotations.JsExport, session) : false));
    }

    @Nullable
    public static final FirFile getContainingFile(@NotNull FirBasedSymbol<?> $this$getContainingFile) {
        Intrinsics.checkNotNullParameter($this$getContainingFile, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$getContainingFile;
        return firBasedSymbol instanceof FirCallableSymbol ? FirProviderKt.getFirProvider(((FirCallableSymbol)$this$getContainingFile).getModuleData().getSession()).getFirCallableContainerFile((FirCallableSymbol)$this$getContainingFile) : (firBasedSymbol instanceof FirClassLikeSymbol ? FirProviderKt.getFirProvider(((FirClassLikeSymbol)$this$getContainingFile).getModuleData().getSession()).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)$this$getContainingFile) : null);
    }

    public static final boolean isNativeObject(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$isNativeObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isNativeObject, (String)"<this>");
        return FirWebCommonHelpersKt.isNativeObject($this$isNativeObject, context2.getSession());
    }

    public static final boolean isNativeInterface(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$isNativeInterface) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isNativeInterface, (String)"<this>");
        return FirWebCommonHelpersKt.isNativeInterface($this$isNativeInterface, context2.getSession());
    }

    public static final boolean isPredefinedObject(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$isPredefinedObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isPredefinedObject, (String)"<this>");
        return FirJsHelpersKt.isPredefinedObject($this$isPredefinedObject, context2.getSession());
    }

    public static final boolean isExportedObject(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$isExportedObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isExportedObject, (String)"<this>");
        return FirJsHelpersKt.isExportedObject($this$isExportedObject, context2.getSession());
    }

    public static final boolean isLibraryObject(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$isLibraryObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$isLibraryObject, (String)"<this>");
        return FirJsHelpersKt.isLibraryObject($this$isLibraryObject, context2.getSession());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ConeClassLikeType superClassNotAny(@NotNull FirClass $this$superClassNotAny, @NotNull FirSession session) {
        Object v1;
        block2: {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$superClassNotAny, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Iterable $this$filterNot$iv = FirDeclarationUtilKt.getSuperConeTypes($this$superClassNotAny);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                boolean bl = false;
                if (ConeBuiltinTypeUtilsKt.isAny(it) || ConeBuiltinTypeUtilsKt.isNullableAny(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                ConeClassLikeType it = (ConeClassLikeType)e;
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(it, session);
                if (!((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.CLASS)) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final FirBasedSymbol<?> getRootClassLikeSymbolOrSelf(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
        FirBasedSymbol firBasedSymbol;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                firBasedSymbol = ContainingClassUtilsKt.getContainingClassSymbol(symbol);
                if (firBasedSymbol == null) break block2;
                FirClassLikeSymbol<?> it = firBasedSymbol;
                boolean bl = false;
                FirBasedSymbol<?> firBasedSymbol2 = FirJsHelpersKt.getRootClassLikeSymbolOrSelf((FirBasedSymbol)it, session);
                firBasedSymbol = firBasedSymbol2;
                if (firBasedSymbol2 != null) break block3;
            }
            firBasedSymbol = symbol;
        }
        return firBasedSymbol;
    }
}

