/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions.builder;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.StandardTypes;
import org.jetbrains.kotlin.fir.builder.FirBuilderDslKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirLiteralExpressionImpl;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"buildLiteralExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "kind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "setType", "", "prefix", "", "tree"})
public final class FirConstExpressionBuilderKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final FirLiteralExpression buildLiteralExpression(@Nullable KtSourceElement source, @NotNull ConstantValueKind kind, @Nullable Object value2, @Nullable List<FirAnnotation> annotations2, boolean setType, @Nullable String prefix) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (setType) {
            ConstantValueKind constantValueKind = kind;
            if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getBoolean();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getByte();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getChar();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getDouble();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getFloat();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getInt();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getLong();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getNullableAny();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getShort();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getString();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getUByte();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getUInt();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getULong();
            } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
                coneClassLikeType = StandardTypes.INSTANCE.getUShort();
            } else {
                if (!Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE) && !Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) && !Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Error.INSTANCE)) throw new NoWhenBranchMatchedException();
                coneClassLikeType = null;
            }
        } else {
            coneClassLikeType = null;
        }
        ConeClassLikeType coneType = coneClassLikeType;
        return new FirLiteralExpressionImpl(source, coneType, FirBuilderDslKt.toMutableOrEmpty(annotations2), kind, value2, prefix, null);
    }

    public static /* synthetic */ FirLiteralExpression buildLiteralExpression$default(KtSourceElement ktSourceElement, ConstantValueKind constantValueKind, Object object, List list, boolean bl, String string, int n, Object object2) {
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x20) != 0) {
            string = null;
        }
        return FirConstExpressionBuilderKt.buildLiteralExpression(ktSourceElement, constantValueKind, object, list, bl, string);
    }
}

