/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.ImplicitValueMapper;
import org.jetbrains.kotlin.fir.resolve.calls.FirReceiversKt;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitContextParameterValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitDispatchReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitValue;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.util.PersistentSetMultimap;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BO\b\u0002\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006\u0012\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rB\t\b\u0016\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0018\u0010\u0017\u001a\u00020\u00002\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0010J\u001c\u0010\u0019\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010JF\u0010\u001f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t*\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0010H\u0002JB\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006*\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u001d\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\"2\b\u0010\u001a\u001a\u0004\u0018\u00010#H\u0086\u0002J\u0018\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\nJ\b\u0010&\u001a\u0004\u0018\u00010'J \u0010&\u001a\u0004\u0018\u00010'2\u0016\u0010(\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020*0)J\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0010J\u001c\u0010,\u001a\u00020-2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010.\u001a\u00020/H\u0007J\u0015\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/ImplicitValueStorage;", "", "implicitReceiverStack", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "implicitReceiversByLabel", "Lorg/jetbrains/kotlin/fir/util/PersistentSetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "implicitValuesBySymbol", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "<init>", "(Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/util/PersistentSetMultimap;Lkotlinx/collections/immutable/PersistentMap;)V", "()V", "implicitReceivers", "", "getImplicitReceivers", "()Ljava/util/List;", "implicitValues", "", "getImplicitValues", "()Ljava/util/Collection;", "addAllImplicitReceivers", "receivers", "addImplicitReceiver", "name", "value", "addAllContexts", "contextParameters", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitContextParameterValue;", "addAll", "putIfNameIsNotNull", "get", "", "", "getBySymbol", "symbol", "lastDispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitDispatchReceiverValue;", "lookupCondition", "Lkotlin/Function1;", "", "receiversAsReversed", "replaceImplicitValueType", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "createSnapshot", "mapper", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitValueMapper;", "createSnapshot$semantics", "semantics"})
@SourceDebugExtension(value={"SMAP\nImplicitValueStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplicitValueStorage.kt\norg/jetbrains/kotlin/fir/resolve/ImplicitValueStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,171:1\n1849#2,3:172\n1849#2,3:175\n546#2,6:178\n1834#2,4:185\n862#2,2:189\n812#2,12:191\n812#2,12:203\n546#2,6:215\n1586#2:221\n1661#2,3:222\n1849#2,2:225\n1849#2,3:227\n1851#2:230\n1266#2,4:233\n1#3:184\n466#4:231\n415#4:232\n*S KotlinDebug\n*F\n+ 1 ImplicitValueStorage.kt\norg/jetbrains/kotlin/fir/resolve/ImplicitValueStorage\n*L\n47#1:172,3\n80#1:175,3\n102#1:178,6\n109#1:185,4\n110#1:189,2\n121#1:191,12\n125#1:203,12\n125#1:215,6\n143#1:221\n143#1:222,3\n144#1:225,2\n145#1:227,3\n144#1:230\n149#1:233,4\n149#1:231\n149#1:232\n*E\n"})
public final class ImplicitValueStorage {
    @NotNull
    private final PersistentList<ImplicitReceiverValue<?>> implicitReceiverStack;
    @NotNull
    private final PersistentSetMultimap<Name, ImplicitReceiverValue<?>> implicitReceiversByLabel;
    @NotNull
    private final PersistentMap<FirBasedSymbol<?>, ImplicitValue<?>> implicitValuesBySymbol;

    private ImplicitValueStorage(PersistentList<? extends ImplicitReceiverValue<?>> implicitReceiverStack, PersistentSetMultimap<Name, ImplicitReceiverValue<?>> implicitReceiversByLabel, PersistentMap<FirBasedSymbol<?>, ? extends ImplicitValue<?>> implicitValuesBySymbol) {
        this.implicitReceiverStack = implicitReceiverStack;
        this.implicitReceiversByLabel = implicitReceiversByLabel;
        this.implicitValuesBySymbol = implicitValuesBySymbol;
    }

    public ImplicitValueStorage() {
        this(ExtensionsKt.persistentListOf(), new PersistentSetMultimap(), ExtensionsKt.persistentMapOf());
    }

    @NotNull
    public final List<ImplicitReceiverValue<?>> getImplicitReceivers() {
        return this.implicitReceiverStack;
    }

    @NotNull
    public final Collection<ImplicitValue<?>> getImplicitValues() {
        return this.implicitValuesBySymbol.values();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImplicitValueStorage addAllImplicitReceivers(@NotNull List<? extends ImplicitReceiverValue<?>> receivers) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(receivers, (String)"receivers");
        Iterable iterable = receivers;
        ImplicitValueStorage initial$iv = this;
        boolean $i$f$fold = false;
        ImplicitValueStorage accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void value2;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)element$iv;
            ImplicitValueStorage acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addImplicitReceiver(null, (ImplicitReceiverValue<?>)value2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final ImplicitValueStorage addImplicitReceiver(@Nullable Name name2, @NotNull ImplicitReceiverValue<?> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        PersistentList<ImplicitReceiverValue<?>> stack = this.implicitReceiverStack.add(value2);
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel = this.putIfNameIsNotNull(this.implicitReceiversByLabel, name2, value2);
        PersistentMap<FirBasedSymbol, ImplicitReceiverValue<?>> implicitValuesBySymbol = this.implicitValuesBySymbol.put(value2.getBoundSymbol(), value2);
        return new ImplicitValueStorage(stack, receiversPerLabel, implicitValuesBySymbol);
    }

    @NotNull
    public final ImplicitValueStorage addAllContexts(@NotNull List<ImplicitContextParameterValue> contextParameters) {
        Intrinsics.checkNotNullParameter(contextParameters, (String)"contextParameters");
        if (contextParameters.isEmpty()) {
            return this;
        }
        return new ImplicitValueStorage(this.implicitReceiverStack, this.implicitReceiversByLabel, this.addAll(this.implicitValuesBySymbol, contextParameters));
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentMap<FirBasedSymbol<?>, ImplicitValue<?>> addAll(PersistentMap<FirBasedSymbol<?>, ? extends ImplicitValue<?>> $this$addAll, List<? extends ImplicitValue<?>> contextParameters) {
        void $this$fold$iv;
        Iterable iterable = contextParameters;
        PersistentMap<FirBasedSymbol<?>, ImplicitValue<?>> initial$iv = $this$addAll;
        boolean $i$f$fold = false;
        PersistentMap<FirBasedSymbol<?>, Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void value2;
            ImplicitValue implicitValue = (ImplicitValue)element$iv;
            PersistentMap<FirBasedSymbol<?>, ImplicitValue<?>> acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.put((FirBasedSymbol<?>)value2.getBoundSymbol(), (ImplicitValue<?>)value2);
        }
        return accumulator$iv;
    }

    private final PersistentSetMultimap<Name, ImplicitReceiverValue<?>> putIfNameIsNotNull(PersistentSetMultimap<Name, ImplicitReceiverValue<?>> $this$putIfNameIsNotNull, Name name2, ImplicitReceiverValue<?> value2) {
        return name2 != null ? $this$putIfNameIsNotNull.put(name2, value2) : $this$putIfNameIsNotNull;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ImplicitReceiverValue<?>> get(@Nullable String name2) {
        Set set;
        ImplicitReceiverValue it;
        int n;
        if (name2 == null) {
            Set set2;
            Set set3;
            ImplicitReceiverValue implicitReceiverValue;
            ImplicitReceiverValue implicitReceiverValue2;
            Object v0;
            block12: {
                List $this$lastOrNull$iv = this.implicitReceiverStack;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    ImplicitReceiverValue it2 = (ImplicitReceiverValue)element$iv;
                    boolean bl = false;
                    if (!(!FirReceiversKt.producesInapplicableCandidate(it2))) continue;
                    v0 = element$iv;
                    break block12;
                }
                v0 = null;
            }
            if ((implicitReceiverValue2 = (ImplicitReceiverValue)v0) == null) {
                implicitReceiverValue2 = (ImplicitReceiverValue)CollectionsKt.lastOrNull((List)this.implicitReceiverStack);
            }
            if ((implicitReceiverValue = implicitReceiverValue2) != null) {
                ImplicitReceiverValue p0 = implicitReceiverValue;
                boolean bl = false;
                set3 = SetsKt.setOf((Object)p0);
            } else {
                set3 = set2 = null;
            }
            if (set3 == null) {
                set2 = SetsKt.emptySet();
            }
            return set2;
        }
        Name name3 = Name.identifier(name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        Set receivers = this.implicitReceiversByLabel.get(name3);
        Iterable $this$count$iv = receivers;
        boolean $i$f$count2 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (ImplicitReceiverValue)element$iv;
                boolean bl = false;
                if (!FirReceiversKt.producesInapplicableCandidate(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n != receivers.size()) {
            void destination$iv;
            void $this$filterNotTo$iv;
            $this$count$iv = receivers;
            Collection $i$f$count2 = new LinkedHashSet();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv : $this$filterNotTo$iv) {
                it = (ImplicitReceiverValue)element$iv;
                boolean bl = false;
                if (FirReceiversKt.producesInapplicableCandidate(it)) continue;
                destination$iv.add(element$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = receivers;
        }
        return set;
    }

    @Nullable
    public final ImplicitValue<?> getBySymbol(@NotNull FirBasedSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        return (ImplicitValue)this.implicitValuesBySymbol.get(symbol);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ImplicitDispatchReceiverValue lastDispatchReceiver() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.implicitReceiverStack;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ImplicitDispatchReceiverValue)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ImplicitDispatchReceiverValue lastDispatchReceiver(@NotNull Function1<? super ImplicitReceiverValue<?>, Boolean> lookupCondition) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(lookupCondition, (String)"lookupCondition");
            Iterable $this$filterIsInstance$iv = this.implicitReceiverStack;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List $this$lastOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                if (!((Boolean)lookupCondition.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<ImplicitReceiverValue<?>> receiversAsReversed() {
        return CollectionsKt.asReversed((List)this.implicitReceiverStack);
    }

    @ImplicitValue.ImplicitValueInternals
    public final void replaceImplicitValueType(@NotNull FirBasedSymbol<?> symbol, @NotNull ConeKotlinType type) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ImplicitValue implicitValue = (ImplicitValue)this.implicitValuesBySymbol.get(symbol);
        if (implicitValue == null) {
            return;
        }
        ImplicitValue implicitValue2 = implicitValue;
        implicitValue2.updateTypeFromSmartcast(type);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImplicitValueStorage createSnapshot$semantics(@NotNull ImplicitValueMapper mapper) {
        Object object;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object2;
        Object receiverValues;
        Object element$iv;
        Map $this$fold$iv;
        void initial$iv;
        PersistentList persistentList;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Iterable $this$map$iv = this.implicitReceiverStack;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = (PersistentList)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)item$iv$iv;
            persistentList = destination$iv$iv;
            boolean bl = false;
            persistentList.add((ImplicitReceiverValue)mapper.invoke((ImplicitValue)it));
        }
        $this$map$iv = this.implicitReceiversByLabel.getEntries();
        PersistentSetMultimap $i$f$map22 = new PersistentSetMultimap();
        persistentList = ExtensionsKt.toPersistentList((List)destination$iv$iv);
        boolean $i$f$fold22 = false;
        void accumulator$iv = initial$iv;
        Iterator $i$f$mapTo22 = $this$fold$iv.iterator();
        while ($i$f$mapTo22.hasNext()) {
            void $this$fold$iv2;
            Object item$iv$iv;
            element$iv = $i$f$mapTo22.next();
            item$iv$iv = (Map.Entry)element$iv;
            void accOuterMap = accumulator$iv;
            boolean bl = false;
            Name name2 = (Name)item$iv$iv.getKey();
            receiverValues = (PersistentSet)item$iv$iv.getValue();
            object2 = (Iterable)receiverValues;
            void initial$iv2 = accOuterMap;
            boolean $i$f$fold = false;
            PersistentSetMultimap<Name, ImplicitValue> accumulator$iv2 = initial$iv2;
            for (Object element$iv2 : $this$fold$iv2) {
                void receiverValue;
                ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)element$iv2;
                void accMap = accumulator$iv2;
                boolean bl2 = false;
                accumulator$iv2 = accMap.put(name2, mapper.invoke((ImplicitValue)receiverValue));
            }
            accumulator$iv = accumulator$iv2;
        }
        $this$fold$iv = this.implicitValuesBySymbol;
        void var23_35 = accumulator$iv;
        boolean $i$f$mapValues = false;
        void $i$f$fold22 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        element$iv = $this$mapValuesTo$iv$iv.entrySet();
        Object destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            receiverValues = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object2;
            boolean bl3 = false;
            ImplicitValue v = (ImplicitValue)entry.getValue();
            ImplicitValue implicitValue = mapper.invoke(v);
            object.put(k, implicitValue);
        }
        object = destination$iv$iv$iv;
        PersistentMap persistentMap = ExtensionsKt.toPersistentMap(object);
        void var28_40 = var23_35;
        PersistentList persistentList2 = persistentList;
        return new ImplicitValueStorage(persistentList2, (PersistentSetMultimap<Name, ImplicitReceiverValue<?>>)var28_40, persistentMap);
    }
}

