/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirInaccessibleReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.InaccessibleReceiverKind;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FunctionTypeKindSubstitutor;
import org.jetbrains.kotlin.fir.resolve.calls.InaccessibleFromClassHeader;
import org.jetbrains.kotlin.fir.resolve.calls.InaccessibleOuterClassReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirThisOwnerSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001f\u0010\u0011\u001a\u00020\f*\u0004\u0018\u00010\u0006H\u0000\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0000\u00f2\u0001\u0004\n\u00020\u0012\u00a8\u0006\u0015"}, d2={"prepareCapturedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getExpectedType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "captureFromTypeParameterUpperBoundIfNeeded", "expectedType", "hasSupertypeWithGivenClassId", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "isInaccessibleAndInapplicable", "Lorg/jetbrains/kotlin/fir/expressions/FirInaccessibleReceiverExpression;", "toInaccessibleReceiverDiagnostic", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "resolve"})
@SourceDebugExtension(value={"SMAP\nArgumentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentUtils.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n672#2,11:137\n*S KotlinDebug\n*F\n+ 1 ArgumentUtils.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentUtilsKt\n*L\n99#1:137,11\n*E\n"})
public final class ArgumentUtilsKt {
    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull ConeKotlinType argumentType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (org.jetbrains.kotlin.fir.types.TypeUtilsKt.isRaw(argumentType)) {
            return argumentType;
        }
        ConeKotlinType coneKotlinType = (ConeKotlinType)TypeComponentsKt.getTypeContext(session).captureFromExpression(TypeExpansionUtilsKt.fullyExpandedType$default(argumentType, session, null, 2, null));
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType expectedType;
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        FirExpression firExpression = $this$getExpectedType;
        boolean shouldUnwrapVarargType = firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression ? false : parameter.isVararg();
        ConeKotlinType coneKotlinType = expectedType = shouldUnwrapVarargType ? ArrayUtilsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        if (!FirFunctionTypeKindServiceKt.getFunctionTypeService(session).hasExtensionKinds()) {
            return expectedType;
        }
        return new FunctionTypeKindSubstitutor(session).substituteOrSelf(expectedType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Object v2;
        ConeInferenceContext context2;
        block8: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.upperBoundIfFlexible(expectedType));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType = coneRigidType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneRigidType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            context2 = TypeComponentsKt.getTypeContext(session);
            Iterable iterable = TypeUtilsKt.collectUpperBounds(simplifiedArgumentType, TypeComponentsKt.getTypeContext(session));
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv;
                boolean bl = false;
                if (!ArgumentUtilsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v2 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeClassLikeType coneClassLikeType = v2;
        if (coneClassLikeType == null) {
            return argumentType;
        }
        ConeClassLikeType chosenSupertype = coneClassLikeType;
        ConeKotlinType coneKotlinType2 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType2 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType2;
        if (argumentType instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, TypeComponentsKt.getTypeContext(session), false, 4, null);
            coneKotlinType = coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : capturedType;
        } else {
            coneKotlinType = capturedType;
        }
        return coneKotlinType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context2) {
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u240 = context2;
        boolean bl = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u240.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super RigidTypeMarker, Boolean>)((Function1)arg_0 -> ArgumentUtilsKt.hasSupertypeWithGivenClassId$lambda$0$0($this$hasSupertypeWithGivenClassId_u24lambda_u240, classId, arg_0)));
    }

    public static final boolean isInaccessibleAndInapplicable(@Nullable FirExpression $this$isInaccessibleAndInapplicable) {
        return $this$isInaccessibleAndInapplicable instanceof FirInaccessibleReceiverExpression && !((FirInaccessibleReceiverExpression)$this$isInaccessibleAndInapplicable).getKind().getProducesApplicableCandidate();
    }

    @NotNull
    public static final ResolutionDiagnostic toInaccessibleReceiverDiagnostic(@NotNull FirInaccessibleReceiverExpression $this$toInaccessibleReceiverDiagnostic) {
        ResolutionDiagnostic resolutionDiagnostic;
        Intrinsics.checkNotNullParameter((Object)$this$toInaccessibleReceiverDiagnostic, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toInaccessibleReceiverDiagnostic.getKind().ordinal()]) {
            case 1: {
                FirThisOwnerSymbol<?> firThisOwnerSymbol = $this$toInaccessibleReceiverDiagnostic.getCalleeReference().getBoundSymbol();
                Intrinsics.checkNotNull(firThisOwnerSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol<*>");
                resolutionDiagnostic = new InaccessibleOuterClassReceiver((FirClassSymbol)firThisOwnerSymbol);
                break;
            }
            case 2: {
                resolutionDiagnostic = InaccessibleFromClassHeader.INSTANCE;
                break;
            }
            case 3: {
                throw new IllegalStateException(("Should not be called for " + (Object)((Object)$this$toInaccessibleReceiverDiagnostic.getKind())).toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolutionDiagnostic;
    }

    private static final boolean hasSupertypeWithGivenClassId$lambda$0$0(TypeSystemCommonSuperTypesContext $this_with, ClassId $classId, RigidTypeMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TypeConstructorMarker typeConstructor2 = $this_with.typeConstructor(it);
        return typeConstructor2 instanceof ConeClassLikeLookupTag && Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)typeConstructor2).getClassId(), (Object)$classId);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InaccessibleReceiverKind.values().length];
            try {
                nArray[InaccessibleReceiverKind.OuterClassOfNonInner.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InaccessibleReceiverKind.ClassHeader.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InaccessibleReceiverKind.SecondaryConstructor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

