/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.deserialization.AnnotationDeserializationUtilKt;
import org.jetbrains.kotlin.fir.deserialization.AnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.AnnotationDeserializerWithProtocol;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.library.metadata.KlibMetadataSerializerProtocol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J:\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JR\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0016J8\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020#H\u0016J8\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010,\u001a\u00020#H\u0016J0\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J8\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00104\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/fir/session/KlibBasedAnnotationDeserializer;", "Lorg/jetbrains/kotlin/fir/deserialization/AnnotationDeserializerWithProtocol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "loadClassAnnotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "loadFunctionAnnotations", "containerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "functionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "loadPropertyAnnotations", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "containingClassProto", "loadConstructorAnnotations", "constructorProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "loadValueParameterAnnotations", "callableProto", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "valueParameterProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "kind", "Lorg/jetbrains/kotlin/fir/deserialization/AnnotationDeserializer$CallableKind;", "parameterIndex", "", "loadEnumEntryAnnotations", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "enumEntryProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$EnumEntry;", "loadPropertyGetterAnnotations", "getterFlags", "loadPropertySetterAnnotations", "setterFlags", "loadPropertyBackingFieldAnnotations", "loadPropertyDelegatedFieldAnnotations", "loadExtensionReceiverParameterAnnotations", "loadTypeAnnotations", "typeProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "loadTypeParameterAnnotations", "typeParameterProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "entrypoint"})
public final class KlibBasedAnnotationDeserializer
extends AnnotationDeserializerWithProtocol {
    @NotNull
    private final FirSession session;

    public KlibBasedAnnotationDeserializer(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, KlibMetadataSerializerProtocol.INSTANCE);
        this.session = session;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadClassAnnotations(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = classProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadClassAnnotations(classProto, nameResolver);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadFunctionAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Function functionProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)functionProto, (String)"functionProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = functionProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadFunctionAnnotations(containerSource, functionProto, nameResolver, typeTable);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @Nullable ProtoBuf.Class containingClassProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = propertyProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty(this.session, list, nameResolver, AnnotationUseSiteTarget.PROPERTY);
        if (list2 == null) {
            list2 = super.loadPropertyAnnotations(containerSource, propertyProto, containingClassProto, nameResolver, typeTable);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadConstructorAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Constructor constructorProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)constructorProto, (String)"constructorProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = constructorProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadConstructorAnnotations(containerSource, constructorProto, nameResolver, typeTable);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadValueParameterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull MessageLite callableProto, @NotNull ProtoBuf.ValueParameter valueParameterProto, @Nullable ProtoBuf.Class classProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull AnnotationDeserializer.CallableKind kind, int parameterIndex) {
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)valueParameterProto, (String)"valueParameterProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        List<ProtoBuf.Annotation> list = valueParameterProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadValueParameterAnnotations(containerSource, callableProto, valueParameterProto, classProto, nameResolver, typeTable, kind, parameterIndex);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadEnumEntryAnnotations(@NotNull ClassId classId, @NotNull ProtoBuf.EnumEntry enumEntryProto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)enumEntryProto, (String)"enumEntryProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = enumEntryProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadEnumEntryAnnotations(classId, enumEntryProto, nameResolver);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyGetterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, int getterFlags) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = propertyProto.getGetterAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGetterAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty(this.session, list, nameResolver, AnnotationUseSiteTarget.PROPERTY_GETTER);
        if (list2 == null) {
            list2 = super.loadPropertyGetterAnnotations(containerSource, propertyProto, nameResolver, typeTable, getterFlags);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertySetterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, int setterFlags) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = propertyProto.getSetterAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSetterAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty(this.session, list, nameResolver, AnnotationUseSiteTarget.PROPERTY_SETTER);
        if (list2 == null) {
            list2 = super.loadPropertySetterAnnotations(containerSource, propertyProto, nameResolver, typeTable, setterFlags);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyBackingFieldAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = propertyProto.getBackingFieldAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getBackingFieldAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty(this.session, list, nameResolver, AnnotationUseSiteTarget.FIELD);
        if (list2 == null) {
            list2 = super.loadPropertyBackingFieldAnnotations(containerSource, propertyProto, nameResolver, typeTable);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyDelegatedFieldAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        List<ProtoBuf.Annotation> list = propertyProto.getDelegateFieldAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDelegateFieldAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty(this.session, list, nameResolver, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
        if (list2 == null) {
            list2 = super.loadPropertyDelegatedFieldAnnotations(containerSource, propertyProto, nameResolver, typeTable);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadExtensionReceiverParameterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull MessageLite callableProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull AnnotationDeserializer.CallableKind kind) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        MessageLite messageLite = callableProto;
        if (messageLite instanceof ProtoBuf.Function) {
            List<ProtoBuf.Annotation> list3 = ((ProtoBuf.Function)callableProto).getExtensionReceiverAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getExtensionReceiverAnnotationList(...)");
            list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list3, nameResolver, null, 8, null);
        } else if (messageLite instanceof ProtoBuf.Property) {
            List<ProtoBuf.Annotation> list4 = ((ProtoBuf.Property)callableProto).getExtensionReceiverAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getExtensionReceiverAnnotationList(...)");
            list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list4, nameResolver, null, 8, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = super.loadExtensionReceiverParameterAnnotations(containerSource, callableProto, nameResolver, typeTable, kind);
        }
        return list;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadTypeAnnotations(@NotNull ProtoBuf.Type typeProto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)typeProto, (String)"typeProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = typeProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadTypeAnnotations(typeProto, nameResolver);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter typeParameterProto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)typeParameterProto, (String)"typeParameterProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = typeParameterProto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        List<FirAnnotation> list2 = AnnotationDeserializationUtilKt.loadAnnotationsFromMetadataIfNotEmpty$default(this.session, list, nameResolver, null, 8, null);
        if (list2 == null) {
            list2 = super.loadTypeParameterAnnotations(typeParameterProto, nameResolver);
        }
        return list2;
    }
}

