/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LocationInfo;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "cachedLocation", "Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "getCachedLocation", "()Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "cachedLocation$delegate", "Lkotlin/Lazy;", "location", "getLocation", "frontend"})
public final class KotlinLookupLocation
implements LookupLocation {
    @NotNull
    private final KtElement element;
    @NotNull
    private final Lazy cachedLocation$delegate;

    public KotlinLookupLocation(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.cachedLocation$delegate = LazyKt.lazy(() -> KotlinLookupLocation.cachedLocation_delegate$lambda$0(this));
    }

    @NotNull
    public final KtElement getElement() {
        return this.element;
    }

    @Nullable
    public final LocationInfo getCachedLocation() {
        Lazy lazy = this.cachedLocation$delegate;
        return (LocationInfo)lazy.getValue();
    }

    @Override
    @Nullable
    public LocationInfo getLocation() {
        return this.getCachedLocation();
    }

    private static final cachedLocation.2.1 cachedLocation_delegate$lambda$0(KotlinLookupLocation this$0) {
        KtFile ktFile = this$0.element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile containingKtFile = ktFile;
        return KtPsiFactoryKt.getDoNotAnalyze(containingKtFile) != null ? null : new LocationInfo(containingKtFile, this$0){
            private final String filePath;
            final /* synthetic */ KtFile $containingKtFile;
            final /* synthetic */ KotlinLookupLocation this$0;
            {
                this.$containingKtFile = $containingKtFile;
                this.this$0 = $receiver;
                this.filePath = $containingKtFile.getVirtualFilePath();
            }

            public String getFilePath() {
                return this.filePath;
            }

            public Position getPosition() {
                PsiDiagnosticUtils.LineAndColumn it = DiagnosticUtils.getLineAndColumnInPsiFile(this.$containingKtFile, this.this$0.getElement().getTextRange());
                boolean bl = false;
                return new Position(it.getLine(), it.getColumn());
            }
        };
    }
}

