/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.jsexport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.ExportUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedAttribute;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedClassDeclarationsInfo;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.tsexport.Exportability;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J#\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u000e*\u0002H\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020\u0019H\u0002J(\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00192\u0016\b\u0002\u0010+\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010\u000e0,H\u0002J,\u0010\u0017\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\rH\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateNamespacesForPackages", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getGenerateNamespacesForPackages", "()Z", "generateExport", "", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedDeclaration;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "withAttributesFor", "T", "(Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedDeclaration;", "exportClass", "candidate", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportPropertyUnsafely", "exportEnumEntry", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedProperty;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "exportDeclarationImplicitly", "klass", "exportOrdinaryClass", "exportEnumClass", "exportClassDeclarations", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedClassDeclarationsInfo;", "specialProcessing", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "members", "nestedClasses", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedClass;", "exportAsEnumMember", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGenerator\n+ 2 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n*L\n1#1,301:1\n32#2:302\n1651#3:303\n1915#3:304\n1916#3:307\n1652#3:308\n1807#3,3:312\n812#3,12:327\n1642#3,10:339\n1915#3:349\n1916#3:351\n1652#3:352\n1#4:305\n1#4:306\n1#4:310\n1#4:316\n1#4:319\n1#4:322\n1#4:325\n1#4:350\n1#4:354\n28#5:309\n29#5:311\n28#5:315\n29#5:317\n28#5:318\n29#5:320\n28#5:321\n29#5:323\n28#5:324\n29#5:326\n28#5:353\n29#5:355\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGenerator\n*L\n27#1:302\n27#1:303\n27#1:304\n27#1:307\n27#1:308\n86#1:312,3\n164#1:327,12\n165#1:339,10\n165#1:349\n165#1:351\n165#1:352\n27#1:306\n47#1:310\n107#1:316\n115#1:319\n135#1:322\n154#1:325\n165#1:350\n228#1:354\n47#1:309\n47#1:311\n107#1:315\n107#1:317\n115#1:318\n115#1:320\n135#1:321\n135#1:323\n154#1:324\n154#1:326\n228#1:353\n228#1:355\n*E\n"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean generateNamespacesForPackages;

    public ExportModelGenerator(@NotNull JsIrBackendContext context2, boolean generateNamespacesForPackages) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.generateNamespacesForPackages = generateNamespacesForPackages;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public final boolean getGenerateNamespacesForPackages() {
        return this.generateNamespacesForPackages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FqName namespaceFqName = file.getPackageFqName();
        Collection $this$memoryOptimizedMapNotNull$iv = file.getDeclarations();
        boolean $i$f$memoryOptimizedMapNotNull = false;
        Iterable iterable = $this$memoryOptimizedMapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ExportedDeclaration exportedDeclaration;
            IrDeclaration irDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration declaration = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            IrDeclaration it = irDeclaration = declaration;
            boolean bl3 = false;
            if ((!Intrinsics.areEqual((Object)AnnotationUtilsKt.couldBeConvertedToExplicitExport(it), (Object)true) ? irDeclaration : null) != null) {
                IrDeclaration p0;
                p0 = p0;
                boolean bl4 = false;
                exportedDeclaration = this.exportDeclaration(p0);
            } else {
                exportedDeclaration = null;
            }
            if (exportedDeclaration == null) continue;
            ExportedDeclaration it$iv$iv = exportedDeclaration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exports = CollectionsKt.compactIfPossible((List)destination$iv$iv);
        return exports.isEmpty() ? kotlin.collections.CollectionsKt.emptyList() : (!this.generateNamespacesForPackages || namespaceFqName.isRoot() ? exports : kotlin.collections.CollectionsKt.listOf((Object)new ExportedNamespace(namespaceFqName.toString(), exports)));
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportUtilsKt.getExportCandidate(declaration);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportUtilsKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, this.context, declaration)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Can't export declaration";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportDeclaration_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportDeclaration_u24lambda_u240.withIrEntry("candidate", candidate2);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        ExportedDeclaration exportedDeclaration2 = exportedDeclaration;
        return exportedDeclaration2 != null ? this.withAttributesFor(exportedDeclaration2, candidate2) : null;
    }

    private final <T extends ExportedDeclaration> T withAttributesFor(T $this$withAttributesFor, IrDeclaration declaration) {
        if (AnnotationUtilsKt.isJsExportDefault(declaration)) {
            $this$withAttributesFor.getAttributes().add(ExportedAttribute.DefaultExport.INSTANCE);
        }
        return $this$withAttributesFor;
    }

    private final ExportedDeclaration exportClass(IrClass candidate2) {
        return IrUtilsKt.isEnumClass(candidate2) ? this.exportEnumClass(candidate2) : this.exportOrdinaryClass(candidate2);
    }

    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = ExportUtilsKt.exportability(function2, this.context);
        if (exportability instanceof Exportability.NotNeeded || exportability instanceof Exportability.Implicit || exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Allowed) {
            exportedDeclaration = new ExportedFunction(ExportUtilsKt.getExportedIdentifier(function2), ExportModelGeneratorKt.access$isStaticMethod(function2), function2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportProperty(IrProperty property2) {
        Object[] objectArray = new IrSimpleFunction[]{property2.getGetter(), property2.getSetter()};
        for (IrSimpleFunction accessor : kotlin.collections.CollectionsKt.listOfNotNull((Object[])objectArray)) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = accessor.getParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (!(it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            if (!accessor.isFakeOverride() || ExportUtilsKt.isAllowedFakeOverriddenDeclaration(accessor, this.context)) continue;
            return null;
        }
        return this.exportPropertyUnsafely(property2);
    }

    private final ExportedDeclaration exportPropertyUnsafely(IrProperty property2) {
        String string = ExportUtilsKt.getExportedIdentifier(property2);
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        IrSimpleFunction irSimpleFunction2 = property2.getSetter();
        IrSimpleFunction irSimpleFunction3 = property2.getGetter();
        if (irSimpleFunction3 == null) {
            irSimpleFunction3 = property2.getSetter();
        }
        boolean bl = irSimpleFunction3 != null ? IrDeclarationsKt.isStaticMethodOfClass(irSimpleFunction3) : false;
        return new ExportedProperty(string, bl, irSimpleFunction, irSimpleFunction2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedProperty exportEnumEntry(IrField field) {
        IrEnumEntry irEnumEntry = JsIrAttributesKt.getCorrespondingEnumEntry(field);
        if (irEnumEntry == null) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unable to find enum entry";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumEntry_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportEnumEntry_u24lambda_u240.withIrEntry("field", field);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        IrEnumEntry irEnumEntry2 = irEnumEntry;
        String string = ExportUtilsKt.getExportedIdentifier(irEnumEntry2);
        IrSimpleFunction irSimpleFunction = JsIrAttributesKt.getGetInstanceFun(irEnumEntry2);
        if (irSimpleFunction == null) {
            void $this$exportEnumEntry_u24lambda_u241;
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unable to find get instance fun";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumEntry_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl3 = true;
            String string2 = string;
            boolean bl4 = false;
            $this$exportEnumEntry_u24lambda_u241.withIrEntry("field", field);
            Unit unit = Unit.INSTANCE;
            String string3 = string2;
            boolean bl5 = bl3;
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        IrFunction irFunction = null;
        IrFunction irFunction2 = irSimpleFunction;
        boolean bl = true;
        String string4 = string;
        return new ExportedProperty(string4, bl, irFunction2, irFunction, n, defaultConstructorMarker);
    }

    private final ExportedDeclaration exportDeclarationImplicitly(IrClass klass) {
        String name2 = ExportUtilsKt.getExportedIdentifier(klass);
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, null, 2, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return new ExportedRegularClass(name2, true, members, nestedClasses, klass);
    }

    private final ExportedDeclaration exportOrdinaryClass(IrClass klass) {
        Exportability exportability = ExportUtilsKt.exportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = ((Exportability.Prohibited)exportability).getReason();
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportOrdinaryClass_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportOrdinaryClass_u24lambda_u240.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass);
        }
        if (!Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, null, 2, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, members, nestedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportEnumClass(IrClass klass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Exportability exportability = ExportUtilsKt.exportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = ((Exportability.Prohibited)exportability).getReason();
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumClass_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportEnumClass_u24lambda_u240.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass);
        }
        if (!Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$filterIsInstance$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrField it = (IrField)element$iv$iv;
            boolean bl3 = false;
            if (JsIrAttributesKt.getCorrespondingEnumEntry(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        CollectionsKt.keysToMap(enumEntries, (Function1)new Function1<IrEnumEntry, Integer>((Object)enumEntries){

            public final Integer invoke(IrEnumEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((List)this.receiver).indexOf(p0);
            }
        });
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = this.exportClassDeclarations(klass, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)((Function1)arg_0 -> ExportModelGenerator.exportEnumClass$lambda$2(this, arg_0)));
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, members, nestedClasses);
    }

    private final ExportedClassDeclarationsInfo exportClassDeclarations(IrClass klass, Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration> specialProcessing) {
        List members = new ArrayList();
        List specialMembers = new ArrayList();
        List nestedClasses = new ArrayList();
        ExportUtilsKt.forEachExportedMember(klass, this.context, (Function2<? super IrDeclarationWithName, ? super IrDeclaration, Unit>)((Function2)(arg_0, arg_1) -> ExportModelGenerator.exportClassDeclarations$lambda$1(specialProcessing, specialMembers, members, this, klass, nestedClasses, arg_0, arg_1)));
        return new ExportedClassDeclarationsInfo(kotlin.collections.CollectionsKt.plus((Collection)specialMembers, (Iterable)members), nestedClasses);
    }

    static /* synthetic */ ExportedClassDeclarationsInfo exportClassDeclarations$default(ExportModelGenerator exportModelGenerator, IrClass irClass, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ExportModelGenerator::exportClassDeclarations$lambda$0;
        }
        return exportModelGenerator.exportClassDeclarations(irClass, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)function1);
    }

    private final ExportedDeclaration exportClass(IrClass klass, List<? extends ExportedDeclaration> members, List<? extends ExportedClass> nestedClasses) {
        String name2 = ExportUtilsKt.getExportedIdentifier(klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            IrSimpleFunction irSimpleFunction = JsIrAttributesKt.getObjectGetInstanceFunction(klass);
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            return new ExportedObject(name2, members, nestedClasses, klass, irSimpleFunction2);
        }
        return new ExportedRegularClass(name2, IrUtilsKt.isInterface(klass), members, nestedClasses, klass);
    }

    private final ExportedDeclaration exportAsEnumMember(IrDeclarationWithName candidate2) {
        IrDeclarationWithName irDeclarationWithName = candidate2;
        return irDeclarationWithName instanceof IrProperty ? (ExportUtilsKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)candidate2, this.context) ? this.exportPropertyUnsafely((IrProperty)candidate2) : null) : (irDeclarationWithName instanceof IrField ? (ExportedDeclaration)(Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRY()) ? this.exportEnumEntry((IrField)candidate2) : null) : null);
    }

    private static final ExportedDeclaration exportEnumClass$lambda$2(ExportModelGenerator this$0, IrDeclarationWithName candidate2) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        ExportedDeclaration enumExportedMember = this$0.exportAsEnumMember(candidate2);
        return enumExportedMember;
    }

    private static final ExportedDeclaration exportClassDeclarations$lambda$0(IrDeclarationWithName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit exportClassDeclarations$lambda$1(Function1 $specialProcessing, List $specialMembers, List $members, ExportModelGenerator this$0, IrClass $klass, List $nestedClasses, IrDeclarationWithName candidate2, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        ExportedDeclaration processingResult = (ExportedDeclaration)$specialProcessing.invoke((Object)candidate2);
        if (processingResult != null) {
            $specialMembers.add(processingResult);
            return Unit.INSTANCE;
        }
        IrDeclarationWithName irDeclarationWithName = candidate2;
        if (irDeclarationWithName instanceof IrSimpleFunction) {
            CollectionsKt.addIfNotNull($members, this$0.exportFunction((IrSimpleFunction)candidate2));
        } else {
            if (irDeclarationWithName instanceof IrConstructor) {
                return Unit.INSTANCE;
            }
            if (irDeclarationWithName instanceof IrProperty) {
                CollectionsKt.addIfNotNull($members, this$0.exportProperty((IrProperty)candidate2));
            } else if (irDeclarationWithName instanceof IrClass) {
                if (IrUtilsKt.isInterface($klass)) {
                    ExportedClass exportedClass;
                    Collection collection = $nestedClasses;
                    IrClass irClass = AdditionalIrUtilsKt.companionObject($klass);
                    if (irClass != null) {
                        void it;
                        IrClass irClass2 = irClass;
                        Collection collection2 = collection;
                        boolean bl = false;
                        ExportedDeclaration exportedDeclaration = this$0.exportClass((IrClass)it);
                        exportedClass = exportedDeclaration instanceof ExportedClass ? (ExportedClass)exportedDeclaration : null;
                        collection = collection2;
                    } else {
                        exportedClass = null;
                    }
                    CollectionsKt.addIfNotNull(collection, exportedClass);
                } else {
                    ExportedDeclaration ec = this$0.exportClass((IrClass)candidate2);
                    if (ec instanceof ExportedClass) {
                        $nestedClasses.add(ec);
                    } else {
                        CollectionsKt.addIfNotNull($members, ec);
                    }
                }
            } else if (irDeclarationWithName instanceof IrField) {
                boolean ec;
                boolean bl = ec = Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS()) || ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                if (_Assertions.ENABLED && !ec) {
                    boolean $i$a$-assert-ExportModelGenerator$exportClassDeclarations$2$32 = false;
                    String $i$a$-assert-ExportModelGenerator$exportClassDeclarations$2$32 = "Unexpected field without property " + IrUtilsKt.getFqNameWhenAvailable(candidate2);
                    throw new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportClassDeclarations$2$32);
                }
            } else {
                IrExceptionBuilder irExceptionBuilder;
                String message$iv = "Can't export member declaration";
                boolean $i$f$irError = false;
                IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                boolean bl = false;
                IrExceptionBuilder $this$exportClassDeclarations_u24lambda_u241_u242 = $this$irError_u24lambda_u240$iv;
                boolean bl2 = false;
                $this$exportClassDeclarations_u24lambda_u241_u242.withIrEntry("declaration", declaration);
                IrExceptionBuilder builder$iv = irExceptionBuilder;
                throw new IllegalStateException(builder$iv.buildString().toString());
            }
        }
        return Unit.INSTANCE;
    }
}

