/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.JsSuspendFunctionWithGeneratorsLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.JsSuspendFunctionsLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendFunctionKind;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/JsSuspendFunctionWithGeneratorsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "jsYieldFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "jsYieldStarFunctionSymbol", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformSuspendFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "convertSuspendFunctionToGenerator", "functionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "backend.js"})
public final class JsSuspendFunctionWithGeneratorsLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol jsYieldFunctionSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol jsYieldStarFunctionSymbol;

    public JsSuspendFunctionWithGeneratorsLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.jsYieldFunctionSymbol = this.context.getSymbols().getJsYieldFunctionSymbol();
        this.jsYieldStarFunctionSymbol = this.context.getSymbols().getJsYieldStarFunctionSymbol();
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        if (!MiscKt.getCompileSuspendAsJsGenerator(this.context)) {
            return;
        }
        DeclarationTransformer.super.lower(irModule);
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).isSuspend()) {
            this.transformSuspendFunction((IrSimpleFunction)declaration);
        }
        return null;
    }

    private final void transformSuspendFunction(IrSimpleFunction function2) {
        IrBody irBody = function2.getBody();
        if (irBody == null) {
            return;
        }
        IrBody body = irBody;
        SuspendFunctionKind suspendFunctionKind = JsSuspendFunctionsLoweringKt.getSuspendFunctionKind(this.context, function2, body, false, this.jsYieldFunctionSymbol);
        if (suspendFunctionKind instanceof SuspendFunctionKind.NO_SUSPEND_CALLS) {
            JsSuspendFunctionWithGeneratorsLoweringKt.setShouldBeCompiledAsGenerator(function2, true);
        } else if (suspendFunctionKind instanceof SuspendFunctionKind.DELEGATING || suspendFunctionKind instanceof SuspendFunctionKind.NEEDS_STATE_MACHINE) {
            this.convertSuspendFunctionToGenerator(function2, body);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void convertSuspendFunctionToGenerator(IrSimpleFunction function2, IrBody functionBody) {
        JsSuspendFunctionWithGeneratorsLoweringKt.setShouldBeCompiledAsGenerator(function2, true);
        IrElementTransformerVoidKt.transformChildrenVoid(functionBody, new IrElementTransformerVoid(this){
            final /* synthetic */ JsSuspendFunctionWithGeneratorsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression call = super.visitCall(expression2);
                if (!(call instanceof IrCall) || !((IrSimpleFunction)((IrCall)call).getSymbol().getOwner()).isSuspend()) {
                    irExpression = call;
                } else {
                    IrCall irCall;
                    IrCall $this$visitCall_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, JsSuspendFunctionWithGeneratorsLowering.access$getJsYieldStarFunctionSymbol$p(this.this$0), call.getType(), CollectionsKt.listOf((Object)call.getType()), null, null, 0, 0, 120, null);
                    boolean bl = false;
                    $this$visitCall_u24lambda_u240.getArguments().set(0, call);
                    irExpression = irCall;
                }
                return irExpression;
            }
        });
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getJsYieldStarFunctionSymbol$p(JsSuspendFunctionWithGeneratorsLowering $this) {
        return $this.jsYieldStarFunctionSymbol;
    }
}

