/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;
import org.jetbrains.kotlin.ir.validation.checkers.expression.InlineFunctionUseSiteChecker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a9\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011\u001a1\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0014\u0010!\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a9\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u001dH\u0000R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010'\u001a1\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010-\u001a-\u0010.\u001a\u00020\u0007*\u00020/2\u0006\u00100\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00101\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "getEXCLUDED_PACKAGES_FROM_VARARG_VALIDATION", "()Ljava/util/HashSet;", "validateVararg", "", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrChecker;", "checker", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "varargElementType", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "(Lorg/jetbrains/kotlin/ir/validation/checkers/IrChecker;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;)V", "EXCLUDED_MODULE_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "getEXCLUDED_MODULE_NAMES", "()Ljava/util/Set;", "visibilityError", "element", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "(Lorg/jetbrains/kotlin/ir/validation/checkers/IrChecker;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/descriptors/Visibility;Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;)V", "isVisibleAsInternal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isVisibleAsPrivate", "checkVisibility", "referencedDeclarationSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "reference", "treatInternalAsPublic", "(Lorg/jetbrains/kotlin/ir/validation/checkers/IrChecker;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;Z)V", "checkFunctionUseSite", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "inlineFunctionUseSiteChecker", "Lorg/jetbrains/kotlin/ir/validation/checkers/expression/InlineFunctionUseSiteChecker;", "(Lorg/jetbrains/kotlin/ir/validation/checkers/IrChecker;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/ir/validation/checkers/expression/InlineFunctionUseSiteChecker;Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;)V", "ensureTypeIs", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expectedType", "(Lorg/jetbrains/kotlin/ir/validation/checkers/IrChecker;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;)V", "ir.validation"})
@SourceDebugExtension(value={"SMAP\nCheckerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/ir/validation/checkers/CheckerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,182:1\n1#2:183\n1661#3,3:184\n12040#4,3:187\n*S KotlinDebug\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/ir/validation/checkers/CheckerUtilsKt\n*L\n35#1:184,3\n70#1:187,3\n*E\n"})
public final class CheckerUtilsKt {
    @NotNull
    private static final HashSet<FqName> EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION;
    @NotNull
    private static final Set<Name> EXCLUDED_MODULE_NAMES;

    @NotNull
    public static final HashSet<FqName> getEXCLUDED_PACKAGES_FROM_VARARG_VALIDATION() {
        return EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void validateVararg(@NotNull IrChecker checker, @NotNull IrElement irElement, @NotNull IrType type, @NotNull IrType varargElementType, @NotNull CheckerContext context2) {
        Boolean isCorrectArrayOfPrimitiveOrUnsigned;
        Boolean bl;
        IrType primitiveOrUnsignedElementType;
        IrType irType;
        boolean isCorrectArrayOf;
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)varargElementType, (String)"varargElementType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getWithinAnnotationUsageSubTree() && EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION.contains(context2.getFile().getPackageFqName())) {
            return;
        }
        if (IrTypePredicatesKt.isArray(type) || IrTypePredicatesKt.isNullableArray(type)) {
            boolean bl2;
            IrTypeArgument it = (IrTypeArgument)CollectionsKt.single(((IrSimpleType)type).getArguments());
            boolean bl3 = false;
            IrTypeArgument irTypeArgument = it;
            if (irTypeArgument instanceof IrSimpleType) {
                bl2 = Intrinsics.areEqual((Object)it, (Object)varargElementType);
            } else if (irTypeArgument instanceof IrTypeProjection) {
                if (((IrTypeProjection)it).getVariance() == Variance.OUT_VARIANCE && Intrinsics.areEqual((Object)((IrTypeProjection)it).getType(), (Object)varargElementType)) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        boolean bl4 = isCorrectArrayOf = false;
        if (isCorrectArrayOf) {
            return;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(type);
        if (irClassifierSymbol != null) {
            IrClassifierSymbol classifier = irClassifierSymbol;
            boolean bl5 = false;
            irType = context2.getIrBuiltIns().getPrimitiveArrayElementTypes().get(classifier);
            if (irType == null) {
                irType = context2.getIrBuiltIns().getUnsignedArraysElementTypes().get(classifier);
            }
        } else {
            irType = null;
        }
        IrType irType2 = primitiveOrUnsignedElementType = irType;
        if (irType2 != null) {
            IrType it = irType2;
            boolean bl6 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)varargElementType);
        } else {
            bl = isCorrectArrayOfPrimitiveOrUnsigned = null;
        }
        if (Intrinsics.areEqual((Object)isCorrectArrayOfPrimitiveOrUnsigned, (Object)true)) {
            return;
        }
        context2.error(checker, irElement, "Vararg type=" + RenderIrElementKt.render$default(type, null, 1, null) + " is expected to be an array of its underlying varargElementType=" + RenderIrElementKt.render$default(varargElementType, null, 1, null));
    }

    @NotNull
    public static final Set<Name> getEXCLUDED_MODULE_NAMES() {
        return EXCLUDED_MODULE_NAMES;
    }

    private static final void visibilityError(IrChecker checker, IrElement element, Visibility visibility, CheckerContext context2) {
        String message2 = "The following element references " + (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Unknown.INSTANCE) ? "a declaration with unknown visibility:" : '\'' + visibility.getName() + "' declaration that is invisible in the current scope:");
        context2.error(checker, element, message2);
    }

    private static final boolean isVisibleAsInternal(IrDeclarationWithVisibility $this$isVisibleAsInternal, IrFile file) {
        IrPackageFragment referencedDeclarationPackageFragment = IrUtilsKt.getPackageFragment($this$isVisibleAsInternal);
        IrModuleFragment module2 = file.getModule();
        if (referencedDeclarationPackageFragment.getSymbol() instanceof DescriptorlessExternalPackageFragmentSymbol) {
            return Intrinsics.areEqual((Object)module2.getName().asString(), (Object)"<kotlin>");
        }
        return module2.getDescriptor().shouldSeeInternalsOf(IrPackageFragmentsKt.getModuleDescriptor(referencedDeclarationPackageFragment));
    }

    private static final boolean isVisibleAsPrivate(IrDeclarationWithVisibility $this$isVisibleAsPrivate, IrFile file) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$isVisibleAsPrivate);
        return Intrinsics.areEqual((Object)file.getFileEntry(), (Object)(irFile != null ? irFile.getFileEntry() : null));
    }

    public static final void checkVisibility(@NotNull IrChecker checker, @NotNull IrSymbol referencedDeclarationSymbol, @NotNull IrElement reference2, @NotNull CheckerContext context2, boolean treatInternalAsPublic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter((Object)referencedDeclarationSymbol, (String)"referencedDeclarationSymbol");
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrOverridableDeclaration irOverridableDeclaration = reference2 instanceof IrOverridableDeclaration ? (IrOverridableDeclaration)reference2 : null;
        boolean bl2 = irOverridableDeclaration != null ? irOverridableDeclaration.isFakeOverride() : false;
        if (bl2 && CollectionsKt.contains((Iterable)((IrOverridableDeclaration)reference2).getOverriddenSymbols(), (Object)referencedDeclarationSymbol)) {
            return;
        }
        if (reference2 instanceof IrClass && CollectionsKt.contains((Iterable)((IrClass)reference2).getSealedSubclasses(), (Object)referencedDeclarationSymbol)) {
            return;
        }
        if (context2.getWithinAnnotationUsageSubTree()) {
            return;
        }
        if (EXCLUDED_MODULE_NAMES.contains(context2.getFile().getModule().getName())) {
            return;
        }
        IrSymbolOwner irSymbolOwner = referencedDeclarationSymbol.getOwner();
        IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
        if (irDeclarationWithVisibility == null) {
            return;
        }
        IrDeclarationWithVisibility referencedDeclaration = irDeclarationWithVisibility;
        IrClass classOfReferenced = IrUtilsKt.getParentClassOrNull(referencedDeclaration);
        Visibility visibility = referencedDeclaration.getVisibility().getDelegate();
        IrClass irClass = classOfReferenced;
        EffectiveVisibility effectiveVisibility = EffectiveVisibilityKt.toEffectiveVisibilityOrNull(visibility, irClass != null ? irClass.getSymbol() : null, true, treatInternalAsPublic || IrUtilsKt.isPublishedApi(referencedDeclaration));
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility;
        if (effectiveVisibility2 instanceof EffectiveVisibility.Internal || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtected || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtectedBound) {
            bl = CheckerUtilsKt.isVisibleAsInternal(referencedDeclaration, context2.getFile());
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Local || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInClass || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInFile) {
            bl = CheckerUtilsKt.isVisibleAsPrivate(referencedDeclaration, context2.getFile());
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.PackagePrivate || effectiveVisibility2 instanceof EffectiveVisibility.Protected || effectiveVisibility2 instanceof EffectiveVisibility.ProtectedBound || effectiveVisibility2 instanceof EffectiveVisibility.Public) {
            bl = true;
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Unknown || effectiveVisibility2 == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVisible = bl;
        if (!isVisible) {
            CheckerUtilsKt.visibilityError(checker, reference2, visibility, context2);
        }
    }

    public static final void checkFunctionUseSite(@NotNull IrChecker checker, @NotNull IrFunctionAccessExpression expression2, @NotNull InlineFunctionUseSiteChecker inlineFunctionUseSiteChecker, @NotNull CheckerContext context2) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)inlineFunctionUseSiteChecker, (String)"inlineFunctionUseSiteChecker");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!((IrFunctionSymbol)expression2.getSymbol()).isBound()) {
            return;
        }
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        if (!function2.isInline() || inlineFunctionUseSiteChecker.isPermitted(expression2)) {
            return;
        }
        StringBuilder $this$checkFunctionUseSite_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$checkFunctionUseSite_u24lambda_u240.append("The following element references ").append(function2.getVisibility()).append(" inline ");
        IrFunction irFunction = function2;
        if (irFunction instanceof IrSimpleFunction) {
            string = AdditionalIrUtilsKt.isAccessor(function2) ? "property accessor" : "function";
        } else if (irFunction instanceof IrConstructor) {
            string = "constructor";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$checkFunctionUseSite_u24lambda_u240.append(string);
        $this$checkFunctionUseSite_u24lambda_u240.append(" ").append(function2.getName().asString());
        String message2 = stringBuilder.toString();
        context2.error(checker, expression2, message2);
    }

    public static final void ensureTypeIs(@NotNull IrChecker checker, @NotNull IrExpression $this$ensureTypeIs, @NotNull IrType expectedType, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter((Object)$this$ensureTypeIs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Intrinsics.areEqual((Object)$this$ensureTypeIs.getType(), (Object)expectedType)) {
            context2.error(checker, $this$ensureTypeIs, "unexpected type: expected " + RenderIrElementKt.render$default(expectedType, null, 1, null) + ", got " + RenderIrElementKt.render$default($this$ensureTypeIs.getType(), null, 1, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Collection collection;
        String[] $this$mapTo$iv;
        Object object = new String[]{"kotlinx.serialization.modules", "kotlinx.serialization.json", "kotlinx.serialization.json.internal"};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv) {
            void p0;
            String string = (String)t;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new FqName((String)p0));
        }
        EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION = (HashSet)destination$iv;
        $this$mapTo$iv = new String[]{"stdlib", "kotlin", "kotlin", "kotlin-test"};
        destination$iv = new LinkedHashSet();
        $i$f$mapTo = false;
        int n = $this$mapTo$iv.length;
        for (int i = 0; i < n; ++i) {
            void it;
            String item$iv;
            String bl = item$iv = $this$mapTo$iv[i];
            collection = destination$iv;
            boolean bl2 = false;
            collection.add(Name.special('<' + (String)it + '>'));
        }
        EXCLUDED_MODULE_NAMES = (Set)var1_1;
    }
}

