/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans;

import java.util.AbstractCollection;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanIterators;

public abstract class AbstractBooleanCollection
extends AbstractCollection<Boolean>
implements BooleanCollection {
    protected AbstractBooleanCollection() {
    }

    @Override
    public abstract BooleanIterator iterator();

    @Override
    public boolean add(boolean k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(boolean k) {
        BooleanIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextBoolean()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(boolean k) {
        BooleanIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextBoolean()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Boolean key) {
        return BooleanCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return BooleanCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return BooleanCollection.super.remove(key);
    }

    @Override
    public boolean[] toBooleanArray() {
        int size = this.size();
        if (size == 0) {
            return BooleanArrays.EMPTY_ARRAY;
        }
        boolean[] a = new boolean[size];
        BooleanIterators.unwrap(this.iterator(), a);
        return a;
    }

    public boolean addAll(BooleanCollection c) {
        boolean retVal = false;
        BooleanIterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.add(i.nextBoolean())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> c) {
        if (c instanceof BooleanCollection) {
            return this.addAll((BooleanCollection)c);
        }
        return super.addAll(c);
    }

    public boolean containsAll(BooleanCollection c) {
        BooleanIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.nextBoolean())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof BooleanCollection) {
            return this.containsAll((BooleanCollection)c);
        }
        return super.containsAll(c);
    }

    public boolean removeAll(BooleanCollection c) {
        boolean retVal = false;
        BooleanIterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.rem(i.nextBoolean())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof BooleanCollection) {
            return this.removeAll((BooleanCollection)c);
        }
        return super.removeAll(c);
    }

    public boolean retainAll(BooleanCollection c) {
        boolean retVal = false;
        BooleanIterator i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.nextBoolean())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof BooleanCollection) {
            return this.retainAll((BooleanCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        BooleanIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            boolean k = i.nextBoolean();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

