/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KotlinValueClassRepresentation;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtClassElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinClassStubImpl;", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "()V", "shouldCreateStub", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "createStub", "psi", "parentStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/IndexSink;", "psi-impl"})
public final class KtClassElementType
extends KtStubElementType<KotlinClassStubImpl, KtClass> {
    @NotNull
    public static final KtClassElementType INSTANCE = new KtClassElementType();

    private KtClassElementType() {
        super("CLASS", KtClass.class, KotlinClassStub.class);
    }

    @Override
    public boolean shouldCreateStub(@Nullable ASTNode node) {
        return true;
    }

    @Override
    @NotNull
    public KotlinClassStubImpl createStub(@NotNull KtClass psi, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        FqName fqName = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        String fqName2 = fqName != null ? fqName.asString() : null;
        ClassId classId = StubUtils.createNestedClassId(parentStub, psi);
        String name2 = psi.getName();
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi);
        boolean isInterface = psi.isInterface();
        boolean isLocal = psi.isLocal();
        boolean isTopLevel = psi.isTopLevel();
        return new KotlinClassStubImpl(parentStub, StringRef.fromString(fqName2), classId, StringRef.fromString(name2), Utils.INSTANCE.wrapStrings(superNames), isInterface, false, isLocal, isTopLevel, null);
    }

    @Override
    public void serialize(@NotNull KotlinClassStubImpl stub, @NotNull StubOutputStream dataStream) {
        KotlinValueClassRepresentation representation;
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.asString() : null);
        StubUtils.serializeClassId(dataStream, stub.getClassId());
        dataStream.writeBoolean(stub.isInterface());
        dataStream.writeBoolean(stub.isClsStubCompiledToJvmDefaultImplementation());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isTopLevel());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name2 : superNames) {
            dataStream.writeName(name2);
        }
        KotlinValueClassRepresentation kotlinValueClassRepresentation = representation = stub.getValueClassRepresentation();
        dataStream.writeVarInt(kotlinValueClassRepresentation == null ? 0 : kotlinValueClassRepresentation.ordinal() + 1);
    }

    @Override
    @NotNull
    public KotlinClassStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name2 = dataStream.readName();
        StringRef qualifiedName = dataStream.readName();
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isInterface = dataStream.readBoolean();
        boolean isClsStubCompiledToJvmDefaultImplementation = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] stringRefArray = StringRef.createArray(superCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringRefArray, (String)"createArray(...)");
        StringRef[] superNames = stringRefArray;
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        int representationOrdinal = dataStream.readVarInt();
        KotlinValueClassRepresentation representation = representationOrdinal == 0 ? null : (KotlinValueClassRepresentation)((Object)KotlinValueClassRepresentation.getEntries().get(representationOrdinal - 1));
        return new KotlinClassStubImpl(parentStub, qualifiedName, classId, name2, superNames, isInterface, isClsStubCompiledToJvmDefaultImplementation, isLocal, isTopLevel, representation);
    }

    @Override
    public void indexStub(@NotNull KotlinClassStubImpl stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        StubIndexService.Companion.getInstance().indexClass(stub, sink);
    }
}

