/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstructionKt;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016J\f\u0010\u001e\u001a\u00020\u0010*\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004H\u0014J\u0016\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010%\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010'\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010)\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0*2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J8\u0010,\u001a\u00020\u00102\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001003H\u0086\b\u00f8\u0001\u0000J6\u00104\u001a\u00020\u00102\b\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001052\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001003H\u0086\b\u00f8\u0001\u0000J6\u00106\u001a\u00020\u00102\b\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001052\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001003H\u0086\b\u00f8\u0001\u0000J\u001c\u00107\u001a\u00020\u00102\b\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000105J\u0012\u00108\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0012\u00104\u001a\u00020\u000e2\n\b\u0002\u0010/\u001a\u0004\u0018\u000105J\u0012\u00109\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001e\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J>\u0010=\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010C\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010D\u001a\u00020\u00102\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000e0*2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010F\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010G\u001a\u00020\u00102\n\b\u0002\u0010/\u001a\u0004\u0018\u0001052\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001003J:\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u00020J2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010J2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001052\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001003J\u001c\u0010L\u001a\u00020J2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000e0*2\u0006\u0010<\u001a\u00020\u000eJ\u000e\u0010M\u001a\u00020J2\u0006\u0010<\u001a\u00020\u000eJ\u000e\u0010N\u001a\u00020J2\u0006\u0010<\u001a\u00020\u000eJ*\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020Q2\u0006\u0010<\u001a\u00020\u000e2\u0010\b\u0002\u0010E\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010*H\u0002J\u001e\u0010R\u001a\u00020\u00102\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000e0*2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0006\u0010S\u001a\u00020\u0010J\u0016\u0010T\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010U\u001a\u00020\u00102\u0006\u0010V\u001a\u00020W2\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010X\u001a\u00020\u00102\u0006\u0010V\u001a\u00020Y2\u000e\b\u0002\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000e002\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010[\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020]2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010^\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020]2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010_\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020]2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010`\u001a\u00020\u00102\u0006\u0010a\u001a\u00020b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010c\u001a\u00020\u00102\u0006\u0010a\u001a\u00020b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010d\u001a\u00020\u00102\u0006\u0010e\u001a\u00020Y2\u0006\u0010f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010g\u001a\u00020\u00102\u0006\u0010e\u001a\u00020Y2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010h\u001a\u00020\u00102\u0006\u0010e\u001a\u00020Y2\u0006\u0010f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010i\u001a\u00020\u00102\u0006\u0010j\u001a\u00020A2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010k\u001a\u00020\u00102\u0006\u0010j\u001a\u00020A2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010l\u001a\u00020\u00102\u0006\u0010j\u001a\u00020A2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010m\u001a\u00020\u00102\u0006\u0010n\u001a\u00020A2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010o\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010p\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010q\u001a\u00020\u00102\f\u0010r\u001a\b\u0012\u0004\u0012\u00020.0sH\u0086\b\u00f8\u0001\u0000J\u001a\u0010t\u001a\u00020\u00102\f\u0010r\u001a\b\u0012\u0004\u0012\u00020.0sH\u0086\b\u00f8\u0001\u0000J\u0006\u0010u\u001a\u00020\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006v"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "skipCommentInstructions", "", "<init>", "(Ljava/util/List;Z)V", "getExpression", "()Ljava/util/List;", "getSkipCommentInstructions", "()Z", "_numberOfNestedBlocks", "", "buildInstr", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "immediate", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "immediate1", "immediate2", "immediate3", "immediate4", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "appendInstruction", "appendToExpression", "instruction", "buildConstI32", "value", "buildConstI64", "", "buildConstF32", "", "buildConstF64", "", "buildConstI32Symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "buildUnreachable", "buildFunctionTypedBlock", "label", "", "resultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "body", "Lkotlin/Function1;", "buildBlock", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "buildLoop", "buildIf", "buildElse", "buildEnd", "buildBrInstr", "brOp", "absoluteBlockLevel", "buildBrOnCastInstr", "fromIsNullable", "toIsNullable", "from", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "to", "buildBr", "buildThrow", "tagIdx", "buildThrowRef", "buildTry", "buildTryTable", "catch1", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch;", "catch2", "createNewCatch", "createNewCatchAll", "createNewCatchAllRef", "createNewCatchImmediate", "catchType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch$CatchType;", "buildCatch", "buildCatchAll", "buildBrIf", "buildCall", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$FuncIdx;", "buildCallIndirect", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$TypeIdx;", "tableIdx", "buildGetLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "buildSetLocal", "buildTeeLocal", "buildGetGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$GlobalIdx;", "buildSetGlobal", "buildStructGet", "struct", "fieldId", "buildStructNew", "buildStructSet", "buildRefCastNullStatic", "toType", "buildRefCastStatic", "buildRefTestStatic", "buildRefNull", "type", "buildDrop", "buildNop", "commentPreviousInstr", "text", "Lkotlin/Function0;", "commentGroupStart", "commentGroupEnd", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n1#2:406\n*E\n"})
public class WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    private final boolean skipCommentInstructions;
    private int _numberOfNestedBlocks;

    public WasmExpressionBuilder(@NotNull List<WasmInstr> expression2, boolean skipCommentInstructions) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        this.expression = expression2;
        this.skipCommentInstructions = skipCommentInstructions;
    }

    public /* synthetic */ WasmExpressionBuilder(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(list, bl);
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    public final boolean getSkipCommentInstructions() {
        return this.skipCommentInstructions;
    }

    public final void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.appendInstruction(WasmInstructionKt.wasmInstrWithLocation(op, location));
    }

    public final void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, @NotNull WasmImmediate immediate) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)immediate, (String)"immediate");
        this.appendInstruction(WasmInstructionKt.wasmInstrWithLocation(op, location, immediate));
    }

    public final void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, @NotNull WasmImmediate immediate1, @NotNull WasmImmediate immediate2) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)immediate1, (String)"immediate1");
        Intrinsics.checkNotNullParameter((Object)immediate2, (String)"immediate2");
        this.appendInstruction(WasmInstructionKt.wasmInstrWithLocation(op, location, immediate1, immediate2));
    }

    public final void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, @NotNull WasmImmediate immediate1, @NotNull WasmImmediate immediate2, @NotNull WasmImmediate immediate3) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)immediate1, (String)"immediate1");
        Intrinsics.checkNotNullParameter((Object)immediate2, (String)"immediate2");
        Intrinsics.checkNotNullParameter((Object)immediate3, (String)"immediate3");
        this.appendInstruction(WasmInstructionKt.wasmInstrWithLocation(op, location, immediate1, immediate2, immediate3));
    }

    public final void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, @NotNull WasmImmediate immediate1, @NotNull WasmImmediate immediate2, @NotNull WasmImmediate immediate3, @NotNull WasmImmediate immediate4) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)immediate1, (String)"immediate1");
        Intrinsics.checkNotNullParameter((Object)immediate2, (String)"immediate2");
        Intrinsics.checkNotNullParameter((Object)immediate3, (String)"immediate3");
        Intrinsics.checkNotNullParameter((Object)immediate4, (String)"immediate4");
        this.appendInstruction(WasmInstructionKt.wasmInstrWithLocation(op, location, immediate1, immediate2, immediate3, immediate4));
    }

    public final int getNumberOfNestedBlocks() {
        return this._numberOfNestedBlocks;
    }

    private final void appendInstruction(WasmInstr $this$appendInstruction) {
        if (WasmExpressionBuilderKt.isBlockStart($this$appendInstruction.getOperator())) {
            int n = this._numberOfNestedBlocks;
            this._numberOfNestedBlocks = n + 1;
        } else if (WasmExpressionBuilderKt.isBlockEnd($this$appendInstruction.getOperator())) {
            int n = this._numberOfNestedBlocks;
            this._numberOfNestedBlocks = n + -1;
        }
        this.appendToExpression($this$appendInstruction);
    }

    protected void appendToExpression(@NotNull WasmInstr instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.expression.add(instruction);
    }

    public final void buildConstI32(int value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.I32_CONST, location, new WasmImmediate.ConstI32(value2));
    }

    public final void buildConstI64(long value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.I64_CONST, location, new WasmImmediate.ConstI64(value2));
    }

    public final void buildConstF32(float value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.F32_CONST, location, new WasmImmediate.ConstF32(UInt.constructor-impl((int)Float.floatToRawIntBits(value2)), null));
    }

    public final void buildConstF64(double value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.F64_CONST, location, new WasmImmediate.ConstF64(ULong.constructor-impl((long)Double.doubleToRawLongBits(value2)), null));
    }

    public final void buildConstI32Symbol(@NotNull WasmSymbol<Integer> value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.I32_CONST, location, new WasmImmediate.SymbolI32(value2));
    }

    public final void buildUnreachable(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.UNREACHABLE, location);
    }

    public final void buildFunctionTypedBlock(@Nullable String label, @NotNull WasmSymbolReadOnly<WasmFunctionType> resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(resultType, (String)"resultType");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$buildFunctionTypedBlock = false;
        this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), new WasmImmediate.BlockType.Function(resultType));
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public final void buildBlock(@Nullable String label, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$buildBlock = false;
        this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), new WasmImmediate.BlockType.Value(resultType));
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public static /* synthetic */ void buildBlock$default(WasmExpressionBuilder $this, String label, WasmType resultType, Function1 body, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        boolean $i$f$buildBlock = false;
        $this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), new WasmImmediate.BlockType.Value(resultType));
        body.invoke((Object)$this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default($this, null, 1, null);
    }

    public final void buildLoop(@Nullable String label, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$buildLoop = false;
        this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), new WasmImmediate.BlockType.Value(resultType));
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public static /* synthetic */ void buildLoop$default(WasmExpressionBuilder $this, String label, WasmType resultType, Function1 body, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildLoop");
        }
        if ((n & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        boolean $i$f$buildLoop = false;
        $this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), new WasmImmediate.BlockType.Value(resultType));
        body.invoke((Object)$this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default($this, null, 1, null);
    }

    public final void buildIf(@Nullable String label, @Nullable WasmType resultType) {
        this.buildInstr(WasmOp.IF, SourceLocation.NoLocation.INSTANCE, new WasmImmediate.BlockType.Value(resultType));
    }

    public static /* synthetic */ void buildIf$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildIf");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildIf(string, wasmType);
    }

    public final void buildElse(@Nullable SourceLocation location) {
        SourceLocation sourceLocation = location;
        if (sourceLocation == null) {
            sourceLocation = SourceLocation.NoLocation.INSTANCE;
        }
        this.buildInstr(WasmOp.ELSE, sourceLocation);
    }

    public static /* synthetic */ void buildElse$default(WasmExpressionBuilder wasmExpressionBuilder, SourceLocation sourceLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildElse");
        }
        if ((n & 1) != 0) {
            sourceLocation = null;
        }
        wasmExpressionBuilder.buildElse(sourceLocation);
    }

    public final int buildBlock(@Nullable WasmType resultType) {
        this.buildInstr(WasmOp.BLOCK, SourceLocation.NoLocation.INSTANCE, new WasmImmediate.BlockType.Value(resultType));
        return this.getNumberOfNestedBlocks();
    }

    public static /* synthetic */ int buildBlock$default(WasmExpressionBuilder wasmExpressionBuilder, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 1) != 0) {
            wasmType = null;
        }
        return wasmExpressionBuilder.buildBlock(wasmType);
    }

    public final void buildEnd(@Nullable SourceLocation location) {
        SourceLocation sourceLocation = location;
        if (sourceLocation == null) {
            sourceLocation = SourceLocation.NoLocation.INSTANCE;
        }
        this.buildInstr(WasmOp.END, sourceLocation);
    }

    public static /* synthetic */ void buildEnd$default(WasmExpressionBuilder wasmExpressionBuilder, SourceLocation sourceLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildEnd");
        }
        if ((n & 1) != 0) {
            sourceLocation = null;
        }
        wasmExpressionBuilder.buildEnd(sourceLocation);
    }

    public final void buildBrInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)brOp), (String)"brOp");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        this.buildInstr(brOp, location, new WasmImmediate.LabelIdx(relativeLevel));
    }

    public final void buildBrOnCastInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, boolean fromIsNullable, boolean toIsNullable, @NotNull WasmHeapType from2, @NotNull WasmHeapType to, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)brOp), (String)"brOp");
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = false;
            String $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = "Negative relative block index";
            throw new AssertionError((Object)$i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22);
        }
        int fromTypeFlag = fromIsNullable ? 1 : 0;
        int toTypeFlag = toIsNullable ? 2 : 0;
        int flags = fromTypeFlag | toTypeFlag;
        this.buildInstr(brOp, location, new WasmImmediate.ConstU8(UByte.constructor-impl((byte)((byte)flags)), null), new WasmImmediate.LabelIdx(relativeLevel), new WasmImmediate.HeapType(from2), new WasmImmediate.HeapType(to));
    }

    public final void buildBr(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildBrInstr(WasmOp.BR, absoluteBlockLevel, location);
    }

    public final void buildThrow(@NotNull WasmSymbol<Integer> tagIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(tagIdx, (String)"tagIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.THROW, location, new WasmImmediate.TagIdx(tagIdx));
    }

    public final void buildThrowRef(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.THROW_REF, location);
    }

    public final void buildTry(@Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.buildInstr(WasmOp.TRY, SourceLocation.NoLocation.INSTANCE, new WasmImmediate.BlockType.Value(resultType));
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public static /* synthetic */ void buildTry$default(WasmExpressionBuilder wasmExpressionBuilder, WasmType wasmType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTry");
        }
        if ((n & 1) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTry(wasmType, (Function1<? super Integer, Unit>)function1);
    }

    public final void buildTryTable(@NotNull WasmImmediate.Catch catch1, @Nullable WasmImmediate.Catch catch2, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body) {
        int catchSize;
        Intrinsics.checkNotNullParameter((Object)catch1, (String)"catch1");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        int n = catchSize = catch2 == null ? 1 : 2;
        if (catch2 == null) {
            this.buildInstr(WasmOp.TRY_TABLE, SourceLocation.NoLocation.INSTANCE, new WasmImmediate.BlockType.Value(resultType), new WasmImmediate.ConstI32(catchSize), catch1);
        } else {
            this.buildInstr(WasmOp.TRY_TABLE, SourceLocation.NoLocation.INSTANCE, new WasmImmediate.BlockType.Value(resultType), new WasmImmediate.ConstI32(catchSize), catch1, catch2);
        }
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public static /* synthetic */ void buildTryTable$default(WasmExpressionBuilder wasmExpressionBuilder, WasmImmediate.Catch catch_, WasmImmediate.Catch catch_2, WasmType wasmType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTryTable");
        }
        if ((n & 2) != 0) {
            catch_2 = null;
        }
        if ((n & 4) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTryTable(catch_, catch_2, wasmType, (Function1<? super Integer, Unit>)function1);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatch(@NotNull WasmSymbol<Integer> tagIdx, int absoluteBlockLevel) {
        Intrinsics.checkNotNullParameter(tagIdx, (String)"tagIdx");
        return this.createNewCatchImmediate(WasmImmediate.Catch.CatchType.CATCH, absoluteBlockLevel, tagIdx);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatchAll(int absoluteBlockLevel) {
        return WasmExpressionBuilder.createNewCatchImmediate$default(this, WasmImmediate.Catch.CatchType.CATCH_ALL, absoluteBlockLevel, null, 4, null);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatchAllRef(int absoluteBlockLevel) {
        return WasmExpressionBuilder.createNewCatchImmediate$default(this, WasmImmediate.Catch.CatchType.CATCH_ALL_REF, absoluteBlockLevel, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final WasmImmediate.Catch createNewCatchImmediate(WasmImmediate.Catch.CatchType catchType, int absoluteBlockLevel, WasmSymbol<Integer> tagIdx) {
        WasmImmediate.TableIdx tableIdx;
        Object[] objectArray;
        boolean bl;
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        WasmImmediate.Catch.CatchType catchType2 = catchType;
        Object[] objectArray2 = objectArray = new WasmImmediate[2];
        int n = 0;
        WasmSymbol<Integer> wasmSymbol = tagIdx;
        if (wasmSymbol != null) {
            void p0;
            WasmSymbolReadOnly wasmSymbolReadOnly = wasmSymbol;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            WasmImmediate.Catch.CatchType catchType3 = catchType2;
            boolean bl4 = false;
            WasmImmediate.TableIdx tableIdx2 = new WasmImmediate.TableIdx((WasmSymbolReadOnly<Integer>)p0);
            catchType2 = catchType3;
            objectArray2 = objectArray3;
            n = n2;
            tableIdx = tableIdx2;
        } else {
            tableIdx = null;
        }
        objectArray2[n] = tableIdx;
        objectArray[1] = new WasmImmediate.LabelIdx(relativeLevel);
        List list = CollectionsKt.listOfNotNull((Object[])objectArray);
        WasmImmediate.Catch.CatchType catchType4 = catchType2;
        return new WasmImmediate.Catch(catchType4, list);
    }

    static /* synthetic */ WasmImmediate.Catch createNewCatchImmediate$default(WasmExpressionBuilder wasmExpressionBuilder, WasmImmediate.Catch.CatchType catchType, int n, WasmSymbol wasmSymbol, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createNewCatchImmediate");
        }
        if ((n2 & 4) != 0) {
            wasmSymbol = null;
        }
        return wasmExpressionBuilder.createNewCatchImmediate(catchType, n, wasmSymbol);
    }

    public final void buildCatch(@NotNull WasmSymbol<Integer> tagIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(tagIdx, (String)"tagIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.CATCH, location, new WasmImmediate.TagIdx(tagIdx));
    }

    public static /* synthetic */ void buildCatch$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, SourceLocation sourceLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCatch");
        }
        if ((n & 2) != 0) {
            sourceLocation = SourceLocation.Companion.NoLocation("Catch");
        }
        wasmExpressionBuilder.buildCatch(wasmSymbol, sourceLocation);
    }

    public final void buildCatchAll() {
        this.buildInstr(WasmOp.CATCH_ALL, SourceLocation.NoLocation.INSTANCE);
    }

    public final void buildBrIf(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildBrInstr(WasmOp.BR_IF, absoluteBlockLevel, location);
    }

    public final void buildCall(@NotNull WasmImmediate.FuncIdx symbol, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.CALL, location, symbol);
    }

    public final void buildCallIndirect(@NotNull WasmImmediate.TypeIdx symbol, @NotNull WasmSymbolReadOnly<Integer> tableIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter(tableIdx, (String)"tableIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.CALL_INDIRECT, location, symbol, new WasmImmediate.TableIdx(tableIdx));
    }

    public static /* synthetic */ void buildCallIndirect$default(WasmExpressionBuilder wasmExpressionBuilder, WasmImmediate.TypeIdx typeIdx, WasmSymbolReadOnly wasmSymbolReadOnly, SourceLocation sourceLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCallIndirect");
        }
        if ((n & 2) != 0) {
            wasmSymbolReadOnly = new WasmSymbol<Integer>(0);
        }
        wasmExpressionBuilder.buildCallIndirect(typeIdx, wasmSymbolReadOnly, sourceLocation);
    }

    public final void buildGetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.LOCAL_GET, location, new WasmImmediate.LocalIdx(local));
    }

    public final void buildSetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.LOCAL_SET, location, new WasmImmediate.LocalIdx(local));
    }

    public final void buildTeeLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.LOCAL_TEE, location, new WasmImmediate.LocalIdx(local));
    }

    public final void buildGetGlobal(@NotNull WasmImmediate.GlobalIdx global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.GLOBAL_GET, location, global);
    }

    public final void buildSetGlobal(@NotNull WasmImmediate.GlobalIdx global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.GLOBAL_SET, location, global);
    }

    public final void buildStructGet(@NotNull WasmImmediate.TypeIdx struct, int fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.STRUCT_GET, location, struct, new WasmImmediate.StructFieldIdx(fieldId));
    }

    public final void buildStructNew(@NotNull WasmImmediate.TypeIdx struct, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.STRUCT_NEW, location, struct);
    }

    public final void buildStructSet(@NotNull WasmImmediate.TypeIdx struct, int fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.STRUCT_SET, location, struct, new WasmImmediate.StructFieldIdx(fieldId));
    }

    public final void buildRefCastNullStatic(@NotNull WasmHeapType toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.REF_CAST_NULL, location, new WasmImmediate.HeapType(toType));
    }

    public final void buildRefCastStatic(@NotNull WasmHeapType toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.REF_CAST, location, new WasmImmediate.HeapType(toType));
    }

    public final void buildRefTestStatic(@NotNull WasmHeapType toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.REF_TEST, location, new WasmImmediate.HeapType(toType));
    }

    public final void buildRefNull(@NotNull WasmHeapType type, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.REF_NULL, location, new WasmImmediate.HeapType(new WasmRefType(type)));
    }

    public final void buildDrop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.DROP, location);
    }

    public final void buildNop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.NOP, location);
    }

    public final void commentPreviousInstr(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        boolean $i$f$commentPreviousInstr = false;
        if (!this.getSkipCommentInstructions()) {
            this.buildInstr(WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR, SourceLocation.Companion.NoLocation("Pseudo-instruction"), new WasmImmediate.ConstString((String)text.invoke()));
        }
    }

    public final void commentGroupStart(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        boolean $i$f$commentGroupStart = false;
        if (!this.getSkipCommentInstructions()) {
            this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_START, SourceLocation.Companion.NoLocation("Pseudo-instruction"), new WasmImmediate.ConstString((String)text.invoke()));
        }
    }

    public final void commentGroupEnd() {
        if (!this.skipCommentInstructions) {
            this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_END, SourceLocation.Companion.NoLocation("Pseudo-instruction"));
        }
    }
}

