/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.convertors.InstructionsFlowOptimizersKt;
import org.jetbrains.kotlin.wasm.ir.convertors.OptimizeFlow;
import org.jetbrains.kotlin.wasm.ir.convertors.OptimizeFlowBase;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/RemoveUnreachableInstructions;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlowBase;", "output", "Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlow;", "<init>", "(Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlow;)V", "eatEverythingUntilLevel", "", "Ljava/lang/Integer;", "numberOfNestedBlocks", "getCurrentEatLevel", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Ljava/lang/Integer;", "push", "", "instruction", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "wasm.ir"})
final class RemoveUnreachableInstructions
extends OptimizeFlowBase {
    @Nullable
    private Integer eatEverythingUntilLevel;
    private int numberOfNestedBlocks;

    public RemoveUnreachableInstructions(@NotNull OptimizeFlow output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        super(output2);
    }

    private final Integer getCurrentEatLevel(WasmOp op) {
        Integer n = this.eatEverythingUntilLevel;
        if (n == null) {
            return null;
        }
        int eatLevel = n;
        if (this.numberOfNestedBlocks == eatLevel && InstructionsFlowOptimizersKt.access$isInCfgNode(op)) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        if (this.numberOfNestedBlocks < eatLevel) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        return eatLevel;
    }

    @Override
    public void push(@NotNull WasmInstr instruction) {
        int n;
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        WasmOp op = instruction.getOperator();
        if (WasmExpressionBuilderKt.isBlockStart(op)) {
            n = this.numberOfNestedBlocks;
            this.numberOfNestedBlocks = n + 1;
        } else if (WasmExpressionBuilderKt.isBlockEnd(op)) {
            n = this.numberOfNestedBlocks;
            this.numberOfNestedBlocks = n + -1;
        }
        Integer currentEatUntil = this.getCurrentEatLevel(op);
        if (currentEatUntil != null) {
            if (currentEatUntil <= this.numberOfNestedBlocks) {
                return;
            }
        } else if (InstructionsFlowOptimizersKt.access$isOutCfgNode(op)) {
            this.eatEverythingUntilLevel = this.numberOfNestedBlocks;
        }
        this.getOutput().push(instruction);
    }
}

