/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.ImportIntoFragmentInliningScope;
import org.jetbrains.kotlin.js.inline.ImportIntoWrapperInliningScope;
import org.jetbrains.kotlin.js.inline.InlineAstVisitor;
import org.jetbrains.kotlin.js.inline.InlineFunctionDefinition;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.InlinerCycleReporter;
import org.jetbrains.kotlin.js.inline.InliningScope;
import org.jetbrains.kotlin.js.inline.context.FunctionDefinitionLoader;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010 \u001a\u00020!J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0006\u0010$\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/js/inline/JsInliner;", "", "reporter", "Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "translationResult", "Lorg/jetbrains/kotlin/js/translate/general/AstGenerationResult;", "<init>", "(Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;Lorg/jetbrains/kotlin/js/config/JsConfig;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/js/translate/general/AstGenerationResult;)V", "getReporter", "()Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "getConfig", "()Lorg/jetbrains/kotlin/js/config/JsConfig;", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getTranslationResult", "()Lorg/jetbrains/kotlin/js/translate/general/AstGenerationResult;", "functionDefinitionLoader", "Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "getFunctionDefinitionLoader", "()Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "cycleReporter", "Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter;", "getCycleReporter", "()Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter;", "process", "", "inlineFn", "Lorg/jetbrains/kotlin/js/inline/InlineFunctionDefinition;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "definitionFragment", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "callsiteScope", "Lorg/jetbrains/kotlin/js/inline/InliningScope;", "inline", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "scope", "currentStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "js.translator"})
public final class JsInliner {
    @NotNull
    private final JsConfig.Reporter reporter;
    @NotNull
    private final JsConfig config;
    @NotNull
    private final DiagnosticSink trace;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final AstGenerationResult translationResult;
    @NotNull
    private final FunctionDefinitionLoader functionDefinitionLoader;
    @NotNull
    private final InlinerCycleReporter cycleReporter;

    public JsInliner(@NotNull JsConfig.Reporter reporter, @NotNull JsConfig config, @NotNull DiagnosticSink trace, @NotNull BindingContext bindingContext, @NotNull AstGenerationResult translationResult) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        this.reporter = reporter;
        this.config = config;
        this.trace = trace;
        this.bindingContext = bindingContext;
        this.translationResult = translationResult;
        this.functionDefinitionLoader = new FunctionDefinitionLoader(this);
        this.cycleReporter = new InlinerCycleReporter(this.trace, this.functionDefinitionLoader);
    }

    @NotNull
    public final JsConfig.Reporter getReporter() {
        return this.reporter;
    }

    @NotNull
    public final JsConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final AstGenerationResult getTranslationResult() {
        return this.translationResult;
    }

    @NotNull
    public final FunctionDefinitionLoader getFunctionDefinitionLoader() {
        return this.functionDefinitionLoader;
    }

    @NotNull
    public final InlinerCycleReporter getCycleReporter() {
        return this.cycleReporter;
    }

    public final void process() {
        for (JsProgramFragment fragment : this.translationResult.getNewFragments()) {
            ImportIntoFragmentInliningScope.Companion.process(fragment, (Function1<? super ImportIntoFragmentInliningScope, Unit>)((Function1)arg_0 -> JsInliner.process$lambda$0(this, arg_0)));
        }
    }

    public final void process(@NotNull InlineFunctionDefinition inlineFn, @Nullable JsInvocation call2, @NotNull JsProgramFragment definitionFragment, @NotNull InliningScope callsiteScope) {
        Intrinsics.checkNotNullParameter((Object)inlineFn, (String)"inlineFn");
        Intrinsics.checkNotNullParameter((Object)definitionFragment, (String)"definitionFragment");
        Intrinsics.checkNotNullParameter((Object)callsiteScope, (String)"callsiteScope");
        if (!this.translationResult.getNewFragments().contains(definitionFragment)) {
            return;
        }
        this.cycleReporter.processInlineFunction(inlineFn.getFn(), call2, (Function0<Unit>)((Function0)() -> JsInliner.process$lambda$2(inlineFn, definitionFragment, this, callsiteScope)));
    }

    @NotNull
    public final InlineableResult inline(@NotNull InliningScope scope2, @NotNull JsInvocation call2, @Nullable JsStatement currentStatement) {
        JsExpression resultExpression;
        JsStatement inlineableBody;
        InliningContext inliningContext;
        block0: {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            InlineFunctionDefinition definition = this.functionDefinitionLoader.getFunctionDefinition(call2, scope2);
            JsFunction function2 = scope2.importFunctionDefinition(definition);
            inliningContext = new InliningContext(currentStatement);
            InlineableResult inlineableResult = FunctionInlineMutator.Companion.getInlineableCallReplacement(call2, function2, inliningContext);
            inlineableBody = inlineableResult.component1();
            resultExpression = inlineableResult.component2();
            new InlineAstVisitor(this, scope2).accept((JsNode)inlineableBody);
            JsExpression jsExpression = resultExpression;
            if (jsExpression == null) break block0;
            MetadataProperties.setSynthetic(jsExpression, true);
        }
        return new InlineableResult(new JsBlock(CollectionsKt.plus((Collection)inliningContext.getPreviousStatements(), (Object)inlineableBody)), resultExpression);
    }

    private static final Unit process$lambda$0(JsInliner this$0, ImportIntoFragmentInliningScope fragmentScope) {
        Intrinsics.checkNotNullParameter((Object)fragmentScope, (String)"fragmentScope");
        new InlineAstVisitor(this$0, fragmentScope).accept((JsNode)fragmentScope.getAllCode());
        return Unit.INSTANCE;
    }

    private static final Unit process$lambda$2$lambda$1(JsInliner this$0, JsBlock $wrapperBody, ImportIntoWrapperInliningScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        new InlineAstVisitor(this$0, scope2).accept((JsNode)$wrapperBody);
        return Unit.INSTANCE;
    }

    private static final Unit process$lambda$2(InlineFunctionDefinition $inlineFn, JsProgramFragment $definitionFragment, JsInliner this$0, InliningScope $callsiteScope) {
        FunctionWithWrapper functionWithWrapper = $inlineFn.getFn();
        JsFunction fn = functionWithWrapper.component1();
        JsBlock wrapperBody = functionWithWrapper.component2();
        if (wrapperBody != null) {
            ImportIntoWrapperInliningScope.Companion.process(wrapperBody, $definitionFragment, (Function1<? super ImportIntoWrapperInliningScope, Unit>)((Function1)arg_0 -> JsInliner.process$lambda$2$lambda$1(this$0, wrapperBody, arg_0)));
        } else {
            new InlineAstVisitor(this$0, $callsiteScope).accept((JsNode)fn);
        }
        return Unit.INSTANCE;
    }
}

