/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NamedFunAsExpressionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NamedFunAsExpressionChecker
implements CallChecker {
    @NotNull
    public static final NamedFunAsExpressionChecker INSTANCE = new NamedFunAsExpressionChecker();

    private NamedFunAsExpressionChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        for (ExpressionValueArgument argument : CollectionsKt.filterIsInstance((Iterable)resolvedCall2.getValueArguments().values(), ExpressionValueArgument.class)) {
            KtNamedFunction expression2;
            ValueArgument valueArgument = argument.getValueArgument();
            KtExpression ktExpression = KtPsiUtil.deparenthesize(valueArgument != null ? valueArgument.getArgumentExpression() : null);
            KtNamedFunction ktNamedFunction = ktExpression instanceof KtNamedFunction ? (KtNamedFunction)ktExpression : null;
            if (ktNamedFunction == null || KtPsiUtilKt.isFunctionalExpression(expression2 = ktNamedFunction)) continue;
            BindingTrace bindingTrace = context2.getTrace();
            PsiElement psiElement = expression2.getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiElement);
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }
}

