/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.sources.InternalKotlinSourceSetKt;
import org.jetbrains.kotlin.gradle.plugin.sources.UnsatisfiedSourceSetVisibilityException;
import org.jetbrains.kotlin.gradle.utils.MutableObservableSet;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u0007\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\t\u001a \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\nH\u0000\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000f\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"checkSourceSetVisibilityRequirements", "", "sourceSets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "project", "Lorg/gradle/api/Project;", "getSourceSetsFromAssociatedCompilations", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "", "fromCompilation", "getVisibleSourceSetsFromAssociateCompilations", "", "participatesInCompilations", "sourceSet", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nSourceSetsVisibilityInference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceSetsVisibilityInference.kt\norg/jetbrains/kotlin/gradle/plugin/sources/SourceSetsVisibilityInferenceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1179#2,2:150\n1253#2,4:152\n1549#2:156\n1620#2,3:157\n1855#2,2:160\n1855#2,2:162\n*E\n*S KotlinDebug\n*F\n+ 1 SourceSetsVisibilityInference.kt\norg/jetbrains/kotlin/gradle/plugin/sources/SourceSetsVisibilityInferenceKt\n*L\n16#1,2:150\n16#1,4:152\n25#1:156\n25#1,3:157\n43#1,2:160\n130#1,2:162\n*E\n"})
public final class SourceSetsVisibilityInferenceKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<KotlinCompilation<?>, Set<KotlinSourceSet>> getSourceSetsFromAssociatedCompilations(@NotNull KotlinCompilation<?> fromCompilation) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(fromCompilation, (String)"fromCompilation");
        Iterable<KotlinCompilation<?>> $this$associate$iv = KotlinCompilationsKt.getAssociateWithClosure(fromCompilation);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<KotlinCompilation<?>> iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            KotlinCompilation it = (KotlinCompilation)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)it.getAllKotlinSourceSets());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final List<KotlinSourceSet> getVisibleSourceSetsFromAssociateCompilations(@NotNull KotlinSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        return SourceSetsVisibilityInferenceKt.getVisibleSourceSetsFromAssociateCompilations((Set)InternalKotlinSourceSetKt.getInternal(sourceSet).getCompilations());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinSourceSet> getVisibleSourceSetsFromAssociateCompilations(@NotNull Set<? extends KotlinCompilation<?>> participatesInCompilations) {
        Set set2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participatesInCompilations, (String)"participatesInCompilations");
        Iterable $this$map$iv = participatesInCompilations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Set set3;
            void it;
            KotlinCompilation kotlinCompilation = (KotlinCompilation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<KotlinCompilation<?>, Set<KotlinSourceSet>> sourceSetsInAssociatedCompilations = SourceSetsVisibilityInferenceKt.getSourceSetsFromAssociatedCompilations(it);
            switch (sourceSetsInAssociatedCompilations.size()) {
                case 0: {
                    set3 = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    set3 = (Set)CollectionsKt.single((Iterable)sourceSetsInAssociatedCompilations.values());
                    break;
                }
                default: {
                    Set set4;
                    Set $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u242_u24lambda_u241 = set4 = (Set)new LinkedHashSet();
                    boolean bl2 = false;
                    Iterator<Map.Entry<KotlinCompilation<?>, Set<KotlinSourceSet>>> iterator = sourceSetsInAssociatedCompilations.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Set<KotlinSourceSet> sourceSets = iterator.next().getValue();
                        $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u242_u24lambda_u241.addAll((Collection)sourceSets);
                    }
                    set3 = set4;
                }
            }
            collection.add(set3);
        }
        List visibleInCompilations = (List)destination$iv$iv;
        switch (visibleInCompilations.size()) {
            case 0: {
                set2 = SetsKt.emptySet();
                break;
            }
            case 1: {
                set2 = (Set)CollectionsKt.single((List)visibleInCompilations);
                break;
            }
            default: {
                Set set5;
                Set $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u244 = set5 = CollectionsKt.toMutableSet((Iterable)((Iterable)CollectionsKt.first((List)visibleInCompilations)));
                boolean bl = false;
                Iterable $this$forEach$iv = visibleInCompilations.subList(1, visibleInCompilations.size());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Set it = (Set)element$iv;
                    boolean bl3 = false;
                    $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u244.retainAll(it);
                }
                set2 = set5;
            }
        }
        return CollectionsKt.toList((Iterable)set2);
    }

    public static final void checkSourceSetVisibilityRequirements(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SourceSetsVisibilityInferenceKt.checkSourceSetVisibilityRequirements((Iterable)KotlinProjectExtensionKt.getKotlinExtension(project).getSourceSets());
    }

    public static final void checkSourceSetVisibilityRequirements(@NotNull Iterable<? extends KotlinSourceSet> sourceSets) {
        Intrinsics.checkNotNullParameter(sourceSets, (String)"sourceSets");
        Iterable<? extends KotlinSourceSet> $this$forEach$iv = sourceSets;
        boolean $i$f$forEach = false;
        Iterator<? extends KotlinSourceSet> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            List<KotlinSourceSet> inferredVisibility;
            KotlinSourceSet element$iv;
            KotlinSourceSet sourceSet = element$iv = iterator.next();
            boolean bl = false;
            Set requiredVisibility = sourceSet.getRequiresVisibilityOf();
            Set requiredButNotVisible = SetsKt.minus((Set)SetsKt.minus((Set)requiredVisibility, (Iterable)(inferredVisibility = SourceSetsVisibilityInferenceKt.getVisibleSourceSetsFromAssociateCompilations((Set)InternalKotlinSourceSetKt.getInternal(sourceSet).getCompilations()))), (Iterable)InternalKotlinSourceSetKt.getInternal(sourceSet).getWithDependsOnClosure());
            if (!(!((Collection)requiredButNotVisible).isEmpty())) continue;
            MutableObservableSet<KotlinCompilation<?>> compilations2 = InternalKotlinSourceSetKt.getInternal(sourceSet).getCompilations();
            throw new UnsatisfiedSourceSetVisibilityException(sourceSet, (Set)compilations2, inferredVisibility, requiredButNotVisible);
        }
    }
}

