/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.webpack;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.LogType;
import org.jetbrains.kotlin.gradle.internal.TeamCityMessageCommonClient;
import org.jetbrains.kotlin.gradle.targets.js.webpack.InfrastructureLogged;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0010\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/WebpackLogClient;", "Lorg/jetbrains/kotlin/gradle/internal/TeamCityMessageCommonClient;", "clientType", "Lorg/jetbrains/kotlin/gradle/internal/LogType;", "log", "Lorg/gradle/api/logging/Logger;", "infrastructureLogged", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/InfrastructureLogged;", "(Lorg/jetbrains/kotlin/gradle/internal/LogType;Lorg/gradle/api/logging/Logger;Lorg/jetbrains/kotlin/gradle/targets/js/webpack/InfrastructureLogged;)V", "printMessage", "", "text", "", "type", "printMessage$kotlin_gradle_plugin_common", "regularText", "Companion", "kotlin-gradle-plugin_common"})
public final class WebpackLogClient
extends TeamCityMessageCommonClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InfrastructureLogged infrastructureLogged;
    @NotNull
    private static final Regex WEBPACK_COMPILED_REGEX = new Regex("webpack (.+) compiled (.+) in .+\\s");
    @NotNull
    private static final Regex WEBPACK_INFRASTRUCTURE_REGEX = new Regex("<i> \\[.+] .+\\s");

    public WebpackLogClient(@NotNull LogType clientType, @NotNull Logger log, @NotNull InfrastructureLogged infrastructureLogged) {
        Intrinsics.checkNotNullParameter((Object)((Object)clientType), (String)"clientType");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)infrastructureLogged, (String)"infrastructureLogged");
        super(clientType, log);
        this.infrastructureLogged = infrastructureLogged;
    }

    @Override
    public void regularText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (WEBPACK_INFRASTRUCTURE_REGEX.matches((CharSequence)text)) {
            this.infrastructureLogged.setValue(true);
            this.printMessage$kotlin_gradle_plugin_common(text, LogType.LIFECYCLE);
        } else {
            super.regularText(text);
        }
    }

    @Override
    public void printMessage$kotlin_gradle_plugin_common(@NotNull String text, @Nullable LogType type) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.infrastructureLogged.getValue() && WEBPACK_COMPILED_REGEX.matches((CharSequence)text)) {
            super.printMessage$kotlin_gradle_plugin_common(text, LogType.LIFECYCLE);
        } else {
            super.printMessage$kotlin_gradle_plugin_common(text, type);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/WebpackLogClient$Companion;", "", "()V", "WEBPACK_COMPILED_REGEX", "Lkotlin/text/Regex;", "getWEBPACK_COMPILED_REGEX$kotlin_gradle_plugin_common", "()Lkotlin/text/Regex;", "WEBPACK_INFRASTRUCTURE_REGEX", "getWEBPACK_INFRASTRUCTURE_REGEX$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getWEBPACK_COMPILED_REGEX$kotlin_gradle_plugin_common() {
            return WEBPACK_COMPILED_REGEX;
        }

        @NotNull
        public final Regex getWEBPACK_INFRASTRUCTURE_REGEX$kotlin_gradle_plugin_common() {
            return WEBPACK_INFRASTRUCTURE_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

