/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.CRC32;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.AbstractUnicodeExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipLong;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipMethod;

public abstract class ZipUtil {
    private static final long DOSTIME_BEFORE_1980 = 0x210000L;
    private static final long DOSTIME_BEFORE_1980_AS_JAVA_TIME = ZipUtil.dosToJavaTime(0x210000L);
    private static final long UPPER_DOSTIME_BOUND = 4036608000000L;

    public static long adjustToLong(int i2) {
        if (i2 < 0) {
            return 0x100000000L + (long)i2;
        }
        return i2;
    }

    static long bigToLong(BigInteger big) {
        if (big.bitLength() <= 63) {
            return big.longValue();
        }
        throw new NumberFormatException("The BigInteger cannot fit inside a 64 bit java long: [" + big + "]");
    }

    static boolean canHandleEntryData(ZipArchiveEntry entry2) {
        return ZipUtil.supportsEncryptionOf(entry2) && ZipUtil.supportsMethodOf(entry2);
    }

    static void checkRequestedFeatures(ZipArchiveEntry ze) throws UnsupportedZipFeatureException {
        if (!ZipUtil.supportsEncryptionOf(ze)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.ENCRYPTION, ze);
        }
        if (!ZipUtil.supportsMethodOf(ze)) {
            ZipMethod m = ZipMethod.getMethodByCode(ze.getMethod());
            if (m == null) {
                throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.METHOD, ze);
            }
            throw new UnsupportedZipFeatureException(m, ze);
        }
    }

    static byte[] copy(byte[] from2) {
        if (from2 != null) {
            return Arrays.copyOf(from2, from2.length);
        }
        return null;
    }

    static void copy(byte[] from2, byte[] to, int offset) {
        if (from2 != null) {
            System.arraycopy(from2, 0, to, offset, from2.length);
        }
    }

    private static Date dosToJavaDate(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
        cal.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
        cal.set(5, (int)(dosTime >> 16) & 0x1F);
        cal.set(11, (int)(dosTime >> 11) & 0x1F);
        cal.set(12, (int)(dosTime >> 5) & 0x3F);
        cal.set(13, (int)(dosTime << 1) & 0x3E);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static long dosToJavaTime(long dosTime) {
        return ZipUtil.dosToJavaDate(dosTime).getTime();
    }

    public static Date fromDosTime(ZipLong zipDosTime) {
        long dosTime = zipDosTime.getValue();
        return ZipUtil.dosToJavaDate(dosTime);
    }

    private static String getUnicodeStringIfOriginalMatches(AbstractUnicodeExtraField f, byte[] orig) {
        if (f != null) {
            CRC32 crc32 = new CRC32();
            crc32.update(orig);
            long origCRC32 = crc32.getValue();
            if (origCRC32 == f.getNameCRC32()) {
                try {
                    return ZipEncodingHelper.ZIP_ENCODING_UTF_8.decode(f.getUnicodeName());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isDosTime(long time) {
        return time <= 4036608000000L && (time == DOSTIME_BEFORE_1980_AS_JAVA_TIME || ZipUtil.javaToDosTime(time) != 0x210000L);
    }

    private static LocalDateTime javaEpochToLocalDateTime(long time) {
        Instant instant = Instant.ofEpochMilli(time);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    private static long javaToDosTime(long t) {
        LocalDateTime ldt = ZipUtil.javaEpochToLocalDateTime(t);
        if (ldt.getYear() < 1980) {
            return 0x210000L;
        }
        return (long)(ldt.getYear() - 1980 << 25 | ldt.getMonthValue() << 21 | ldt.getDayOfMonth() << 16 | ldt.getHour() << 11 | ldt.getMinute() << 5 | ldt.getSecond() >> 1) & 0xFFFFFFFFL;
    }

    static BigInteger longToBig(long l) {
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Negative longs < -2^31 not permitted: [" + l + "]");
        }
        if (l < 0L && l >= Integer.MIN_VALUE) {
            l = ZipUtil.adjustToLong((int)l);
        }
        return BigInteger.valueOf(l);
    }

    public static byte[] reverse(byte[] array2) {
        int z = array2.length - 1;
        for (int i2 = 0; i2 < array2.length / 2; ++i2) {
            byte x = array2[i2];
            array2[i2] = array2[z - i2];
            array2[z - i2] = x;
        }
        return array2;
    }

    static void setNameAndCommentFromExtraFields(ZipArchiveEntry ze, byte[] originalNameBytes, byte[] commentBytes) {
        ZipExtraField cmtCandidate;
        UnicodeCommentExtraField cmt;
        String newComment;
        ZipExtraField nameCandidate = ze.getExtraField(UnicodePathExtraField.UPATH_ID);
        UnicodePathExtraField name2 = nameCandidate instanceof UnicodePathExtraField ? (UnicodePathExtraField)nameCandidate : null;
        String newName = ZipUtil.getUnicodeStringIfOriginalMatches(name2, originalNameBytes);
        if (newName != null) {
            ze.setName(newName);
            ze.setNameSource(ZipArchiveEntry.NameSource.UNICODE_EXTRA_FIELD);
        }
        if (commentBytes != null && commentBytes.length > 0 && (newComment = ZipUtil.getUnicodeStringIfOriginalMatches(cmt = (cmtCandidate = ze.getExtraField(UnicodeCommentExtraField.UCOM_ID)) instanceof UnicodeCommentExtraField ? (UnicodeCommentExtraField)cmtCandidate : null, commentBytes)) != null) {
            ze.setComment(newComment);
            ze.setCommentSource(ZipArchiveEntry.CommentSource.UNICODE_EXTRA_FIELD);
        }
    }

    public static int signedByteToUnsignedInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    private static boolean supportsEncryptionOf(ZipArchiveEntry entry2) {
        return !entry2.getGeneralPurposeBit().usesEncryption();
    }

    private static boolean supportsMethodOf(ZipArchiveEntry entry2) {
        return entry2.getMethod() == 0 || entry2.getMethod() == ZipMethod.UNSHRINKING.getCode() || entry2.getMethod() == ZipMethod.IMPLODING.getCode() || entry2.getMethod() == 8 || entry2.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode() || entry2.getMethod() == ZipMethod.BZIP2.getCode();
    }

    public static ZipLong toDosTime(Date time) {
        return new ZipLong(ZipUtil.toDosTime(time.getTime()));
    }

    public static byte[] toDosTime(long t) {
        byte[] result2 = new byte[4];
        ZipUtil.toDosTime(t, result2, 0);
        return result2;
    }

    public static void toDosTime(long t, byte[] buf, int offset) {
        ZipLong.putLong(ZipUtil.javaToDosTime(t), buf, offset);
    }

    public static byte unsignedIntToSignedByte(int i2) {
        if (i2 > 255 || i2 < 0) {
            throw new IllegalArgumentException("Can only convert non-negative integers between [0,255] to byte: [" + i2 + "]");
        }
        if (i2 < 128) {
            return (byte)i2;
        }
        return (byte)(i2 - 256);
    }
}

