/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.output;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.NoPermissionException;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.gradle.internal.backend.common.output.OutputFile;
import org.jetbrains.kotlin.gradle.internal.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.incremental.components.ICFileMappingTracker;

@Metadata(k=2, mv={2, 2, 0}, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aS\u0010\u000b\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u000128\u0010\n\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\r\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001a3\u0010\u000b\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u000b\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;", "Ljava/io/File;", "outputDir", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFile;", "Lkotlin/ParameterName;", "name", "outputInfo", "output", "", "report", "writeAll", "(Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;Ljava/io/File;Lkotlin/jvm/functions/Function2;)V", "writeAllTo", "(Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;Ljava/io/File;)V", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "", "reportOutputFiles", "Lorg/jetbrains/kotlin/incremental/components/ICFileMappingTracker;", "fileMappingTracker", "(Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;ZLorg/jetbrains/kotlin/incremental/components/ICFileMappingTracker;)V", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\noutputUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 outputUtils.kt\norg/jetbrains/kotlin/cli/common/output/OutputUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n2792#2,3:84\n*S KotlinDebug\n*F\n+ 1 outputUtils.kt\norg/jetbrains/kotlin/cli/common/output/OutputUtilsKt\n*L\n64#1:84,3\n*E\n"})
public final class OutputUtilsKt {
    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @Nullable Function2<? super OutputFile, ? super File, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        for (OutputFile file2 : $this$writeAll.asList()) {
            File output2 = new File(outputDir, file2.getRelativePath());
            Function2<? super OutputFile, ? super File, Unit> function2 = report2;
            if (function2 != null) {
                function2.invoke((Object)file2, (Object)output2);
            }
            try {
                FileUtil.writeToFile((File)output2, (byte[])file2.asByteArray());
            }
            catch (FileNotFoundException e) {
                if (outputDir.isDirectory()) {
                    throw new NoPermissionException("error while writing " + output2 + " (Permission denied)", e);
                }
                throw e;
            }
        }
    }

    public static final void writeAllTo(@NotNull OutputFileCollection $this$writeAllTo, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAllTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        OutputUtilsKt.writeAll($this$writeAllTo, outputDir, null);
    }

    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @NotNull MessageCollector messageCollector, boolean reportOutputFiles, @Nullable ICFileMappingTracker fileMappingTracker) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        try {
            if (!reportOutputFiles && fileMappingTracker == null) {
                OutputUtilsKt.writeAllTo($this$writeAll, outputDir);
            } else {
                OutputUtilsKt.writeAll($this$writeAll, outputDir, (Function2<? super OutputFile, ? super File, Unit>)((Function2)(arg_0, arg_1) -> OutputUtilsKt.writeAll$lambda$0(fileMappingTracker, reportOutputFiles, messageCollector, arg_0, arg_1)));
            }
        }
        catch (NoPermissionException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
        catch (FileNotFoundException e) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "directory not found: " + outputDir, null, 4, null);
        }
    }

    private static final CharSequence writeAll$lambda$0$0$1$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final Unit writeAll$lambda$0(ICFileMappingTracker $fileMappingTracker, boolean $reportOutputFiles, MessageCollector $messageCollector, OutputFile outputInfo, File output2) {
        Intrinsics.checkNotNullParameter((Object)outputInfo, (String)"outputInfo");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        ICFileMappingTracker iCFileMappingTracker = $fileMappingTracker;
        if (iCFileMappingTracker != null) {
            ICFileMappingTracker tracker = iCFileMappingTracker;
            boolean bl = false;
            boolean bl2 = outputInfo.getGeneratedForCompilerPlugin();
            if (!bl2) {
                tracker.recordSourceFilesToOutputFileMapping((Collection<? extends File>)outputInfo.getSourceFiles(), output2);
            } else if (bl2) {
                boolean bl3;
                block10: {
                    Iterable $this$none$iv = outputInfo.getSourceFiles();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            File it = (File)element$iv;
                            boolean bl4 = false;
                            if (!it.exists()) continue;
                            bl3 = false;
                            break block10;
                        }
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    boolean bl5 = false;
                    String string = "Plugin generated file shouldn't have sources, but got " + CollectionsKt.joinToString$default((Iterable)outputInfo.getSourceFiles(), null, null, null, (int)0, null, OutputUtilsKt::writeAll$lambda$0$0$1$0, (int)31, null);
                    throw new IllegalStateException(string.toString());
                }
                tracker.recordSourceFilesToOutputFileMapping((Collection<? extends File>)outputInfo.getSourceFiles(), output2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        if ($reportOutputFiles) {
            String string = OutputMessageUtil.formatOutputMessage((Collection<File>)outputInfo.getSourceFiles(), output2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatOutputMessage(...)");
            MessageCollector.report$default($messageCollector, CompilerMessageSeverity.OUTPUT, string, null, 4, null);
        }
        return Unit.INSTANCE;
    }
}

