/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.abi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiFiltersSpec;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiValidationExtension;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiValidationKlibKindExtension;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiValidationMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.abi.ExperimentalAbiValidation;
import org.jetbrains.kotlin.gradle.internal.abi.AbiValidationExtensionImpl;
import org.jetbrains.kotlin.gradle.internal.abi.AbiValidationMultiplatformExtensionImpl;
import org.jetbrains.kotlin.gradle.internal.abi.AbiValidationMultiplatformVariantSpecImpl;
import org.jetbrains.kotlin.gradle.internal.abi.AbiValidationVariantSpecImpl;
import org.jetbrains.kotlin.gradle.internal.abi.ConfigsKt;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiCheckTaskImpl;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiDumpTaskImpl;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiUpdateTask;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u0014\u0010\t\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u001a2\u0010\r\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0001\u001a\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0016H\u0001\u00a8\u0006\u0017"}, d2={"AbiValidationKlibKindExtension", "Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiValidationKlibKindExtension;", "Lorg/gradle/api/model/ObjectFactory;", "configure", "", "Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiValidationExtension;", "project", "Lorg/gradle/api/Project;", "Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiValidationMultiplatformExtension;", "configureCommon", "Lorg/jetbrains/kotlin/gradle/internal/abi/AbiValidationVariantSpecImpl;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "configureLegacyTasks", "projectName", "", "tasks", "Lorg/gradle/api/tasks/TaskContainer;", "isEnabled", "Lorg/gradle/api/provider/Property;", "", "configureMultiplatform", "Lorg/jetbrains/kotlin/gradle/internal/abi/AbiValidationMultiplatformVariantSpecImpl;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nConfigs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Configs.kt\norg/jetbrains/kotlin/gradle/internal/abi/ConfigsKt\n+ 2 providerApiUtils.kt\norg/jetbrains/kotlin/gradle/utils/ProviderApiUtilsKt\n*L\n1#1,151:1\n81#2:152\n*S KotlinDebug\n*F\n+ 1 Configs.kt\norg/jetbrains/kotlin/gradle/internal/abi/ConfigsKt\n*L\n30#1:152\n*E\n"})
public final class ConfigsKt {
    @NotNull
    public static final AbiValidationKlibKindExtension AbiValidationKlibKindExtension(@NotNull ObjectFactory $this$AbiValidationKlibKindExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$AbiValidationKlibKindExtension, (String)"<this>");
        ObjectFactory $this$newInstance$iv = $this$AbiValidationKlibKindExtension;
        boolean $i$f$newInstance = false;
        Object object = $this$newInstance$iv.newInstance(AbiValidationKlibKindExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance<AbiValidationKlibKindExtension>()");
        return (AbiValidationKlibKindExtension)object;
    }

    @ExperimentalAbiValidation
    public static final void configure(@NotNull AbiValidationExtension $this$configure, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AbiValidationExtensionImpl cfr_ignored_0 = (AbiValidationExtensionImpl)$this$configure;
        AbiValidationVariantSpecImpl abiValidationVariantSpecImpl = (AbiValidationVariantSpecImpl)$this$configure;
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        ConfigsKt.configureCommon(abiValidationVariantSpecImpl, projectLayout);
        AbiValidationVariantSpecImpl abiValidationVariantSpecImpl2 = (AbiValidationVariantSpecImpl)$this$configure;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        ProjectLayout projectLayout2 = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout2, (String)"project.layout");
        ConfigsKt.configureLegacyTasks(abiValidationVariantSpecImpl2, string, taskContainer, projectLayout2, (Property<Boolean>)$this$configure.getEnabled());
        $this$configure.getVariants().add((Object)$this$configure);
    }

    @ExperimentalAbiValidation
    public static final void configure(@NotNull AbiValidationMultiplatformExtension $this$configure, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AbiValidationMultiplatformExtensionImpl cfr_ignored_0 = (AbiValidationMultiplatformExtensionImpl)$this$configure;
        AbiValidationVariantSpecImpl abiValidationVariantSpecImpl = (AbiValidationVariantSpecImpl)$this$configure;
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        ConfigsKt.configureCommon(abiValidationVariantSpecImpl, projectLayout);
        ConfigsKt.configureMultiplatform((AbiValidationMultiplatformVariantSpecImpl)$this$configure);
        AbiValidationVariantSpecImpl abiValidationVariantSpecImpl2 = (AbiValidationVariantSpecImpl)$this$configure;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        ProjectLayout projectLayout2 = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout2, (String)"project.layout");
        ConfigsKt.configureLegacyTasks(abiValidationVariantSpecImpl2, string, taskContainer, projectLayout2, (Property<Boolean>)$this$configure.getEnabled());
        $this$configure.getVariants().add((Object)$this$configure);
    }

    @ExperimentalAbiValidation
    public static final void configureCommon(@NotNull AbiValidationVariantSpecImpl $this$configureCommon, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)$this$configureCommon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        if (Intrinsics.areEqual((Object)$this$configureCommon.getName(), (Object)"main")) {
            $this$configureCommon.getLegacyDump().getReferenceDumpDir().convention(layout.getProjectDirectory().dir("api"));
        } else {
            $this$configureCommon.getLegacyDump().getReferenceDumpDir().convention(layout.getProjectDirectory().dir("api" + (Intrinsics.areEqual((Object)$this$configureCommon.getName(), (Object)"main") ? "" : '-' + $this$configureCommon.getName())));
        }
    }

    @ExperimentalAbiValidation
    public static final void configureMultiplatform(@NotNull AbiValidationMultiplatformVariantSpecImpl $this$configureMultiplatform) {
        Intrinsics.checkNotNullParameter((Object)$this$configureMultiplatform, (String)"<this>");
        $this$configureMultiplatform.getKlib().getEnabled().convention((Object)true);
        $this$configureMultiplatform.getKlib().getKeepUnsupportedTargets().convention((Object)true);
    }

    @ExperimentalAbiValidation
    public static final void configureLegacyTasks(@NotNull AbiValidationVariantSpecImpl $this$configureLegacyTasks, @NotNull String projectName, @NotNull TaskContainer tasks, @NotNull ProjectLayout layout, @NotNull Property<Boolean> isEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$configureLegacyTasks, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter(isEnabled, (String)"isEnabled");
        String variantName = $this$configureLegacyTasks.getName();
        String klibFileName = projectName + ".klib.api";
        DirectoryProperty referenceDir = $this$configureLegacyTasks.getLegacyDump().getReferenceDumpDir();
        AbiFiltersSpec filters = $this$configureLegacyTasks.getFilters();
        Provider dumpDir = layout.getBuildDirectory().dir("kotlin/abi-legacy" + (Intrinsics.areEqual((Object)variantName, (Object)"main") ? "" : '-' + variantName));
        TaskProvider dumpTaskProvider2 = tasks.register(KotlinLegacyAbiDumpTaskImpl.Companion.nameForVariant(variantName), KotlinLegacyAbiDumpTaskImpl.class, new Action((Provider<Directory>)dumpDir, referenceDir, variantName, filters, klibFileName, isEnabled){
            final /* synthetic */ Provider<Directory> $dumpDir;
            final /* synthetic */ DirectoryProperty $referenceDir;
            final /* synthetic */ String $variantName;
            final /* synthetic */ AbiFiltersSpec $filters;
            final /* synthetic */ String $klibFileName;
            final /* synthetic */ Property<Boolean> $isEnabled;
            {
                this.$dumpDir = $dumpDir;
                this.$referenceDir = $referenceDir;
                this.$variantName = $variantName;
                this.$filters = $filters;
                this.$klibFileName = $klibFileName;
                this.$isEnabled = $isEnabled;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getDumpDir().convention(this.$dumpDir);
                it.getReferenceKlibDump().convention(this.$referenceDir.map(new Transformer(this.$klibFileName){
                    final /* synthetic */ String $klibFileName;
                    {
                        this.$klibFileName = $klibFileName;
                    }

                    public final RegularFile transform(Directory dir2) {
                        return dir2.file(this.$klibFileName);
                    }
                }));
                it.getKeepUnsupportedTargets().convention((Object)true);
                it.getKlibIsEnabled().convention((Object)true);
                it.getVariantName().convention((Object)this.$variantName);
                it.getKlib().convention(it.getKlibInput().map(new Transformer(it){
                    final /* synthetic */ KotlinLegacyAbiDumpTaskImpl $it;
                    {
                        this.$it = $it;
                    }

                    public final List<KotlinLegacyAbiDumpTaskImpl.KlibTargetInfo> transform(List<KotlinLegacyAbiDumpTaskImpl.KlibTargetInfo> targets) {
                        Object object = this.$it.getKlibIsEnabled().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.klibIsEnabled.get()");
                        return (Boolean)object != false ? targets : CollectionsKt.emptyList();
                    }
                }));
                it.getIncludedClasses().convention((Provider)this.$filters.getIncluded().getByNames());
                it.getIncludedAnnotatedWith().convention((Provider)this.$filters.getIncluded().getAnnotatedWith());
                it.getExcludedClasses().convention((Provider)this.$filters.getExcluded().getByNames());
                it.getExcludedAnnotatedWith().convention((Provider)this.$filters.getExcluded().getAnnotatedWith());
                it.setDescription("Dumps the public Application Binary Interface (ABI) into files in the build directory for the '" + this.$variantName + "' variant.");
                it.setGroup(null);
                it.onlyIf(new Spec(this.$isEnabled){
                    final /* synthetic */ Property<Boolean> $isEnabled;
                    {
                        this.$isEnabled = $isEnabled;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        Object object = this.$isEnabled.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"isEnabled.get()");
                        return (Boolean)object;
                    }
                });
            }
        });
        tasks.register(KotlinLegacyAbiCheckTaskImpl.Companion.nameForVariant(variantName), KotlinLegacyAbiCheckTaskImpl.class, new Action((TaskProvider<KotlinLegacyAbiDumpTaskImpl>)dumpTaskProvider2, referenceDir, variantName, isEnabled){
            final /* synthetic */ TaskProvider<KotlinLegacyAbiDumpTaskImpl> $dumpTaskProvider;
            final /* synthetic */ DirectoryProperty $referenceDir;
            final /* synthetic */ String $variantName;
            final /* synthetic */ Property<Boolean> $isEnabled;
            {
                this.$dumpTaskProvider = $dumpTaskProvider;
                this.$referenceDir = $referenceDir;
                this.$variantName = $variantName;
                this.$isEnabled = $isEnabled;
            }

            public final void execute(KotlinLegacyAbiCheckTaskImpl it) {
                it.getActualDir().convention(this.$dumpTaskProvider.map((Transformer)configureLegacyTasks.1.INSTANCE));
                it.getReferenceDir().convention((Provider)this.$referenceDir);
                it.getVariantName().convention((Object)this.$variantName);
                it.setDescription("Checks that the public Application Binary Interface (ABI) of the current project code matchesthe reference dump file for the '" + this.$variantName + "' variant.");
                it.setGroup("verification");
                it.onlyIf(new Spec(this.$isEnabled){
                    final /* synthetic */ Property<Boolean> $isEnabled;
                    {
                        this.$isEnabled = $isEnabled;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        Object object = this.$isEnabled.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"isEnabled.get()");
                        return (Boolean)object;
                    }
                });
            }
        });
        tasks.register(KotlinLegacyAbiUpdateTask.Companion.nameForVariant(variantName), KotlinLegacyAbiUpdateTask.class, new Action((TaskProvider<KotlinLegacyAbiDumpTaskImpl>)dumpTaskProvider2, referenceDir, variantName, isEnabled){
            final /* synthetic */ TaskProvider<KotlinLegacyAbiDumpTaskImpl> $dumpTaskProvider;
            final /* synthetic */ DirectoryProperty $referenceDir;
            final /* synthetic */ String $variantName;
            final /* synthetic */ Property<Boolean> $isEnabled;
            {
                this.$dumpTaskProvider = $dumpTaskProvider;
                this.$referenceDir = $referenceDir;
                this.$variantName = $variantName;
                this.$isEnabled = $isEnabled;
            }

            public final void execute(KotlinLegacyAbiUpdateTask it) {
                it.getActualDir().convention(this.$dumpTaskProvider.map((Transformer)configureLegacyTasks.1.INSTANCE));
                it.getReferenceDir().convention((Provider)this.$referenceDir);
                it.getVariantName().convention((Object)this.$variantName);
                it.setDescription("Writes the public Application Binary Interface (ABI) of the current code to the reference dump file for the '" + this.$variantName + "' variant.");
                it.setGroup("verification");
                it.onlyIf(new Spec(this.$isEnabled){
                    final /* synthetic */ Property<Boolean> $isEnabled;
                    {
                        this.$isEnabled = $isEnabled;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        Object object = this.$isEnabled.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"isEnabled.get()");
                        return (Boolean)object;
                    }
                });
            }
        });
    }
}

