/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.Uklib;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.UklibFragment;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization.IncompatibleUklibFragmentFile;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization.MissingUklibFragmentFile;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a4\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00022\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"allowRepackingArchivesWithExtensions", "", "", "packArchiveAsIs", "packDirectory", "", "directory", "Ljava/io/File;", "identifier", "zipOutputStream", "Ljava/util/zip/ZipOutputStream;", "packFile", "file", "unzip", "zipFilePath", "outputFolderPath", "zipUklibContents", "manifest", "fragmentToArtifact", "", "outputZip", "temporariesDirectory", "serializeToZipArchive", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/Uklib;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nuklibSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 uklibSerialization.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/serialization/UklibSerializationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,175:1\n1045#2:176\n1549#2:177\n1620#2,3:178\n1179#2,2:181\n1253#2,4:183\n211#3,2:187\n*S KotlinDebug\n*F\n+ 1 uklibSerialization.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/serialization/UklibSerializationKt\n*L\n31#1:176\n34#1:177\n34#1:178,3\n47#1:181,2\n47#1:183,4\n90#1:187,2\n*E\n"})
public final class UklibSerializationKt {
    @NotNull
    private static final Set<String> allowRepackingArchivesWithExtensions = SetsKt.setOf((Object)"klib");
    @NotNull
    private static final Set<String> packArchiveAsIs = SetsKt.setOf((Object)"jar");

    /*
     * WARNING - void declaration
     */
    public static final void serializeToZipArchive(@NotNull Uklib $this$serializeToZipArchive, @NotNull File outputZip, @NotNull File temporariesDirectory) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Collection<Map> collection;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$serializeToZipArchive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputZip, (String)"outputZip");
        Intrinsics.checkNotNullParameter((Object)temporariesDirectory, (String)"temporariesDirectory");
        Object object2 = new Pair[2];
        Iterable $this$sortedBy$iv = $this$serializeToZipArchive.getModule().getFragments();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                UklibFragment it = (UklibFragment)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getIdentifier());
                it = (UklibFragment)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getIdentifier())));
            }
        });
        String string = "fragments";
        int n = 0;
        Pair[] pairArray = object2;
        Object object3 = new GsonBuilder().setPrettyPrinting().create();
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (UklibFragment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"identifier", (Object)it.getIdentifier()), TuplesKt.to((Object)"targets", (Object)CollectionsKt.sorted((Iterable)it.getAttributes()))};
            collection.add(MapsKt.mapOf((Pair[])pairArray2));
        }
        collection = (List)destination$iv$iv;
        pairArray[n] = TuplesKt.to((Object)string, (Object)collection);
        object2[1] = TuplesKt.to((Object)"manifestVersion", (Object)$this$serializeToZipArchive.getManifestVersion());
        String manifest = ((Gson)object3).toJson(MapsKt.mapOf((Pair[])object2));
        Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
        object2 = $this$serializeToZipArchive.getModule().getFragments();
        object3 = manifest;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            UklibFragment it = (UklibFragment)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getIdentifier(), (Object)CollectionsKt.single(it.getFiles()));
            object.put(pair.getFirst(), pair.getSecond());
        }
        UklibSerializationKt.zipUklibContents((String)object3, (Map<String, ? extends File>)destination$iv$iv, outputZip, temporariesDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipUklibContents(String manifest, Map<String, ? extends File> fragmentToArtifact, File outputZip, File temporariesDirectory) {
        Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputZip)));
        Throwable throwable = null;
        try {
            ZipOutputStream zipOutputStream = (ZipOutputStream)closeable;
            boolean bl = false;
            zipOutputStream.putNextEntry(new ZipEntry("umanifest"));
            String string = manifest;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)zipOutputStream, (int)0, (int)2, null);
            Map<String, ? extends File> $this$forEach$iv = fragmentToArtifact;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends File>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, ? extends File> element$iv;
                Map.Entry<String, ? extends File> entry2 = element$iv = iterator2.next();
                boolean bl2 = false;
                String identifier = entry2.getKey();
                File file2 = entry2.getValue();
                if (!file2.exists()) {
                    throw new MissingUklibFragmentFile(file2);
                }
                if (file2.isDirectory()) {
                    UklibSerializationKt.packDirectory(file2, identifier, zipOutputStream);
                    continue;
                }
                if (packArchiveAsIs.contains(FilesKt.getExtension((File)file2))) {
                    UklibSerializationKt.packFile(file2, identifier, zipOutputStream);
                    continue;
                }
                if (allowRepackingArchivesWithExtensions.contains(FilesKt.getExtension((File)file2))) {
                    File temp = FilesKt.resolve((File)temporariesDirectory, (String)identifier);
                    if (temp.exists()) {
                        FileUtilsKt.deleteDirectoryContents(temp);
                    }
                    temp.mkdirs();
                    UklibSerializationKt.unzip(file2, temp);
                    UklibSerializationKt.packDirectory(temp, identifier, zipOutputStream);
                    continue;
                }
                throw new IncompatibleUklibFragmentFile(file2);
            }
            zipOutputStream.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void packDirectory(File directory, String identifier, ZipOutputStream zipOutputStream) {
        Files.walk(directory.toPath(), new FileVisitOption[0]).forEach(new Consumer(identifier, directory, zipOutputStream){
            final /* synthetic */ String $identifier;
            final /* synthetic */ File $directory;
            final /* synthetic */ ZipOutputStream $zipOutputStream;
            {
                this.$identifier = $identifier;
                this.$directory = $directory;
                this.$zipOutputStream = $zipOutputStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(Path path) {
                StringBuilder stringBuilder = new StringBuilder().append(this.$identifier).append('/');
                File file2 = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
                ZipEntry zipEntry = new ZipEntry(stringBuilder.append(FilesKt.toRelativeString((File)file2, (File)this.$directory)).toString());
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this.$zipOutputStream.putNextEntry(zipEntry);
                    Closeable closeable = Files.newInputStream(path, new OpenOption[0]);
                    ZipOutputStream zipOutputStream = this.$zipOutputStream;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                        long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)zipOutputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    this.$zipOutputStream.closeEntry();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void packFile(File file2, String identifier, ZipOutputStream zipOutputStream) {
        ZipEntry zipEntry = new ZipEntry(identifier);
        zipOutputStream.putNextEntry(zipEntry);
        Closeable closeable = new FileInputStream(file2);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)zipOutputStream, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unzip(File zipFilePath, File outputFolderPath) {
        Closeable closeable = new ZipInputStream(new FileInputStream(zipFilePath));
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File newFile = new File(outputFolderPath, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    File file2 = newFile.getParentFile();
                    if (file2 != null) {
                        file2.mkdirs();
                    }
                    Closeable closeable2 = new FileOutputStream(newFile);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream fileOutputStream = (FileOutputStream)closeable2;
                        boolean bl2 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)zipInputStream, (OutputStream)fileOutputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

