/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FunctionDelegateMemberNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class FunctionDelegateMemberNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final FunctionDelegateMemberNameClashChecker INSTANCE = new FunctionDelegateMemberNameClashChecker();

    private FunctionDelegateMemberNameClashChecker() {
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!(descriptor instanceof CallableMemberDescriptor)) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor;
                if (!(container instanceof ClassDescriptor) || !((ClassDescriptor)container).isFun()) {
                    return;
                }
                if (((CallableMemberDescriptor)descriptor).getExtensionReceiverParameter() != null) break block7;
                List<ValueParameterDescriptor> list = ((CallableMemberDescriptor)descriptor).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
                if (!(!((Collection)list).isEmpty())) break block8;
            }
            return;
        }
        if (descriptor instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getName().asString(), (Object)"getFunctionDelegate") || descriptor instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor).getName().asString(), (Object)"functionDelegate")) {
            KtNamedDeclaration ktNamedDeclaration = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
            if (ktNamedDeclaration == null || (ktNamedDeclaration = ktNamedDeclaration.getNameIdentifier()) == null) {
                ktNamedDeclaration = (PsiElement)declaration;
            }
            KtNamedDeclaration reportOn = ktNamedDeclaration;
            context.getTrace().report((Diagnostic)ErrorsJvm.FUNCTION_DELEGATE_MEMBER_NAME_CLASH.on((PsiElement)reportOn));
        }
    }
}

