/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class FileBasedKotlinClass
implements KotlinJvmBinaryClass {
    private final ClassId classId;
    private final int classVersion;
    private final KotlinClassHeader classHeader;
    private final InnerClassesInfo innerClasses;

    protected FileBasedKotlinClass(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader, @NotNull InnerClassesInfo innerClasses) {
        if (classId == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(0);
        }
        if (classHeader == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(1);
        }
        if (innerClasses == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(2);
        }
        this.classId = classId;
        this.classVersion = classVersion;
        this.classHeader = classHeader;
        this.innerClasses = innerClasses;
    }

    @NotNull
    protected abstract byte[] getFileContents();

    @Nullable
    public static <T> T create(@NotNull byte[] fileContents, @NotNull MetadataVersion metadataVersionFromLanguageVersion, @NotNull Function4<ClassId, Integer, KotlinClassHeader, InnerClassesInfo, T> factory) {
        if (metadataVersionFromLanguageVersion == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(4);
        }
        if (fileContents == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(5);
        }
        final ReadKotlinClassHeaderAnnotationVisitor readHeaderVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
        final Ref classNameRef = Ref.create();
        final Ref classVersion = Ref.create();
        final InnerClassesInfo innerClasses = new InnerClassesInfo();
        new ClassReader(fileContents).accept(new ClassVisitor(589824){

            public void visit(int version, int access, @NotNull String name, String signature, String superName, String[] interfaces) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                classNameRef.set((Object)name);
                classVersion.set((Object)version);
            }

            public void visitInnerClass(@NotNull String name, String outerName, String innerName, int access) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                innerClasses.add(name, outerName, innerName);
            }

            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                if (desc == null) {
                    1.$$$reportNull$$$0(2);
                }
                return FileBasedKotlinClass.convertAnnotationVisitor(readHeaderVisitor, desc, innerClasses);
            }

            public void visitEnd() {
                readHeaderVisitor.visitEnd();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desc";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitInnerClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 7);
        String className = (String)classNameRef.get();
        if (className == null) {
            return null;
        }
        KotlinClassHeader header = readHeaderVisitor.createHeader(metadataVersionFromLanguageVersion);
        if (header == null) {
            return null;
        }
        ClassId id = FileBasedKotlinClass.resolveNameByInternalName(className, innerClasses);
        return (T)factory.invoke((Object)id, classVersion.get(), (Object)header, (Object)innerClasses);
    }

    @Override
    @NotNull
    public ClassId getClassId() {
        ClassId classId = this.classId;
        if (classId == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(6);
        }
        return classId;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    @Override
    @NotNull
    public KotlinClassHeader getClassHeader() {
        KotlinClassHeader kotlinClassHeader = this.classHeader;
        if (kotlinClassHeader == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(7);
        }
        return kotlinClassHeader;
    }

    @Override
    public void loadClassAnnotations(final @NotNull KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor, @Nullable byte[] cachedContents) {
        if (annotationVisitor == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(8);
        }
        byte[] fileContents = cachedContents != null ? cachedContents : this.getFileContents();
        new ClassReader(fileContents).accept(new ClassVisitor(589824){

            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                if (desc == null) {
                    2.$$$reportNull$$$0(0);
                }
                return FileBasedKotlinClass.convertAnnotationVisitor(annotationVisitor, desc, FileBasedKotlinClass.this.innerClasses);
            }

            public void visitEnd() {
                annotationVisitor.visitEnd();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$2", "visitAnnotation"));
            }
        }, 7);
    }

    @Nullable
    public static AnnotationVisitor convertAnnotationVisitor(@NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor, @NotNull String desc, @NotNull InnerClassesInfo innerClasses) {
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v;
        if (visitor == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(9);
        }
        if (desc == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(10);
        }
        if (innerClasses == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(11);
        }
        return (v = visitor.visitAnnotation(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), SourceElement.NO_SOURCE)) == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(v, innerClasses);
    }

    @NotNull
    private static AnnotationVisitor convertAnnotationVisitor(final @NotNull KotlinJvmBinaryClass.AnnotationArgumentVisitor v, final @NotNull InnerClassesInfo innerClasses) {
        if (v == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(12);
        }
        if (innerClasses == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(13);
        }
        return new AnnotationVisitor(589824){

            public void visit(String name, @NotNull Object value2) {
                Name identifier;
                if (value2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                Name name2 = identifier = name == null ? null : Name.identifier(name);
                if (value2 instanceof Type) {
                    v.visitClassLiteral(identifier, FileBasedKotlinClass.resolveKotlinNameByType((Type)value2, innerClasses));
                } else {
                    v.visit(identifier, value2);
                }
            }

            public AnnotationVisitor visitArray(String name) {
                final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor arv = v.visitArray(name == null ? null : Name.identifier(name));
                return arv == null ? null : new AnnotationVisitor(589824){

                    public void visit(String name, @NotNull Object value2) {
                        if (value2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (value2 instanceof Type) {
                            arv.visitClassLiteral(FileBasedKotlinClass.resolveKotlinNameByType((Type)value2, innerClasses));
                        } else {
                            arv.visit(value2);
                        }
                    }

                    public void visitEnum(String name, @NotNull String desc, @NotNull String value2) {
                        if (desc == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (value2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        arv.visitEnum(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), Name.identifier(value2));
                    }

                    public AnnotationVisitor visitAnnotation(String name, @NotNull String desc) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor aav;
                        if (desc == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return (aav = arv.visitAnnotation(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses))) == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(aav, innerClasses);
                    }

                    public void visitEnd() {
                        arv.visitEnd();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "value";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "desc";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visit";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitEnum";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitAnnotation";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            public AnnotationVisitor visitAnnotation(String name, @NotNull String desc) {
                if (desc == null) {
                    3.$$$reportNull$$$0(1);
                }
                KotlinJvmBinaryClass.AnnotationArgumentVisitor arv = v.visitAnnotation(name == null ? null : Name.identifier(name), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses));
                return arv == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(arv, innerClasses);
            }

            public void visitEnum(String name, @NotNull String desc, @NotNull String value2) {
                if (desc == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (value2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                v.visitEnum(name == null ? null : Name.identifier(name), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), Name.identifier(value2));
            }

            public void visitEnd() {
                v.visitEnd();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desc";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotation";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEnum";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void visitMembers(final @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor, @Nullable byte[] cachedContents) {
        if (memberVisitor == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(14);
        }
        byte[] fileContents = cachedContents != null ? cachedContents : this.getFileContents();
        new ClassReader(fileContents).accept(new ClassVisitor(589824){

            public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, String signature, Object value2) {
                KotlinJvmBinaryClass.AnnotationVisitor v;
                if (name == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (desc == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((v = memberVisitor.visitField(Name.identifier(name), desc, value2)) == null) {
                    return null;
                }
                return new FieldVisitor(589824){

                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        if (desc == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    public void visitEnd() {
                        v.visitEnd();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$1", "visitAnnotation"));
                    }
                };
            }

            public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, String signature, String[] exceptions) {
                KotlinJvmBinaryClass.MethodAnnotationVisitor v;
                if (name == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (desc == null) {
                    4.$$$reportNull$$$0(3);
                }
                if ((v = memberVisitor.visitMethod(Name.identifier(name), desc)) == null) {
                    return null;
                }
                final int methodParamCount = Type.getArgumentTypes((String)desc).length;
                return new MethodVisitor(589824){
                    private int visibleAnnotableParameterCount;
                    private int invisibleAnnotableParameterCount;
                    {
                        super(x0);
                        this.visibleAnnotableParameterCount = methodParamCount;
                        this.invisibleAnnotableParameterCount = methodParamCount;
                    }

                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        if (desc == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    public AnnotationVisitor visitAnnotationDefault() {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitAnnotationMemberDefaultValue();
                        return av == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(av, FileBasedKotlinClass.this.innerClasses);
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
                        if (desc == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        int parameterIndex = parameter + methodParamCount - (visible ? this.visibleAnnotableParameterCount : this.invisibleAnnotableParameterCount);
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitParameterAnnotation(parameterIndex, FileBasedKotlinClass.resolveNameByDesc(desc, FileBasedKotlinClass.this.innerClasses), SourceElement.NO_SOURCE);
                        return av == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(av, FileBasedKotlinClass.this.innerClasses);
                    }

                    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
                        if (visible) {
                            this.visibleAnnotableParameterCount = parameterCount;
                        } else {
                            this.invisibleAnnotableParameterCount = parameterCount;
                        }
                    }

                    public void visitEnd() {
                        v.visitEnd();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "desc";
                        objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitAnnotation";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitParameterAnnotation";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desc";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 7);
    }

    @NotNull
    private static ClassId resolveNameByDesc(@NotNull String desc, @NotNull InnerClassesInfo innerClasses) {
        if (desc == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(15);
        }
        if (innerClasses == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(16);
        }
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String name = desc.substring(1, desc.length() - 1);
        return FileBasedKotlinClass.resolveNameByInternalName(name, innerClasses);
    }

    @NotNull
    private static ClassLiteralValue resolveKotlinNameByType(@NotNull Type type, @NotNull InnerClassesInfo innerClasses) {
        String typeDesc;
        int dimensions;
        String elementDesc;
        JvmPrimitiveType primType;
        if (type == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(17);
        }
        if (innerClasses == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(18);
        }
        if ((primType = JvmPrimitiveType.getByDesc(elementDesc = (dimensions = (typeDesc = type.getDescriptor()).charAt(0) == '[' ? type.getDimensions() : 0) == 0 ? typeDesc : type.getElementType().getDescriptor())) != null) {
            if (dimensions > 0) {
                return new ClassLiteralValue(ClassId.topLevel(primType.getPrimitiveType().getArrayTypeFqName()), dimensions - 1);
            }
            return new ClassLiteralValue(ClassId.topLevel(primType.getPrimitiveType().getTypeFqName()), dimensions);
        }
        ClassId javaClassId = FileBasedKotlinClass.resolveNameByDesc(elementDesc, innerClasses);
        ClassId kotlinClassId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(javaClassId.asSingleFqName());
        return new ClassLiteralValue(kotlinClassId != null ? kotlinClassId : javaClassId, dimensions);
    }

    @NotNull
    public static ClassId resolveNameByInternalName(@NotNull String name, @NotNull InnerClassesInfo innerClasses) {
        OuterAndInnerName outer;
        if (name == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(19);
        }
        if (innerClasses == null) {
            FileBasedKotlinClass.$$$reportNull$$$0(20);
        }
        if (!name.contains("$")) {
            ClassId classId = ClassId.topLevel(new FqName(name.replace('/', '.')));
            if (classId == null) {
                FileBasedKotlinClass.$$$reportNull$$$0(21);
            }
            return classId;
        }
        ArrayList<String> classes = new ArrayList<String>(1);
        boolean local = false;
        while ((outer = innerClasses.get(name)) != null) {
            if (outer.outerInternalName == null) {
                local = true;
                break;
            }
            classes.add(outer.innerSimpleName);
            name = outer.outerInternalName;
        }
        FqName outermostClassFqName = new FqName(name.replace('/', '.'));
        classes.add(outermostClassFqName.shortName().asString());
        Collections.reverse(classes);
        FqName packageFqName = outermostClassFqName.parent();
        FqName relativeClassName = FqName.fromSegments(classes);
        return new ClassId(packageFqName, relativeClassName, local);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classHeader";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClasses";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataVersionFromLanguageVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationVisitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberVisitor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassHeader";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameByInternalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadClassAnnotations";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertAnnotationVisitor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitMembers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameByDesc";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveKotlinNameByType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameByInternalName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InnerClassesInfo {
        private Map<String, OuterAndInnerName> map = null;

        public void add(@NotNull String name, @Nullable String outerName, @Nullable String innerName) {
            if (name == null) {
                InnerClassesInfo.$$$reportNull$$$0(0);
            }
            if (this.map == null) {
                this.map = new HashMap<String, OuterAndInnerName>();
            }
            this.map.put(name, new OuterAndInnerName(outerName, innerName));
        }

        @Nullable
        public OuterAndInnerName get(@NotNull String name) {
            if (name == null) {
                InnerClassesInfo.$$$reportNull$$$0(1);
            }
            return this.map == null ? null : this.map.get(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OuterAndInnerName {
        public final String outerInternalName;
        public final String innerSimpleName;

        private OuterAndInnerName(@Nullable String outerInternalName, @Nullable String innerSimpleName) {
            this.outerInternalName = outerInternalName;
            this.innerSimpleName = innerSimpleName;
        }
    }
}

