/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.library.IrLibrary;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\"\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0013\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u001a\u0010\u0013\u001a\u00020\u0011*\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0005\u00a8\u0006\u0017"}, d2={"deserializeFqName", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fqn", "", "", "createFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "irInterner", "Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "deserializeFileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "fileEntryProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileEntry;", "deserializeFileEntryName", "fileEntry", "protoFile", "Lorg/jetbrains/kotlin/library/IrLibrary$IrDirectory;", "fileIndex", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrFileDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public final class IrFileDeserializerKt {
    @NotNull
    public static final String deserializeFqName(@NotNull IrLibraryFile $this$deserializeFqName, @NotNull List<Integer> fqn) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeFqName, (String)"<this>");
        Intrinsics.checkNotNullParameter(fqn, (String)"fqn");
        return CollectionsKt.joinToString$default((Iterable)fqn, (CharSequence)".", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, String>((Object)$this$deserializeFqName){

            public final String invoke(int p0) {
                return ((IrLibraryFile)this.receiver).string(p0);
            }
        }), (int)30, null);
    }

    @NotNull
    public static final String deserializeFileEntryName(@NotNull IrLibraryFile $this$deserializeFileEntryName, @NotNull FileEntry fileEntryProto) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$deserializeFileEntryName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileEntryProto, (String)"fileEntryProto");
        if (fileEntryProto.hasName()) {
            string = $this$deserializeFileEntryName.string(fileEntryProto.getName());
        } else if (fileEntryProto.hasNameOld()) {
            String string2 = fileEntryProto.getNameOld();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameOld(...)");
        } else {
            throw new IllegalStateException("Malformed KLIB: File entry has no name".toString());
        }
        return string;
    }

    @NotNull
    public static final FileEntry fileEntry(@NotNull IrLibrary.IrDirectory $this$fileEntry, @NotNull IrFile protoFile, int fileIndex) {
        FileEntry fileEntry;
        Intrinsics.checkNotNullParameter((Object)$this$fileEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        if (protoFile.hasFileEntryId() && $this$fileEntry.getHasFileEntriesTable()) {
            byte[] byArray = $this$fileEntry.fileEntry(protoFile.getFileEntryId(), fileIndex);
            if (byArray == null) {
                throw new IllegalStateException("Invalid KLib: cannot read file entry by its index".toString());
            }
            byte[] fileEntry2 = byArray;
            FileEntry fileEntry3 = FileEntry.parseFrom(fileEntry2);
            Intrinsics.checkNotNull((Object)fileEntry3);
            fileEntry = fileEntry3;
        } else {
            if (!protoFile.hasFileEntry()) {
                boolean bl = false;
                String string = "Invalid KLib: either fileEntry or valid fileEntryId must be present. Valid fileEntryId is a valid index in existing file entries table";
                throw new IllegalArgumentException(string.toString());
            }
            FileEntry fileEntry4 = protoFile.getFileEntry();
            Intrinsics.checkNotNull((Object)fileEntry4);
            fileEntry = fileEntry4;
        }
        return fileEntry;
    }
}

