/*
 * Copyright 2023-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// Copyright (C) 2021-2023 Brian Norman
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.jetbrains.kotlin.powerassert.delegate

import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope
import org.jetbrains.kotlin.ir.builders.irCall
import org.jetbrains.kotlin.ir.builders.parent
import org.jetbrains.kotlin.ir.declarations.IrFunction
import org.jetbrains.kotlin.ir.declarations.IrValueParameter
import org.jetbrains.kotlin.ir.expressions.IrCall
import org.jetbrains.kotlin.ir.expressions.IrExpression
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol
import org.jetbrains.kotlin.ir.util.deepCopyWithSymbols
import org.jetbrains.kotlin.utils.addToStdlib.assignFrom

interface FunctionDelegate {
    val function: IrFunction
    val messageParameter: IrValueParameter

    fun buildCall(
        builder: IrBuilderWithScope,
        original: IrCall,
        arguments: List<IrExpression?>,
        messageArgument: IrExpression,
    ): IrExpression

    fun IrBuilderWithScope.irCallCopy(
        overload: IrSimpleFunctionSymbol,
        original: IrCall,
        arguments: List<IrExpression?>,
        messageArgument: IrExpression,
    ): IrExpression {
        return irCall(overload, type = original.type).apply {
            for (i in original.typeArguments.indices) {
                typeArguments[i] = original.typeArguments[i]
            }
            this.arguments.assignFrom(arguments) { it?.deepCopyWithSymbols(parent) }
            this.arguments.add(messageArgument.deepCopyWithSymbols(parent))
        }
    }
}
