/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationContextInFile;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginCompanionCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializersClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001b\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\"\u001a\u00020\u0005*\u00020\u0010H\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010$\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010%\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010*\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010+\u001a\u00020\u0005*\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010/\u001a\u00020\b2\u0006\u0010\t\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u00101\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J&\u00103\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00102\f\u00105\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J*\u00106\u001a\u00020\b2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<H\u0002J6\u0010=\u001a\u00020\b*\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u00107\u001a\u0002082\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<H\u0002J\f\u0010C\u001a\u00020\u0005*\u000208H\u0002J6\u0010D\u001a\u00020\b*\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<H\u0002J:\u0010E\u001a\u00020\b2\u0006\u0010?\u001a\u00020@2\u0006\u0010F\u001a\u0002082\u0006\u0010\u000b\u001a\u00020G2\b\u0010A\u001a\u0004\u0018\u00010H2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<H\u0002J:\u0010I\u001a\u00020\b2\u0006\u0010?\u001a\u00020@2\u0006\u0010F\u001a\u0002082\u0006\u0010\u000b\u001a\u00020G2\b\u0010A\u001a\u0004\u0018\u00010H2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<H\u0002J(\u0010J\u001a\u00020\b2\u0006\u0010?\u001a\u00020@2\u0006\u0010\t\u001a\u00020G2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010K\u001a\u00020<H\u0002J:\u0010L\u001a\u00020\u00052\u0006\u0010?\u001a\u00020@2\u0006\u0010\t\u001a\u00020G2\u0006\u0010M\u001a\u0002082\b\u0010A\u001a\u0004\u0018\u00010H2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J2\u0010N\u001a\u00020\b2\u0006\u0010F\u001a\u0002082\u0006\u0010O\u001a\u0002082\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u001c\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010(\u001a\u00020\u0005*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006P\u00b2\u0006\n\u0010Q\u001a\u00020HX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "useLegacyEnumSerializerCached", "", "Ljava/lang/Boolean;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkMetaSerializableApplicable", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkKeepGeneratedSerializer", "checkInheritableSerialInfoNotRepeatable", "checkExternalSerializer", "classDescriptor", "checkInheritedAnnotations", "checkMinRuntime", "versions", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/RuntimeVersions;", "checkMinKotlin", "isIde", "()Z", "checkCorrectTransientAnnotationIsUsed", "properties", "", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "useLegacyGeneratedEnumSerializer", "canBeSerializedInternally", "checkClassWithCustomSerializer", "checkVisibility", "annotationPsi", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "isAnonymousObjectOrContained", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "checkEnum", "isSerializableEnumWithMissingSerializer", "serializationPluginEnabledOn", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "checkTransients", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "checkProtobufProperties", "declarationHasInitializer", "analyzePropertiesSerializers", "serializableClass", "props", "checkGenericArrayType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktType", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "fallbackElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkTypeArguments", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationContextInFile;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "element", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "isUnsupportedInlineType", "checkType", "checkCustomSerializerNotAbstract", "classType", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkCustomSerializerMatch", "checkCustomSerializerIsNotLocal", "declarationElement", "checkCustomSerializerParameters", "serializableType", "checkSerializerNullability", "serializerType", "kotlinx-serialization-compiler-plugin.k1", "entry"})
@SourceDebugExtension(value={"SMAP\nSerializationPluginDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializationPluginDeclarationChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerializationPluginDeclarationChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationCheckerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 SearchUtils.kt\norg/jetbrains/kotlinx/serialization/compiler/resolve/SearchUtilsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,768:1\n1807#2,2:769\n1786#2,3:771\n1809#2:774\n672#2,11:775\n672#2,11:786\n672#2,11:797\n1915#2,2:808\n1807#2,3:814\n672#2,11:818\n1915#2,2:829\n1807#2,3:831\n1915#2:834\n1916#2:837\n1924#2,2:840\n672#2,11:846\n1926#2:857\n1915#2,2:876\n1924#2,3:878\n672#2,11:881\n1915#2,2:892\n1586#2:894\n1661#2,3:895\n777#2:898\n873#2,2:899\n754#3,2:810\n754#3,2:812\n754#3,2:835\n1#4:817\n221#5,2:838\n221#5:858\n222#5:873\n221#5,2:874\n54#6,4:842\n383#7,7:859\n383#7,7:866\n*S KotlinDebug\n*F\n+ 1 SerializationPluginDeclarationChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker\n*L\n114#1:769,2\n116#1:771,3\n114#1:774\n132#1:775,11\n137#1:786,11\n144#1:797,11\n179#1:808,2\n239#1:814,3\n301#1:818,11\n352#1:829,2\n377#1:831,3\n400#1:834\n400#1:837\n453#1:840,2\n457#1:846,11\n453#1:857\n531#1:876,2\n571#1:878,3\n691#1:881,11\n720#1:892,2\n169#1:894\n169#1:895,3\n170#1:898\n170#1:899,2\n205#1:810,2\n220#1:812,2\n402#1:835,2\n418#1:838,2\n485#1:858\n485#1:873\n493#1:874,2\n457#1:842,4\n487#1:859,7\n489#1:866,7\n*E\n"})
public class SerializationPluginDeclarationChecker
implements DeclarationChecker {
    @Nullable
    private Boolean useLegacyEnumSerializerCached;

    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        this.checkMetaSerializableApplicable((ClassDescriptor)descriptor, context.getTrace());
        this.checkInheritableSerialInfoNotRepeatable((ClassDescriptor)descriptor, context.getTrace());
        this.checkEnum((ClassDescriptor)descriptor, declaration, context.getTrace());
        this.checkExternalSerializer((ClassDescriptor)descriptor, declaration, context.getTrace());
        this.checkKeepGeneratedSerializer((ClassDescriptor)descriptor, declaration, context.getTrace());
        if (!this.canBeSerializedInternally((ClassDescriptor)descriptor, declaration, context.getTrace())) {
            return;
        }
        if (!(declaration instanceof KtPureClassOrObject)) {
            return;
        }
        if (!this.isIde()) {
            RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor), context.getTrace());
            if (runtimeVersions != null) {
                RuntimeVersions it = runtimeVersions;
                boolean bl = false;
                this.checkMinKotlin(it, (ClassDescriptor)descriptor, context.getTrace());
                this.checkMinRuntime(it, (ClassDescriptor)descriptor, context.getTrace());
            }
        }
        SerializableProperties serializableProperties = this.buildSerializableProperties((ClassDescriptor)descriptor, context.getTrace());
        if (serializableProperties == null) {
            return;
        }
        SerializableProperties props = serializableProperties;
        this.checkCorrectTransientAnnotationIsUsed((ClassDescriptor)descriptor, props.getSerializableProperties(), context.getTrace());
        this.checkProtobufProperties(props.getSerializableProperties(), context.getTrace());
        this.checkTransients((KtPureClassOrObject)declaration, context.getTrace());
        this.analyzePropertiesSerializers(context.getTrace(), (ClassDescriptor)descriptor, props.getSerializableProperties());
        this.checkInheritedAnnotations((ClassDescriptor)descriptor, declaration, context.getTrace());
    }

    private final void checkMetaSerializableApplicable(ClassDescriptor descriptor, BindingTrace trace) {
        if (descriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)descriptor));
        if (!(classId != null ? classId.isNestedClass() : false)) {
            return;
        }
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findAnnotationDeclaration((Annotated)descriptor, SerializationAnnotations.INSTANCE.getMetaSerializableAnnotationFqName());
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry entry = ktAnnotationEntry;
        trace.report((Diagnostic)SerializationErrors.META_SERIALIZABLE_NOT_APPLICABLE.on((PsiElement)entry));
    }

    private final void checkKeepGeneratedSerializer(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        if (!KSerializationUtilKt.getKeepGeneratedSerializer(descriptor)) {
            return;
        }
        Lazy entry$delegate = LazyKt.lazy(() -> SerializationPluginDeclarationChecker.checkKeepGeneratedSerializer$lambda$0(descriptor, declaration));
        if (KSerializationUtilKt.getHasSerializableOrMetaAnnotation(descriptor)) {
            if (KSerializationUtilKt.getHasSerializableOrMetaAnnotationWithoutArgs(descriptor)) {
                trace.report((Diagnostic)SerializationErrors.KEEP_SERIALIZER_ANNOTATION_USELESS.on((PsiElement)SerializationPluginDeclarationChecker.checkKeepGeneratedSerializer$lambda$1((Lazy<? extends KtElement>)entry$delegate)));
            }
            if (KSerializationUtilKt.isAbstractOrSealedOrInterface(descriptor) || KSerializationUtilKt.getHasPolymorphicAnnotation(descriptor)) {
                trace.report((Diagnostic)SerializationErrors.KEEP_SERIALIZER_ANNOTATION_ON_POLYMORPHIC.on((PsiElement)SerializationPluginDeclarationChecker.checkKeepGeneratedSerializer$lambda$1((Lazy<? extends KtElement>)entry$delegate)));
            }
        } else {
            trace.report((Diagnostic)SerializationErrors.KEEP_SERIALIZER_ANNOTATION_USELESS.on((PsiElement)SerializationPluginDeclarationChecker.checkKeepGeneratedSerializer$lambda$1((Lazy<? extends KtElement>)entry$delegate)));
        }
    }

    private final void checkInheritableSerialInfoNotRepeatable(ClassDescriptor descriptor, BindingTrace trace) {
        if (descriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        if (!DescriptorUtilsKt.isAnnotatedWithKotlinRepeatable((Annotated)((Annotated)descriptor))) {
            Annotations annotations = descriptor.getAnnotations();
            FqName fqName = JvmAnnotationNames.REPEATABLE_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"REPEATABLE_ANNOTATION");
            if (!annotations.hasAnnotation(fqName)) {
                return;
            }
        }
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findAnnotationDeclaration((Annotated)descriptor, SerializationAnnotations.INSTANCE.getInheritableSerialInfoFqName());
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry inheritableAnno = ktAnnotationEntry;
        trace.report((Diagnostic)SerializationErrors.INHERITABLE_SERIALINFO_CANT_BE_REPEATABLE.on((PsiElement)inheritableAnno));
    }

    /*
     * Unable to fully structure code
     */
    private final void checkExternalSerializer(ClassDescriptor classDescriptor, KtDeclaration declaration, BindingTrace trace) {
        block25: {
            block24: {
                block23: {
                    block26: {
                        block22: {
                            block27: {
                                v0 = KSerializationUtilKt.getSerializerForClass((DeclarationDescriptor)classDescriptor);
                                if (v0 == null) {
                                    return;
                                }
                                serializableKType = v0;
                                v1 = KSerializationUtilKt.toClassDescriptor(serializableKType);
                                if (v1 == null) {
                                    return;
                                }
                                serializableDescriptor = v1;
                                v2 = trace.getBindingContext();
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getBindingContext(...)");
                                props = new SerializableProperties(serializableDescriptor, v2);
                                parametersCount = serializableKType.getArguments().size();
                                if (parametersCount <= 0) break block26;
                                v3 = classDescriptor.getConstructors();
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getConstructors(...)");
                                $this$any$iv = v3;
                                $i$f$any = false;
                                if (!((Collection)$this$any$iv).isEmpty()) break block27;
                                v4 = false;
                                break block22;
                            }
                            for (T element$iv : $this$any$iv) {
                                block21: {
                                    constructor = (ClassConstructorDescriptor)element$iv;
                                    $i$a$-any-SerializationPluginDeclarationChecker$checkExternalSerializer$hasSuitableConstructor$1 = false;
                                    if (constructor.getValueParameters().size() != parametersCount) ** GOTO lbl-1000
                                    v5 = constructor.getValueParameters();
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getValueParameters(...)");
                                    $this$all$iv = v5;
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        v6 = true;
                                    } else {
                                        for (T element$iv : $this$all$iv) {
                                            param = (ValueParameterDescriptor)element$iv;
                                            $i$a$-all-SerializationPluginDeclarationChecker$checkExternalSerializer$hasSuitableConstructor$1$1 = false;
                                            if (KSerializationUtilKt.isKSerializer(param.getType())) continue;
                                            v6 = false;
                                            break block21;
                                        }
                                        v6 = true;
                                    }
                                }
                                if (v6) {
                                    v7 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v7 = false;
                                }
                                if (!v7) continue;
                                v4 = true;
                                break block22;
                            }
                            v4 = hasSuitableConstructor = false;
                        }
                        if (!hasSuitableConstructor) {
                            trace.report((Diagnostic)SerializationErrors.EXTERNAL_SERIALIZER_NO_SUITABLE_CONSTRUCTOR.on((PsiElement)declaration, (Object)classDescriptor.getDefaultType(), (Object)serializableKType, (Object)String.valueOf(parametersCount)));
                        }
                    }
                    $this$singleOrNull$iv = classDescriptor.getUnsubstitutedMemberScope().getContributedVariables(SerialEntityNames.INSTANCE.getSERIAL_DESC_FIELD_NAME(), (LookupLocation)NoLookupLocation.FROM_BACKEND);
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (PropertyDescriptor)element$iv;
                        $i$a$-singleOrNull-SerializationPluginDeclarationChecker$checkExternalSerializer$descriptorOverridden$1 = false;
                        if (!(it.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED)) continue;
                        if (found$iv) {
                            v8 = null;
                            break block23;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v8 = found$iv == false ? null : single$iv;
                }
                descriptorOverridden = v8 != null;
                $this$singleOrNull$iv = classDescriptor.getUnsubstitutedMemberScope().getContributedFunctions(SerialEntityNames.INSTANCE.getSAVE_NAME(), (LookupLocation)NoLookupLocation.FROM_BACKEND);
                $i$f$singleOrNull = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$singleOrNull$iv) {
                    it = (SimpleFunctionDescriptor)element$iv;
                    $i$a$-singleOrNull-SerializationPluginDeclarationChecker$checkExternalSerializer$serializeOverridden$1 = false;
                    if (it.getValueParameters().size() != 2) ** GOTO lbl-1000
                    v9 = it.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getOverriddenDescriptors(...)");
                    if (v9.isEmpty() == false && it.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                        v10 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v10 = false;
                    }
                    if (!v10) continue;
                    if (found$iv) {
                        v11 = null;
                        break block24;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v11 = found$iv == false ? null : single$iv;
            }
            serializeOverridden = v11 != null;
            $this$singleOrNull$iv = classDescriptor.getUnsubstitutedMemberScope().getContributedFunctions(SerialEntityNames.INSTANCE.getLOAD_NAME(), (LookupLocation)NoLookupLocation.FROM_BACKEND);
            $i$f$singleOrNull = false;
            single$iv = null;
            found$iv = false;
            for (T element$iv : $this$singleOrNull$iv) {
                it = (SimpleFunctionDescriptor)element$iv;
                $i$a$-singleOrNull-SerializationPluginDeclarationChecker$checkExternalSerializer$deserializeOverridden$1 = false;
                if (it.getValueParameters().size() != 1) ** GOTO lbl-1000
                v12 = it.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getOverriddenDescriptors(...)");
                if (v12.isEmpty() == false && it.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                    v13 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v13 = false;
                }
                if (!v13) continue;
                if (found$iv) {
                    v14 = null;
                    break block25;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v14 = found$iv == false ? null : single$iv;
        }
        v15 = deserializeOverridden = v14 != null;
        if (descriptorOverridden && serializeOverridden && deserializeOverridden) {
            v16 = entry = KSerializationUtilKt.findAnnotationDeclaration((Annotated)classDescriptor, SerializationAnnotations.INSTANCE.getSerializerAnnotationFqName());
            trace.report((Diagnostic)SerializationErrors.EXTERNAL_SERIALIZER_USELESS.on((PsiElement)(v16 != null ? (KtElement)v16 : (KtElement)declaration), (Object)classDescriptor.getDefaultType()));
            return;
        }
        if (!props.isExternallySerializable()) {
            entry = KSerializationUtilKt.findAnnotationDeclaration((Annotated)classDescriptor, SerializationAnnotations.INSTANCE.getSerializerAnnotationFqName());
            inSameModule = trace.getBindingContext().get((ReadOnlySlice)BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, (Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)serializableDescriptor))) != null;
            diagnostic = inSameModule != false ? SerializationErrors.EXTERNAL_CLASS_NOT_SERIALIZABLE : SerializationErrors.EXTERNAL_CLASS_IN_ANOTHER_MODULE;
            v17 = entry;
            trace.report((Diagnostic)diagnostic.on((PsiElement)(v17 != null ? (KtElement)v17 : (KtElement)declaration), (Object)classDescriptor.getDefaultType(), (Object)serializableKType));
        }
    }

    private final void checkInheritedAnnotations(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        Function1 annotationsFilter = SerializationPluginDeclarationChecker::checkInheritedAnnotations$lambda$0;
        Map annotationByFq = new LinkedHashMap();
        Set reported = new LinkedHashSet();
        MapsKt.putAll((Map)annotationByFq, (Iterable)((Iterable)annotationsFilter.invoke((Object)descriptor.getAnnotations())));
        for (ClassifierDescriptor clazz : DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)descriptor))) {
            List annotations = (List)annotationsFilter.invoke((Object)clazz.getAnnotations());
            Iterable $this$forEach$iv = annotations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotationDescriptor existing;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                FqName fqname = (FqName)pair.component1();
                AnnotationDescriptor call = (AnnotationDescriptor)pair.component2();
                if (!annotationByFq.containsKey(fqname) || Intrinsics.areEqual((Object)(existing = (AnnotationDescriptor)MapsKt.getValue((Map)annotationByFq, (Object)fqname)).getAllValueArguments(), (Object)call.getAllValueArguments()) || !reported.add(fqname)) continue;
                LazyAnnotationDescriptor lazyAnnotationDescriptor = existing instanceof LazyAnnotationDescriptor ? (LazyAnnotationDescriptor)existing : null;
                KtElement entry = lazyAnnotationDescriptor != null && (lazyAnnotationDescriptor = lazyAnnotationDescriptor.getAnnotationEntry()) != null ? (KtElement)lazyAnnotationDescriptor : (KtElement)declaration;
                trace.report((Diagnostic)SerializationErrors.INCONSISTENT_INHERITABLE_SERIALINFO.on((PsiElement)entry, (Object)existing.getType(), (Object)clazz.getDefaultType()));
            }
        }
    }

    private final void checkMinRuntime(RuntimeVersions versions, ClassDescriptor descriptor, BindingTrace trace) {
        block3: {
            if (versions.implementationVersionMatchSupported()) break block3;
            ClassDescriptor $this$onSerializableOrMetaAnnotation$iv = descriptor;
            boolean $i$f$onSerializableOrMetaAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)$this$onSerializableOrMetaAnnotation$iv);
            if (ktAnnotationEntry != null) {
                String string;
                KtAnnotationEntry it = ktAnnotationEntry;
                boolean bl = false;
                PsiElement psiElement = (PsiElement)it;
                Object object = versions.getImplementationVersion();
                if (object == null || (object = object.toString()) == null) {
                    object = "too low";
                }
                if ((string = KotlinCompilerVersion.getVersion()) == null) {
                    string = "unknown";
                }
                trace.report((Diagnostic)SerializationErrors.PROVIDED_RUNTIME_TOO_LOW.on(psiElement, object, (Object)string, (Object)RuntimeVersions.Companion.getMINIMAL_SUPPORTED_VERSION().toString()));
            }
        }
    }

    private final void checkMinKotlin(RuntimeVersions versions, ClassDescriptor descriptor, BindingTrace trace) {
        block4: {
            Object object;
            Object object2;
            if (versions.currentCompilerMatchRequired()) {
                return;
            }
            ClassDescriptor $this$onSerializableOrMetaAnnotation$iv = descriptor;
            boolean $i$f$onSerializableOrMetaAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)$this$onSerializableOrMetaAnnotation$iv);
            if (ktAnnotationEntry == null) break block4;
            KtAnnotationEntry it = ktAnnotationEntry;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)it;
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                string = "too low";
            }
            if ((object2 = versions.getImplementationVersion()) == null || (object2 = object2.toString()) == null) {
                object2 = "unknown";
            }
            if ((object = versions.getRequireKotlinVersion()) == null || (object = object.toString()) == null) {
                object = "N/A";
            }
            trace.report((Diagnostic)SerializationErrors.REQUIRED_KOTLIN_TOO_HIGH.on(psiElement, (Object)string, object2, object));
        }
    }

    protected boolean isIde() {
        return false;
    }

    private final void checkCorrectTransientAnnotationIsUsed(ClassDescriptor descriptor, List<SerializableProperty> properties, BindingTrace trace) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)).asString(), (Object)"java.io.Serializable")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (SerializableProperty prop : properties) {
            PsiElement psiElement;
            FieldDescriptor fieldDescriptor;
            AnnotationDescriptor incorrectTransient;
            if (prop.getTransient() || (incorrectTransient = (fieldDescriptor = prop.getDescriptor().getBackingField()) != null && (fieldDescriptor = fieldDescriptor.getAnnotations()) != null ? fieldDescriptor.findAnnotation(JvmStandardClassIds.TRANSIENT_ANNOTATION_FQ_NAME) : null) == null || (psiElement = PsiSourceElementKt.getPsi((SourceElement)incorrectTransient.getSource())) == null && (psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)prop.getDescriptor()))) == null) continue;
            PsiElement elementToReport = psiElement;
            trace.report((Diagnostic)SerializationErrors.INCORRECT_TRANSIENT.on(elementToReport));
        }
    }

    private final boolean useLegacyGeneratedEnumSerializer(ClassDescriptor $this$useLegacyGeneratedEnumSerializer) {
        boolean bl;
        Boolean bl2 = this.useLegacyEnumSerializerCached;
        if (bl2 != null) {
            bl = bl2;
        } else {
            boolean bl3;
            boolean it = bl3 = KSerializationUtilKt.getUseGeneratedEnumSerializer($this$useLegacyGeneratedEnumSerializer);
            boolean bl4 = false;
            this.useLegacyEnumSerializerCached = it;
            bl = bl3;
        }
        return bl;
    }

    private final boolean canBeSerializedInternally(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        ClassDescriptor superClass;
        if (this.useLegacyGeneratedEnumSerializer(descriptor) && this.isSerializableEnumWithMissingSerializer(descriptor)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            KtElement declarationToReport = ktModifierList != null ? (KtElement)ktModifierList : (KtElement)declaration;
            trace.report((Diagnostic)SerializationErrors.EXPLICIT_SERIALIZABLE_IS_REQUIRED.on((PsiElement)declarationToReport));
            return false;
        }
        SerializationPluginCompanionCheckerKt.checkCompanionSerializerDependency(descriptor, declaration, trace);
        if (!KSerializationUtilKt.getHasSerializableOrMetaAnnotation(descriptor)) {
            return false;
        }
        SerializationPluginCompanionCheckerKt.checkCompanionOfSerializableClass(descriptor, trace);
        if (!this.serializationPluginEnabledOn(descriptor)) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.PLUGIN_IS_NOT_ENABLED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PLUGIN_IS_NOT_ENABLED");
            SerializationPluginDeclarationCheckerKt.reportOnSerializableOrMetaAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (this.isAnonymousObjectOrContained(descriptor)) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.ANONYMOUS_OBJECTS_NOT_SUPPORTED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"ANONYMOUS_OBJECTS_NOT_SUPPORTED");
            SerializationPluginDeclarationCheckerKt.reportOnSerializableOrMetaAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (descriptor.isInner()) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.INNER_CLASSES_NOT_SUPPORTED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"INNER_CLASSES_NOT_SUPPORTED");
            SerializationPluginDeclarationCheckerKt.reportOnSerializableOrMetaAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (!KSerializationUtilKt.getHasSerializableOrMetaAnnotationWithoutArgs(descriptor)) {
            this.checkClassWithCustomSerializer(descriptor, declaration, trace);
            if (!KSerializationUtilKt.getKeepGeneratedSerializer(descriptor)) {
                return false;
            }
        }
        if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(descriptor)) {
            DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.SERIALIZABLE_ANNOTATION_IGNORED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"SERIALIZABLE_ANNOTATION_IGNORED");
            SerializationPluginDeclarationCheckerKt.reportOnSerializableOrMetaAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (descriptor.getKind() != ClassKind.ENUM_CLASS && !KSerializationUtilKt.getShouldHaveInternalSerializer(superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)descriptor))) {
            Object v6;
            block12: {
                Collection collection = superClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getConstructors(...)");
                Iterable $this$singleOrNull$iv = collection;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getValueParameters().size() == 0)) continue;
                    if (found$iv) {
                        v6 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v6 = !found$iv ? null : single$iv;
            }
            if (v6 == null) {
                DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR");
                SerializationPluginDeclarationCheckerKt.reportOnSerializableOrMetaAnnotation(trace, descriptor, diagnosticFactory0);
                return false;
            }
        }
        return true;
    }

    private final void checkClassWithCustomSerializer(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        KtAnnotationEntry annotationPsi = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)descriptor);
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
        SimpleType simpleType = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        this.checkCustomSerializerMatch(moduleDescriptor, (KotlinType)simpleType, (Annotated)descriptor, (KtElement)annotationPsi, trace, (PsiElement)declaration);
        this.checkCustomSerializerIsNotLocal(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), (Annotated)descriptor, trace, (PsiElement)declaration);
        ModuleDescriptor moduleDescriptor2 = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
        Annotated annotated = (Annotated)descriptor;
        SimpleType simpleType2 = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getDefaultType(...)");
        this.checkCustomSerializerParameters(moduleDescriptor2, annotated, (KotlinType)simpleType2, (KtElement)annotationPsi, (PsiElement)declaration, trace);
        ModuleDescriptor moduleDescriptor3 = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
        SimpleType simpleType3 = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"getDefaultType(...)");
        this.checkCustomSerializerNotAbstract(moduleDescriptor3, (KotlinType)simpleType3, (Annotated)descriptor, (KtElement)annotationPsi, trace, (PsiElement)declaration);
        this.checkVisibility(descriptor, declaration, annotationPsi, trace);
    }

    private final void checkVisibility(ClassDescriptor classDescriptor, KtDeclaration declaration, KtAnnotationEntry annotationPsi, BindingTrace trace) {
        KotlinType kotlinType = KSerializationUtilKt.serializableWith(classDescriptor.getAnnotations(), DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor)));
        if (kotlinType == null || (kotlinType = KSerializationUtilKt.toClassDescriptor(kotlinType)) == null) {
            return;
        }
        KotlinType serializerClass = kotlinType;
        if (Intrinsics.areEqual((Object)serializerClass.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && !Intrinsics.areEqual((Object)classDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            KtAnnotationEntry ktAnnotationEntry = annotationPsi;
            trace.report((Diagnostic)SerializationErrors.CUSTOM_SERIALIZER_MAY_BE_INACCESSIBLE.on((PsiElement)(ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration), (Object)serializerClass, (Object)classDescriptor));
        }
    }

    private final boolean isAnonymousObjectOrContained(ClassDescriptor $this$isAnonymousObjectOrContained) {
        for (DeclarationDescriptor current = (DeclarationDescriptor)$this$isAnonymousObjectOrContained; current != null; current = current.getContainingDeclaration()) {
            if (!DescriptorUtils.isAnonymousObject((DeclarationDescriptor)current)) continue;
            return true;
        }
        return false;
    }

    private final void checkEnum(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        if (descriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        Map entryBySerialName = new LinkedHashMap();
        Iterable $this$forEach$iv = KSerializationUtilKt.enumEntries(descriptor);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String serialName;
            ClassDescriptor firstEntry;
            ClassDescriptor entryDescriptor = (ClassDescriptor)element$iv;
            boolean bl = false;
            AnnotationDescriptor serialNameAnnotation = KSerializationUtilKt.getSerialNameAnnotation(entryDescriptor.getAnnotations());
            String string = KSerializationUtilKt.getSerialNameValue(entryDescriptor.getAnnotations());
            if (string == null) {
                String string2 = entryDescriptor.getName().asString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            }
            if ((firstEntry = (ClassDescriptor)entryBySerialName.get(serialName = string)) != null) {
                KtElement ktElement;
                AnnotationDescriptor annotationDescriptor = serialNameAnnotation;
                if (annotationDescriptor != null && (annotationDescriptor = SearchUtilsKt.findAnnotationEntry(annotationDescriptor)) != null) {
                    ktElement = (KtElement)annotationDescriptor;
                } else {
                    AnnotationDescriptor annotationDescriptor2 = KSerializationUtilKt.getSerialNameAnnotation(firstEntry.getAnnotations());
                    Object object = annotationDescriptor2 != null ? SearchUtilsKt.findAnnotationEntry(annotationDescriptor2) : null;
                    ktElement = object != null ? (KtElement)object : (KtElement)declaration;
                }
                trace.report((Diagnostic)SerializationErrors.DUPLICATE_SERIAL_NAME_ENUM.on((PsiElement)ktElement, (Object)descriptor.getDefaultType(), (Object)serialName, (Object)entryDescriptor.getName().asString()));
                continue;
            }
            entryBySerialName.put(serialName, entryDescriptor);
        }
    }

    private final boolean isSerializableEnumWithMissingSerializer(ClassDescriptor $this$isSerializableEnumWithMissingSerializer) {
        boolean bl;
        block6: {
            if ($this$isSerializableEnumWithMissingSerializer.getKind() != ClassKind.ENUM_CLASS) {
                return false;
            }
            if (KSerializationUtilKt.getHasSerializableOrMetaAnnotation($this$isSerializableEnumWithMissingSerializer)) {
                return false;
            }
            if (KSerializationUtilKt.getHasAnySerialAnnotation($this$isSerializableEnumWithMissingSerializer.getAnnotations())) {
                return true;
            }
            Iterable $this$any$iv = KSerializationUtilKt.enumEntries($this$isSerializableEnumWithMissingSerializer);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!KSerializationUtilKt.getHasAnySerialAnnotation(it.getAnnotations())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean serializationPluginEnabledOn(@NotNull ClassDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return true;
    }

    private final SerializableProperties buildSerializableProperties(ClassDescriptor descriptor, BindingTrace trace) {
        if (!KSerializationUtilKt.getHasSerializableOrMetaAnnotation(descriptor)) {
            return null;
        }
        if (!KSerializationUtilKt.getShouldHaveInternalSerializer(descriptor)) {
            return null;
        }
        if (KSerializationUtilKt.getHasCompanionObjectAsSerializer(descriptor)) {
            return null;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        SerializableProperties props = new SerializableProperties(descriptor, bindingContext);
        if (!props.isExternallySerializable()) {
            DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY");
            SerializationPluginDeclarationCheckerKt.reportOnSerializableOrMetaAnnotation(trace, descriptor, diagnosticFactory0);
        }
        Set namesSet = new LinkedHashSet();
        Iterable $this$forEach$iv = props.getSerializableProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry a;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            if (namesSet.add(it.getName())) continue;
            ClassDescriptor $this$onSerializableOrMetaAnnotation$iv = descriptor;
            boolean $i$f$onSerializableOrMetaAnnotation = false;
            if (KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)$this$onSerializableOrMetaAnnotation$iv) == null) continue;
            boolean bl2 = false;
            trace.report((Diagnostic)SerializationErrors.DUPLICATE_SERIAL_NAME.on((PsiElement)a, (Object)it.getName()));
        }
        trace.record(SerializationPluginDeclarationCheckerKt.getSERIALIZABLE_PROPERTIES(), (Object)descriptor, (Object)props);
        return props;
    }

    private final void checkTransients(KtPureClassOrObject declaration, BindingTrace trace) {
        Map propertiesMap;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        Map<PropertyDescriptor, KtProperty> map = TypeUtilKt.bodyPropertiesDescriptorsMap(declaration, bindingContext, false);
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
        Map $this$forEach$iv = propertiesMap = MapsKt.plus(map, TypeUtilKt.primaryConstructorPropertiesDescriptorsMap(declaration, bindingContext2));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            KtDeclaration declaration2 = (KtDeclaration)entry.getValue();
            boolean isInitialized = this.declarationHasInitializer(declaration2) || descriptor.isLateInit();
            boolean isMarkedTransient = KSerializationUtilKt.getSerialTransient(descriptor.getAnnotations());
            boolean hasBackingField = ResolveUtilKt.hasBackingField((PropertyDescriptor)descriptor, (BindingContext)trace.getBindingContext());
            if (!hasBackingField && isMarkedTransient) {
                KtAnnotationEntry transientPsi;
                AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(SerializationAnnotations.INSTANCE.getSerialTransientFqName());
                LazyAnnotationDescriptor lazyAnnotationDescriptor = annotationDescriptor instanceof LazyAnnotationDescriptor ? (LazyAnnotationDescriptor)annotationDescriptor : null;
                KtAnnotationEntry ktAnnotationEntry = transientPsi = lazyAnnotationDescriptor != null ? lazyAnnotationDescriptor.getAnnotationEntry() : null;
                trace.report((Diagnostic)SerializationErrors.TRANSIENT_IS_REDUNDANT.on((PsiElement)(ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2)));
            }
            if (!isMarkedTransient || isInitialized || !hasBackingField) continue;
            trace.report((Diagnostic)SerializationErrors.TRANSIENT_MISSING_INITIALIZER.on((PsiElement)declaration2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkProtobufProperties(List<SerializableProperty> properties, BindingTrace trace) {
        Integer protoNumber;
        int originNumber;
        Map annotationFqName$iv;
        Map.Entry entry;
        Map originToCustom = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = properties;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Integer n;
            void $this$findAnnotationConstantValue$iv;
            void property;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            entry = (SerializableProperty)item$iv;
            int index = n2;
            boolean bl = false;
            Annotations annotations = property.getDescriptor().getAnnotations();
            FqName fqName = SerializationAnnotations.INSTANCE.getProtoNumberAnnotationFqName();
            String string = "number";
            boolean $i$f$findAnnotationConstantValue = false;
            if ($this$findAnnotationConstantValue$iv.findAnnotation((FqName)annotationFqName$iv) != null) {
                Object object;
                Map.Entry entry2;
                Object v0;
                block19: {
                    void $this$findConstantValue$iv$iv;
                    void property$iv;
                    void property$iv$iv = property$iv;
                    boolean $i$f$findConstantValue = false;
                    Iterable $this$singleOrNull$iv$iv$iv = $this$findConstantValue$iv$iv.getAllValueArguments().entrySet();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv$iv$iv = null;
                    boolean found$iv$iv$iv = false;
                    for (Object element$iv$iv$iv : $this$singleOrNull$iv$iv$iv) {
                        Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)((Name)it$iv$iv.getKey()).asString(), (Object)property$iv$iv)) continue;
                        if (found$iv$iv$iv) {
                            v0 = null;
                            break block19;
                        }
                        single$iv$iv$iv = element$iv$iv$iv;
                        found$iv$iv$iv = true;
                    }
                    v0 = !found$iv$iv$iv ? null : single$iv$iv$iv;
                }
                if (!(((entry2 = (Map.Entry)v0) != null && (entry2 = (ConstantValue)entry2.getValue()) != null ? entry2.getValue() : (object = null)) instanceof Integer)) {
                    object = null;
                }
                n = (Integer)object;
            } else {
                n = null;
            }
            if (n == null) {
                continue;
            }
            int customNumber = n;
            originToCustom.put(index + 1, customNumber);
        }
        if (originToCustom.isEmpty()) {
            return;
        }
        Map originToProto = new LinkedHashMap();
        int number = 1;
        index$iv = properties.size();
        if (number <= index$iv) {
            while (true) {
                if (!properties.get(number - 1).getDescriptor().getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getProtoOneOfAnnotationFqName())) {
                    originToProto.put(number, originToCustom.get(number));
                }
                if (number == index$iv) break;
                ++number;
            }
        }
        Map duplicates = new LinkedHashMap();
        Map $this$forEach$iv = originToProto;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Object object;
            boolean bl;
            List answer$iv;
            Object value$iv;
            Map $this$getOrPut$iv;
            boolean $i$f$getOrPut;
            Integer key$iv;
            entry = element$iv;
            boolean bl3 = false;
            originNumber = ((Number)entry.getKey()).intValue();
            protoNumber = (Integer)entry.getValue();
            if (protoNumber != null) {
                Object object2;
                annotationFqName$iv = duplicates;
                key$iv = protoNumber;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                bl = ((List)object2).add(originNumber);
                continue;
            }
            $this$getOrPut$iv = duplicates;
            key$iv = originNumber;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl5 = false;
                answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            bl = ((List)object).add(null);
        }
        $this$forEach$iv = originToProto;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            KtAnnotationEntry annotation;
            SerializableProperty property;
            List duplicates2;
            Map.Entry element$iv;
            entry = element$iv = iterator.next();
            boolean bl = false;
            originNumber = ((Number)entry.getKey()).intValue();
            protoNumber = (Integer)entry.getValue();
            if (protoNumber == null || (duplicates2 = (List)MapsKt.getValue((Map)duplicates, (Object)protoNumber)).size() < 2 || KSerializationUtilKt.findAnnotationDeclaration((Annotated)(property = properties.get(originNumber - 1)).getDescriptor(), SerializationAnnotations.INSTANCE.getProtoNumberAnnotationFqName()) == null) continue;
            String duplicateFieldsNames = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)duplicates2), arg_0 -> SerializationPluginDeclarationChecker.checkProtobufProperties$lambda$2$0(protoNumber, arg_0)), arg_0 -> SerializationPluginDeclarationChecker.checkProtobufProperties$lambda$2$1(originNumber, arg_0)), arg_0 -> SerializationPluginDeclarationChecker.checkProtobufProperties$lambda$2$2(properties, arg_0)), null, null, null, (int)0, null, null, (int)63, null);
            trace.report((Diagnostic)SerializationErrors.PROTOBUF_PROTO_NUM_DUPLICATED.on((PsiElement)annotation, (Object)property.getDescriptor().getName().asString(), (Object)duplicateFieldsNames));
        }
    }

    private final boolean declarationHasInitializer(KtDeclaration declaration) {
        KtDeclaration ktDeclaration = declaration;
        return ktDeclaration instanceof KtParameter ? ((KtParameter)declaration).hasDefaultValue() : (ktDeclaration instanceof KtProperty ? ((KtProperty)declaration).hasDelegateExpressionOrInitializer() : false);
    }

    private final void analyzePropertiesSerializers(BindingTrace trace, ClassDescriptor serializableClass, List<SerializableProperty> props) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        SerializationContextInFile serializersDeclaredOnFile = new SerializationContextInFile(bindingContext, serializableClass);
        Iterable $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference ktType;
            PsiElement propertyPsi;
            ClassDescriptor serializer;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getSerializableWith();
            Object object = serializer = kotlinType != null ? KSerializationUtilKt.toClassDescriptor(kotlinType) : null;
            if (SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)it.getDescriptor())) == null) continue;
            KtCallableDeclaration ktCallableDeclaration = propertyPsi instanceof KtCallableDeclaration ? (KtCallableDeclaration)propertyPsi : null;
            Object object2 = ktType = ktCallableDeclaration != null ? ktCallableDeclaration.getTypeReference() : null;
            if (serializer != null) {
                KtTypeReference ktTypeReference = ktType;
                KtTypeElement element = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                this.checkCustomSerializerMatch(it.getModule(), it.getType(), (Annotated)it.getDescriptor(), (KtElement)element, trace, propertyPsi);
                KtAnnotationEntry annotationPsi = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)it.getDescriptor());
                this.checkCustomSerializerNotAbstract(it.getModule(), it.getType(), (Annotated)it.getDescriptor(), (KtElement)annotationPsi, trace, propertyPsi);
                boolean hasParameters = this.checkCustomSerializerParameters(it.getModule(), (Annotated)it.getDescriptor(), it.getType(), (KtElement)annotationPsi, propertyPsi, trace);
                this.checkCustomSerializerIsNotLocal(it.getModule(), (Annotated)it.getDescriptor(), trace, propertyPsi);
                KotlinType kotlinType2 = it.getType();
                SimpleType simpleType = serializer.getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                this.checkSerializerNullability(kotlinType2, (KotlinType)simpleType, element, trace, propertyPsi);
                if (!hasParameters) continue;
                this.checkTypeArguments(serializersDeclaredOnFile, it.getModule(), it.getType(), element, trace, propertyPsi);
                continue;
            }
            this.checkType(serializersDeclaredOnFile, it.getModule(), it.getType(), ktType, trace, propertyPsi);
            this.checkGenericArrayType(it.getType(), ktType, trace, propertyPsi);
        }
    }

    private final void checkGenericArrayType(KotlinType type, KtTypeReference ktType, BindingTrace trace, PsiElement fallbackElement) {
        if (KotlinBuiltIns.isArray((KotlinType)type)) {
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.first((List)type.getArguments())).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (KSerializationUtilKt.getGenericIndex(kotlinType) != null) {
                KtTypeReference ktTypeReference = ktType;
                trace.report((Diagnostic)SerializationErrors.GENERIC_ARRAY_ELEMENT_NOT_SUPPORTED.on(ktTypeReference != null ? (PsiElement)ktTypeReference : fallbackElement));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArguments(SerializationContextInFile $this$checkTypeArguments, ModuleDescriptor module, KotlinType type, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Iterable $this$forEachIndexed$iv = type.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n;
            boolean bl = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            Object object = element;
            this.checkType($this$checkTypeArguments, module, kotlinType, object != null && (object = object.getTypeArgumentsAsTypes()) != null ? (KtTypeReference)CollectionsKt.getOrNull((List)object, (int)i) : null, trace, fallbackElement);
        }
    }

    private final boolean isUnsupportedInlineType(KotlinType $this$isUnsupportedInlineType) {
        return InlineClassesUtilsKt.isInlineClassType((KotlinType)$this$isUnsupportedInlineType) && !KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType((KotlinType)$this$isUnsupportedInlineType);
    }

    private final void checkType(SerializationContextInFile $this$checkType, ModuleDescriptor module, KotlinType type, KtTypeReference ktType, BindingTrace trace, PsiElement fallbackElement) {
        if (KSerializationUtilKt.getGenericIndex(type) != null) {
            return;
        }
        KtTypeReference ktTypeReference = ktType;
        KtTypeElement element = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        ClassDescriptor serializer = TypeUtilKt.findTypeSerializerOrContextUnchecked($this$checkType, module, type);
        if (serializer != null) {
            Boolean bl;
            KotlinType kotlinType = KSerializationUtilKt.serializableWith(type.getAnnotations(), module);
            if (kotlinType != null) {
                KotlinType it = kotlinType;
                boolean bl2 = false;
                this.checkCustomSerializerMatch(module, type, (Annotated)type, (KtElement)element, trace, fallbackElement);
                this.checkCustomSerializerIsNotLocal(module, (Annotated)type, trace, fallbackElement);
                KtAnnotationEntry annotationElement = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)type);
                this.checkCustomSerializerNotAbstract(module, type, (Annotated)type, (KtElement)annotationElement, trace, fallbackElement);
                bl = this.checkCustomSerializerParameters(module, (Annotated)type, type, (KtElement)annotationElement, fallbackElement, trace);
            } else {
                bl = null;
            }
            Boolean hasParameters = bl;
            SimpleType simpleType = serializer.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            this.checkSerializerNullability(type, (KotlinType)simpleType, element, trace, fallbackElement);
            if (!Intrinsics.areEqual(hasParameters, (Object)false)) {
                this.checkTypeArguments($this$checkType, module, type, element, trace, fallbackElement);
            }
        } else if (!TypeUtilsKt.isEnum((KotlinType)type)) {
            KtTypeElement ktTypeElement = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NOT_FOUND.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)type));
        }
    }

    private final void checkCustomSerializerNotAbstract(ModuleDescriptor module, KotlinType classType, Annotated descriptor, KtElement element, BindingTrace trace, PsiElement fallbackElement) {
        KotlinType kotlinType = KSerializationUtilKt.serializableWith(descriptor.getAnnotations(), module);
        if (kotlinType == null) {
            return;
        }
        KotlinType serializerType = kotlinType;
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(serializerType);
        boolean bl = classDescriptor != null ? KSerializationUtilKt.isAbstractOrSealedOrInterface(classDescriptor) : false;
        if (bl) {
            KtElement ktElement = element;
            trace.report((Diagnostic)SerializationErrors.ABSTRACT_SERIALIZER_TYPE.on(ktElement != null ? (PsiElement)ktElement : fallbackElement, (Object)classType, (Object)serializerType));
        }
    }

    private final void checkCustomSerializerMatch(ModuleDescriptor module, KotlinType classType, Annotated descriptor, KtElement element, BindingTrace trace, PsiElement fallbackElement) {
        Object object;
        Object v1;
        KotlinType serializerType;
        block4: {
            KotlinType kotlinType = KSerializationUtilKt.serializableWith(descriptor.getAnnotations(), module);
            if (kotlinType == null) {
                return;
            }
            serializerType = kotlinType;
            Iterable iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            for (Object t : iterable) {
                KotlinType it = (KotlinType)t;
                boolean bl = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((object = (KotlinType)v1) == null || (object = object.getArguments()) == null || (object = (TypeProjection)CollectionsKt.first((List)object)) == null || (object = object.getType()) == null) {
            return;
        }
        Object serializerForType = object;
        if (!Intrinsics.areEqual((Object)classType.getConstructor(), (Object)serializerForType.getConstructor())) {
            KtElement ktElement = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_TYPE_INCOMPATIBLE.on(ktElement != null ? (PsiElement)ktElement : fallbackElement, (Object)classType, (Object)serializerType, serializerForType));
        }
    }

    private final void checkCustomSerializerIsNotLocal(ModuleDescriptor module, Annotated declaration, BindingTrace trace, PsiElement declarationElement) {
        KotlinType kotlinType = KSerializationUtilKt.serializableWith(declaration.getAnnotations(), module);
        if (kotlinType == null) {
            return;
        }
        KotlinType serializerType = kotlinType;
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(serializerType);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor serializerDescriptor = classDescriptor;
        if (DescriptorUtils.isLocal((DeclarationDescriptor)((DeclarationDescriptor)serializerDescriptor))) {
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration(declaration);
            PsiElement element = ktAnnotationEntry != null ? (PsiElement)ktAnnotationEntry : declarationElement;
            trace.report((Diagnostic)SerializationErrors.LOCAL_SERIALIZER_USAGE.on(element, (Object)serializerType));
        }
    }

    private final boolean checkCustomSerializerParameters(ModuleDescriptor module, Annotated declaration, KotlinType serializableType, KtElement element, PsiElement fallbackElement, BindingTrace trace) {
        boolean isExternalSerializer;
        boolean hasParameters;
        Object v3;
        ClassDescriptor serializerDescriptor;
        KotlinType serializerType;
        block9: {
            KotlinType kotlinType = KSerializationUtilKt.serializableWith(declaration.getAnnotations(), module);
            if (kotlinType == null) {
                return false;
            }
            serializerType = kotlinType;
            ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(serializerType);
            if (classDescriptor == null) {
                return false;
            }
            serializerDescriptor = classDescriptor;
            if (CollectionsKt.contains((Iterable)SerializersClassIds.INSTANCE.getSetOfSpecialSerializers(), (Object)DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)serializerDescriptor)))) {
                return false;
            }
            Collection collection = serializerDescriptor.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getConstructors(...)");
            Iterable $this$singleOrNull$iv = collection;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)element$iv;
                boolean bl = false;
                if (!constructor.isPrimary()) continue;
                if (found$iv) {
                    v3 = null;
                    break block9;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        ClassConstructorDescriptor classConstructorDescriptor = v3;
        if (classConstructorDescriptor == null) {
            return false;
        }
        ClassConstructorDescriptor primaryConstructor = classConstructorDescriptor;
        KtElement ktElement = element;
        PsiElement targetElement = ktElement != null ? (PsiElement)ktElement : fallbackElement;
        List list = primaryConstructor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        boolean bl = hasParameters = !((Collection)list).isEmpty();
        if (!hasParameters) {
            return false;
        }
        boolean bl2 = isExternalSerializer = KSerializationUtilKt.getSerializerForClass((DeclarationDescriptor)serializerDescriptor) != null;
        if (!isExternalSerializer && primaryConstructor.getValueParameters().size() != serializableType.getArguments().size()) {
            String message = !((Collection)serializableType.getArguments()).isEmpty() ? "expected no parameters or " + serializableType.getArguments().size() + ", but has " + primaryConstructor.getValueParameters().size() + " parameters" : "expected no parameters but has " + primaryConstructor.getValueParameters().size() + " parameters";
            trace.report((Diagnostic)SerializationErrors.CUSTOM_SERIALIZER_PARAM_ILLEGAL_COUNT.on(targetElement, (Object)serializerType, (Object)serializableType, (Object)message));
        }
        List list2 = primaryConstructor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor param = (ValueParameterDescriptor)element$iv;
            boolean bl3 = false;
            if (KSerializationUtilKt.isKSerializer(param.getType())) continue;
            trace.report((Diagnostic)SerializationErrors.CUSTOM_SERIALIZER_PARAM_ILLEGAL_TYPE.on(targetElement, (Object)serializerType, (Object)serializableType, (Object)param.getName().asString()));
        }
        return true;
    }

    private final void checkSerializerNullability(KotlinType classType, KotlinType serializerType, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Object v0;
        block3: {
            Iterable iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            for (Object t : iterable) {
                KotlinType it = (KotlinType)t;
                boolean bl = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        KotlinType kotlinType = v0;
        if (kotlinType == null) {
            return;
        }
        KotlinType castedToKSerial = kotlinType;
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.first((List)castedToKSerial.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        KotlinType serializerForType = kotlinType2;
        if (!classType.isMarkedNullable() && serializerForType.isMarkedNullable()) {
            KtTypeElement ktTypeElement = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NULLABILITY_INCOMPATIBLE.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)serializerType, (Object)classType));
        }
    }

    private static final KtElement checkKeepGeneratedSerializer$lambda$1(Lazy<? extends KtElement> $entry$delegate) {
        Lazy<? extends KtElement> lazy = $entry$delegate;
        return (KtElement)lazy.getValue();
    }

    private static final KtElement checkKeepGeneratedSerializer$lambda$0(ClassDescriptor $descriptor, KtDeclaration $declaration) {
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findAnnotationDeclaration((Annotated)$descriptor, SerializationAnnotations.INSTANCE.getKeepGeneratedSerializerAnnotationFqName());
        return ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)$declaration;
    }

    /*
     * WARNING - void declaration
     */
    private static final List checkInheritedAnnotations$lambda$0(Annotations an) {
        void $this$filterTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)an, (String)"an");
        Iterable $this$map$iv = (Iterable)an;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)it);
            Intrinsics.checkNotNull((Object)classDescriptor);
            collection.add(TuplesKt.to((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor)), (Object)it));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)((AnnotationDescriptor)it.getSecond()));
            boolean bl2 = classDescriptor != null ? KSerializationUtilKt.isInheritableSerialInfoAnnotation(classDescriptor) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final int checkProtobufProperties$lambda$2$0(Integer $protoNumber, Integer number) {
        Integer n = number;
        return n != null ? n.intValue() : $protoNumber.intValue();
    }

    private static final boolean checkProtobufProperties$lambda$2$1(int $originNumber, int number) {
        return number != $originNumber;
    }

    private static final String checkProtobufProperties$lambda$2$2(List $properties, int number) {
        return ((SerializableProperty)$properties.get(number - 1)).getDescriptor().getName().asString();
    }
}

