/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.encoding;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.collections.AbstractList;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.encoding.Base64Kt;
import kotlin.io.encoding.ExperimentalEncodingApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\t\b\u0017\u0018\u0000 >2\u00020\u0001:\u0002=>B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J=\u0010\u001b\u001a\u0002H\u001c\"\f\b\u0000\u0010\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u0002H\u001c2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001fJ\"\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\"\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J%\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b$J5\u0010%\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\u0003H\u0002J0\u0010+\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J%\u0010,\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b-J%\u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b1J(\u00102\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00103\u001a\u00020\u0014H\u0002J \u00107\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J%\u00108\u001a\u0002062\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b9J \u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006?"}, d2={"Lkotlin/io/encoding/Base64;", "", "isUrlSafe", "", "isMimeScheme", "paddingOption", "Lkotlin/io/encoding/Base64$PaddingOption;", "<init>", "(ZZLkotlin/io/encoding/Base64$PaddingOption;)V", "isUrlSafe$kotlin_stdlib", "()Z", "isMimeScheme$kotlin_stdlib", "getPaddingOption$kotlin_stdlib", "()Lkotlin/io/encoding/Base64$PaddingOption;", "withPadding", "option", "encodeToByteArray", "", "source", "startIndex", "", "endIndex", "encodeIntoByteArray", "destination", "destinationOffset", "encode", "", "encodeToAppendable", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "([BLjava/lang/Appendable;II)Ljava/lang/Appendable;", "decode", "decodeIntoByteArray", "", "encodeToByteArrayImpl", "encodeToByteArrayImpl$kotlin_stdlib", "encodeIntoByteArrayImpl", "encodeIntoByteArrayImpl$kotlin_stdlib", "encodeSize", "sourceSize", "encodeSize$kotlin_stdlib", "shouldPadOnEncode", "decodeImpl", "decodeSize", "decodeSize$kotlin_stdlib", "charsToBytesImpl", "charsToBytesImpl$kotlin_stdlib", "bytesToStringImpl", "bytesToStringImpl$kotlin_stdlib", "handlePaddingSymbol", "padIndex", "byteStart", "checkPaddingIsAllowed", "", "skipIllegalSymbolsIfMime", "checkSourceBounds", "checkSourceBounds$kotlin_stdlib", "checkDestinationBounds", "destinationSize", "capacityNeeded", "PaddingOption", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.8")
@ExperimentalEncodingApi
public class Base64 {
    @NotNull
    public static final Default Default = new Default(null);
    private final boolean isUrlSafe;
    private final boolean isMimeScheme;
    @NotNull
    private final PaddingOption paddingOption;
    private static final int bitsPerByte = 8;
    private static final int bitsPerSymbol = 6;
    public static final int bytesPerGroup = 3;
    public static final int symbolsPerGroup = 4;
    public static final byte padSymbol = 61;
    public static final int mimeLineLength = 76;
    private static final int mimeGroupsPerLine = 19;
    @NotNull
    private static final byte[] mimeLineSeparatorSymbols;
    @NotNull
    private static final Base64 UrlSafe;
    @NotNull
    private static final Base64 Mime;

    private Base64(boolean isUrlSafe, boolean isMimeScheme, PaddingOption paddingOption) {
        this.isUrlSafe = isUrlSafe;
        this.isMimeScheme = isMimeScheme;
        this.paddingOption = paddingOption;
        if (!(!this.isUrlSafe || !this.isMimeScheme)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean isUrlSafe$kotlin_stdlib() {
        return this.isUrlSafe;
    }

    public final boolean isMimeScheme$kotlin_stdlib() {
        return this.isMimeScheme;
    }

    @NotNull
    public final PaddingOption getPaddingOption$kotlin_stdlib() {
        return this.paddingOption;
    }

    @SinceKotlin(version="2.0")
    @NotNull
    public final Base64 withPadding(@NotNull PaddingOption option) {
        Intrinsics.checkNotNullParameter((Object)option, "option");
        return this.paddingOption == option ? this : new Base64(this.isUrlSafe, this.isMimeScheme, option);
    }

    @NotNull
    public final byte[] encodeToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        return this.encodeToByteArrayImpl$kotlin_stdlib(source, startIndex, endIndex);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(Base64 base64, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToByteArray");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return base64.encodeToByteArray(byArray, n, n2);
    }

    public final int encodeIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.encodeIntoByteArrayImpl$kotlin_stdlib(source, destination, destinationOffset, startIndex, endIndex);
    }

    public static /* synthetic */ int encodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = byArray.length;
        }
        return base64.encodeIntoByteArray(byArray, byArray2, n, n2, n3);
    }

    @NotNull
    public final String encode(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        byte[] byArray = this.encodeToByteArrayImpl$kotlin_stdlib(source, startIndex, endIndex);
        return new String(byArray, Charsets.ISO_8859_1);
    }

    public static /* synthetic */ String encode$default(Base64 base64, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return base64.encode(byArray, n, n2);
    }

    @NotNull
    public final <A extends Appendable> A encodeToAppendable(@NotNull byte[] source, @NotNull A destination, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        byte[] byArray = this.encodeToByteArrayImpl$kotlin_stdlib(source, startIndex, endIndex);
        String stringResult = new String(byArray, Charsets.ISO_8859_1);
        destination.append(stringResult);
        return destination;
    }

    public static /* synthetic */ Appendable encodeToAppendable$default(Base64 base64, byte[] byArray, Appendable appendable, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToAppendable");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        return base64.encodeToAppendable(byArray, appendable, n, n2);
    }

    @NotNull
    public final byte[] decode(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        int decodeSize = this.decodeSize$kotlin_stdlib(source, startIndex, endIndex);
        byte[] destination = new byte[decodeSize];
        int bytesWritten = this.decodeImpl(source, destination, 0, startIndex, endIndex);
        if (!(bytesWritten == destination.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return destination;
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return base64.decode(byArray, n, n2);
    }

    public final int decodeIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        this.checkDestinationBounds(destination.length, destinationOffset, this.decodeSize$kotlin_stdlib(source, startIndex, endIndex));
        return this.decodeImpl(source, destination, destinationOffset, startIndex, endIndex);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = byArray.length;
        }
        return base64.decodeIntoByteArray(byArray, byArray2, n, n2, n3);
    }

    @NotNull
    public final byte[] decode(@NotNull CharSequence source, int startIndex, int endIndex) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source, "source");
        Base64 base64 = this;
        if (source instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(((String)source).length(), startIndex, endIndex);
            String string = ((String)source).substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String string2 = string;
            Charset charset = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        } else {
            byArray = base64.charsToBytesImpl$kotlin_stdlib(source, startIndex, endIndex);
        }
        byte[] byteSource = byArray;
        return Base64.decode$default(this, byteSource, 0, 0, 6, null);
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return base64.decode(charSequence, n, n2);
    }

    public final int decodeIntoByteArray(@NotNull CharSequence source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Base64 base64 = this;
        if (source instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(((String)source).length(), startIndex, endIndex);
            String string = ((String)source).substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String string2 = string;
            Charset charset = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        } else {
            byArray = base64.charsToBytesImpl$kotlin_stdlib(source, startIndex, endIndex);
        }
        byte[] byteSource = byArray;
        return Base64.decodeIntoByteArray$default(this, byteSource, destination, destinationOffset, 0, 0, 24, null);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, CharSequence charSequence, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = charSequence.length();
        }
        return base64.decodeIntoByteArray(charSequence, byArray, n, n2, n3);
    }

    @NotNull
    public final byte[] encodeToByteArrayImpl$kotlin_stdlib(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        int encodeSize = this.encodeSize$kotlin_stdlib(endIndex - startIndex);
        byte[] destination = new byte[encodeSize];
        this.encodeIntoByteArrayImpl$kotlin_stdlib(source, destination, 0, startIndex, endIndex);
        return destination;
    }

    public final int encodeIntoByteArrayImpl$kotlin_stdlib(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        int groupsPerLine;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        this.checkDestinationBounds(destination.length, destinationOffset, this.encodeSize$kotlin_stdlib(endIndex - startIndex));
        byte[] encodeMap = this.isUrlSafe ? Base64Kt.access$getBase64UrlEncodeMap$p() : Base64Kt.access$getBase64EncodeMap$p();
        int sourceIndex = startIndex;
        int destinationIndex = destinationOffset;
        int n = groupsPerLine = this.isMimeScheme ? 19 : Integer.MAX_VALUE;
        while (sourceIndex + 2 < endIndex) {
            int groups2 = Math.min((endIndex - sourceIndex) / 3, groupsPerLine);
            for (int i = 0; i < groups2; ++i) {
                int byte1 = source[sourceIndex++] & 0xFF;
                int byte2 = source[sourceIndex++] & 0xFF;
                int byte3 = source[sourceIndex++] & 0xFF;
                int bits = byte1 << 16 | byte2 << 8 | byte3;
                destination[destinationIndex++] = encodeMap[bits >>> 18];
                destination[destinationIndex++] = encodeMap[bits >>> 12 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits >>> 6 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
            }
            if (groups2 != groupsPerLine || sourceIndex == endIndex) continue;
            destination[destinationIndex++] = mimeLineSeparatorSymbols[0];
            destination[destinationIndex++] = mimeLineSeparatorSymbols[1];
        }
        switch (endIndex - sourceIndex) {
            case 1: {
                int byte1 = source[sourceIndex++] & 0xFF;
                int bits = byte1 << 4;
                destination[destinationIndex++] = encodeMap[bits >>> 6];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
                if (!this.shouldPadOnEncode()) break;
                destination[destinationIndex++] = 61;
                destination[destinationIndex++] = 61;
                break;
            }
            case 2: {
                int byte1 = source[sourceIndex++] & 0xFF;
                int byte2 = source[sourceIndex++] & 0xFF;
                int bits = byte1 << 10 | byte2 << 2;
                destination[destinationIndex++] = encodeMap[bits >>> 12];
                destination[destinationIndex++] = encodeMap[bits >>> 6 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
                if (!this.shouldPadOnEncode()) break;
                destination[destinationIndex++] = 61;
            }
        }
        if (!(sourceIndex == endIndex)) {
            throw new IllegalStateException("Check failed.");
        }
        return destinationIndex - destinationOffset;
    }

    public final int encodeSize$kotlin_stdlib(int sourceSize) {
        int groups2 = sourceSize / 3;
        int trailingBytes = sourceSize % 3;
        int size = groups2 * 4;
        if (trailingBytes != 0) {
            size += this.shouldPadOnEncode() ? 4 : trailingBytes + 1;
        }
        if (this.isMimeScheme) {
            size += (size - 1) / 76 * 2;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Input is too big");
        }
        return size;
    }

    private final boolean shouldPadOnEncode() {
        return this.paddingOption == PaddingOption.PRESENT || this.paddingOption == PaddingOption.PRESENT_OPTIONAL;
    }

    private final int decodeImpl(byte[] source, byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        int symbol;
        int[] decodeMap = this.isUrlSafe ? Base64Kt.access$getBase64UrlDecodeMap$p() : Base64Kt.access$getBase64DecodeMap$p();
        int payload = 0;
        int byteStart = -8;
        int sourceIndex = startIndex;
        int destinationIndex = destinationOffset;
        boolean hasPadding = false;
        while (sourceIndex < endIndex) {
            int symbolBits;
            if (byteStart == -8 && sourceIndex + 3 < endIndex) {
                int symbol4;
                int symbol3;
                int bits;
                int symbol1 = decodeMap[source[sourceIndex++] & 0xFF];
                int symbol2 = decodeMap[source[sourceIndex++] & 0xFF];
                if ((bits = symbol1 << 18 | symbol2 << 12 | (symbol3 = decodeMap[source[sourceIndex++] & 0xFF]) << 6 | (symbol4 = decodeMap[source[sourceIndex++] & 0xFF])) >= 0) {
                    destination[destinationIndex++] = (byte)(bits >> 16);
                    destination[destinationIndex++] = (byte)(bits >> 8);
                    destination[destinationIndex++] = (byte)bits;
                    continue;
                }
                sourceIndex -= 4;
            }
            if ((symbolBits = decodeMap[symbol = source[sourceIndex] & 0xFF]) < 0) {
                if (symbolBits == -2) {
                    hasPadding = true;
                    sourceIndex = this.handlePaddingSymbol(source, sourceIndex, endIndex, byteStart);
                    break;
                }
                if (this.isMimeScheme) {
                    ++sourceIndex;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Invalid symbol '").append((char)symbol).append("'(");
                String string = Integer.toString(symbol, CharsKt.checkRadix(8));
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(sourceIndex).toString());
            }
            ++sourceIndex;
            payload = payload << 6 | symbolBits;
            if ((byteStart += 6) < 0) continue;
            destination[destinationIndex++] = (byte)(payload >>> byteStart);
            payload &= (1 << byteStart) - 1;
            byteStart -= 8;
        }
        if (byteStart == -2) {
            throw new IllegalArgumentException("The last unit of input does not have enough bits");
        }
        if (byteStart != -8 && !hasPadding && this.paddingOption == PaddingOption.PRESENT) {
            throw new IllegalArgumentException("The padding option is set to PRESENT, but the input is not properly padded");
        }
        if (payload != 0) {
            throw new IllegalArgumentException("The pad bits must be zeros");
        }
        if ((sourceIndex = this.skipIllegalSymbolsIfMime(source, sourceIndex, endIndex)) < endIndex) {
            symbol = source[sourceIndex] & 0xFF;
            StringBuilder stringBuilder = new StringBuilder().append("Symbol '").append((char)symbol).append("'(");
            String string = Integer.toString(symbol, CharsKt.checkRadix(8));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(sourceIndex - 1).append(" is prohibited after the pad character").toString());
        }
        return destinationIndex - destinationOffset;
    }

    public final int decodeSize$kotlin_stdlib(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        int symbols = endIndex - startIndex;
        if (symbols == 0) {
            return 0;
        }
        if (symbols == 1) {
            throw new IllegalArgumentException("Input should have at least 2 symbols for Base64 decoding, startIndex: " + startIndex + ", endIndex: " + endIndex);
        }
        if (this.isMimeScheme) {
            for (int index = startIndex; index < endIndex; ++index) {
                int symbol = source[index] & 0xFF;
                int symbolBits = Base64Kt.access$getBase64DecodeMap$p()[symbol];
                if (symbolBits >= 0) continue;
                if (symbolBits == -2) {
                    symbols -= endIndex - index;
                    break;
                }
                --symbols;
            }
        } else if (source[endIndex - 1] == 61) {
            --symbols;
            if (source[endIndex - 2] == 61) {
                --symbols;
            }
        }
        return (int)((long)symbols * (long)6 / (long)8);
    }

    @NotNull
    public final byte[] charsToBytesImpl$kotlin_stdlib(@NotNull CharSequence source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkSourceBounds$kotlin_stdlib(source.length(), startIndex, endIndex);
        byte[] byteArray = new byte[endIndex - startIndex];
        int length = 0;
        for (int index = startIndex; index < endIndex; ++index) {
            char symbol = source.charAt(index);
            byteArray[length++] = symbol <= '\u00ff' ? (int)symbol : 63;
        }
        return byteArray;
    }

    @NotNull
    public final String bytesToStringImpl$kotlin_stdlib(@NotNull byte[] source) {
        Intrinsics.checkNotNullParameter(source, "source");
        StringBuilder stringBuilder = new StringBuilder(source.length);
        for (byte by : source) {
            stringBuilder.append((char)by);
        }
        return stringBuilder.toString();
    }

    private final int handlePaddingSymbol(byte[] source, int padIndex, int endIndex, int byteStart) {
        int n;
        switch (byteStart) {
            case -8: {
                throw new IllegalArgumentException("Redundant pad character at index " + padIndex);
            }
            case -2: {
                n = padIndex + 1;
                break;
            }
            case -4: {
                this.checkPaddingIsAllowed(padIndex);
                int secondPadIndex = this.skipIllegalSymbolsIfMime(source, padIndex + 1, endIndex);
                if (secondPadIndex == endIndex || source[secondPadIndex] != 61) {
                    throw new IllegalArgumentException("Missing one pad character at index " + secondPadIndex);
                }
                n = secondPadIndex + 1;
                break;
            }
            case -6: {
                this.checkPaddingIsAllowed(padIndex);
                n = padIndex + 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable".toString());
            }
        }
        return n;
    }

    private final void checkPaddingIsAllowed(int padIndex) {
        if (this.paddingOption == PaddingOption.ABSENT) {
            throw new IllegalArgumentException("The padding option is set to ABSENT, but the input has a pad character at index " + padIndex);
        }
    }

    private final int skipIllegalSymbolsIfMime(byte[] source, int startIndex, int endIndex) {
        int sourceIndex;
        if (!this.isMimeScheme) {
            return startIndex;
        }
        for (sourceIndex = startIndex; sourceIndex < endIndex; ++sourceIndex) {
            int symbol = source[sourceIndex] & 0xFF;
            if (Base64Kt.access$getBase64DecodeMap$p()[symbol] == -1) continue;
            return sourceIndex;
        }
        return sourceIndex;
    }

    public final void checkSourceBounds$kotlin_stdlib(int sourceSize, int startIndex, int endIndex) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, sourceSize);
    }

    private final void checkDestinationBounds(int destinationSize, int destinationOffset, int capacityNeeded) {
        if (destinationOffset < 0 || destinationOffset > destinationSize) {
            throw new IndexOutOfBoundsException("destination offset: " + destinationOffset + ", destination size: " + destinationSize);
        }
        int destinationEndIndex = destinationOffset + capacityNeeded;
        if (destinationEndIndex < 0 || destinationEndIndex > destinationSize) {
            throw new IndexOutOfBoundsException("The destination array does not have enough capacity, destination offset: " + destinationOffset + ", destination size: " + destinationSize + ", capacity needed: " + capacityNeeded);
        }
    }

    public /* synthetic */ Base64(boolean isUrlSafe, boolean isMimeScheme, PaddingOption paddingOption, DefaultConstructorMarker $constructor_marker) {
        this(isUrlSafe, isMimeScheme, paddingOption);
    }

    static {
        byte[] byArray = new byte[]{13, 10};
        mimeLineSeparatorSymbols = byArray;
        UrlSafe = new Base64(true, false, PaddingOption.PRESENT);
        Mime = new Base64(false, true, PaddingOption.PRESENT);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lkotlin/io/encoding/Base64$Default;", "Lkotlin/io/encoding/Base64;", "<init>", "()V", "bitsPerByte", "", "bitsPerSymbol", "bytesPerGroup", "symbolsPerGroup", "padSymbol", "", "mimeLineLength", "mimeGroupsPerLine", "mimeLineSeparatorSymbols", "", "getMimeLineSeparatorSymbols$kotlin_stdlib", "()[B", "UrlSafe", "getUrlSafe", "()Lkotlin/io/encoding/Base64;", "Mime", "getMime", "kotlin-stdlib"})
    public static final class Default
    extends Base64 {
        private Default() {
            super(false, false, PaddingOption.PRESENT, null);
        }

        @NotNull
        public final byte[] getMimeLineSeparatorSymbols$kotlin_stdlib() {
            return mimeLineSeparatorSymbols;
        }

        @NotNull
        public final Base64 getUrlSafe() {
            return UrlSafe;
        }

        @NotNull
        public final Base64 getMime() {
            return Mime;
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkotlin/io/encoding/Base64$PaddingOption;", "", "<init>", "(Ljava/lang/String;I)V", "PRESENT", "ABSENT", "PRESENT_OPTIONAL", "ABSENT_OPTIONAL", "kotlin-stdlib"})
    @SinceKotlin(version="2.0")
    public static final class PaddingOption
    extends Enum<PaddingOption> {
        public static final /* enum */ PaddingOption PRESENT = new PaddingOption();
        public static final /* enum */ PaddingOption ABSENT = new PaddingOption();
        public static final /* enum */ PaddingOption PRESENT_OPTIONAL = new PaddingOption();
        public static final /* enum */ PaddingOption ABSENT_OPTIONAL = new PaddingOption();
        private static final /* synthetic */ PaddingOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PaddingOption[] values() {
            return (PaddingOption[])$VALUES.clone();
        }

        public static PaddingOption valueOf(String value) {
            return Enum.valueOf(PaddingOption.class, value);
        }

        @NotNull
        public static EnumEntries<PaddingOption> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paddingOptionArray = new PaddingOption[]{PaddingOption.PRESENT, PaddingOption.ABSENT, PaddingOption.PRESENT_OPTIONAL, PaddingOption.ABSENT_OPTIONAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

