/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tooling.core;

import java.io.Serializable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersionKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u001bB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion;", "", "Ljava/io/Serializable;", "major", "", "minor", "patch", "classifier", "", "(IIILjava/lang/String;)V", "getClassifier", "()Ljava/lang/String;", "getMajor", "()I", "maturity", "Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion$Maturity;", "getMaturity", "()Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion$Maturity;", "getMinor", "getPatch", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Maturity", "kotlin-tooling-core"})
public final class KotlinToolingVersion
implements Comparable<KotlinToolingVersion>,
Serializable {
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String classifier;
    @NotNull
    private final Maturity maturity;

    /*
     * WARNING - void declaration
     */
    public KotlinToolingVersion(int major, int minor, int patch, @Nullable String classifier) {
        Maturity maturity;
        CharSequence charSequence;
        String string;
        void $this$maturity_u24lambda_u2d0;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.classifier = classifier;
        KotlinToolingVersion kotlinToolingVersion = this;
        KotlinToolingVersion kotlinToolingVersion2 = this;
        boolean bl = false;
        String string2 = $this$maturity_u24lambda_u2d0.classifier;
        if (string2 != null) {
            String string3 = string2;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String classifier2 = string;
        if (classifier2 == null || new Regex("(release-)?\\d+").matches(charSequence = (CharSequence)classifier2)) {
            maturity = Maturity.STABLE;
        } else {
            charSequence = classifier2;
            if (new Regex("(rc)(\\d*)?(-release)?-?\\d*").matches(charSequence)) {
                maturity = Maturity.RC;
            } else {
                charSequence = classifier2;
                if (new Regex("beta(\\d*)?(-release)?-?\\d*").matches(charSequence)) {
                    maturity = Maturity.BETA;
                } else {
                    charSequence = classifier2;
                    if (new Regex("alpha(\\d*)?(-release)?-?\\d*").matches(charSequence)) {
                        maturity = Maturity.ALPHA;
                    } else {
                        charSequence = classifier2;
                        if (new Regex("m\\d+(-release)?(-\\d*)?").matches(charSequence)) {
                            maturity = Maturity.MILESTONE;
                        } else {
                            charSequence = classifier2;
                            if (new Regex("dev-?\\d*").matches(charSequence)) {
                                maturity = Maturity.DEV;
                            } else if (Intrinsics.areEqual((Object)classifier2, (Object)"snapshot")) {
                                maturity = Maturity.SNAPSHOT;
                            } else {
                                throw new IllegalArgumentException("Can't infer maturity of KotlinVersion " + $this$maturity_u24lambda_u2d0);
                            }
                        }
                    }
                }
            }
        }
        kotlinToolingVersion2.maturity = maturity;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getClassifier() {
        return this.classifier;
    }

    @NotNull
    public final Maturity getMaturity() {
        return this.maturity;
    }

    @Override
    public int compareTo(@NotNull KotlinToolingVersion other) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)other)) {
            return 0;
        }
        Integer n2 = this.major - other.major;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            return it;
        }
        n2 = this.minor - other.minor;
        it = ((Number)n2).intValue();
        boolean bl3 = false;
        Integer n4 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl4 = false;
            return it;
        }
        n2 = this.patch - other.patch;
        it = ((Number)n2).intValue();
        boolean bl5 = false;
        Integer n5 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl6 = false;
            return it;
        }
        n2 = this.maturity.ordinal() - other.maturity.ordinal();
        it = ((Number)n2).intValue();
        boolean bl7 = false;
        Integer n6 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl8 = false;
            return it;
        }
        if (this.classifier == null && other.classifier != null) {
            return 1;
        }
        if (this.classifier != null && other.classifier == null) {
            return -1;
        }
        Integer thisClassifierNumber = KotlinToolingVersionKt.getClassifierNumber(this);
        Integer otherClassifierNumber = KotlinToolingVersionKt.getClassifierNumber(other);
        if (thisClassifierNumber != null && otherClassifierNumber != null) {
            Integer bl8 = thisClassifierNumber - otherClassifierNumber;
            int it2 = ((Number)bl8).intValue();
            boolean bl9 = false;
            Integer n7 = it = it2 != 0 ? bl8 : null;
            if (it != null) {
                it2 = ((Number)it).intValue();
                boolean bl10 = false;
                return it2;
            }
        }
        if (thisClassifierNumber != null && otherClassifierNumber == null) {
            return 1;
        }
        if (thisClassifierNumber == null && otherClassifierNumber != null) {
            return -1;
        }
        Integer thisBuildNumber = KotlinToolingVersionKt.getBuildNumber(this);
        Integer otherBuildNumber = KotlinToolingVersionKt.getBuildNumber(other);
        if (thisBuildNumber != null && otherBuildNumber != null) {
            Integer n8;
            Integer n9 = thisBuildNumber - otherBuildNumber;
            int it3 = ((Number)n9).intValue();
            boolean bl11 = false;
            Integer n10 = n8 = it3 != 0 ? n9 : null;
            if (n8 != null) {
                it3 = ((Number)n8).intValue();
                boolean bl12 = false;
                return it3;
            }
        }
        if (thisBuildNumber == null && otherBuildNumber != null) {
            return 1;
        }
        if (thisBuildNumber != null && otherBuildNumber == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        String string;
        String string2;
        String string3;
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinToolingVersion)) {
            return false;
        }
        if (this.major != ((KotlinToolingVersion)other).major) {
            return false;
        }
        if (this.minor != ((KotlinToolingVersion)other).minor) {
            return false;
        }
        if (this.patch != ((KotlinToolingVersion)other).patch) {
            return false;
        }
        String string4 = this.classifier;
        if (string4 != null) {
            string3 = string4;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string5 = string3.toLowerCase(locale);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string2 = null;
        }
        String string6 = ((KotlinToolingVersion)other).classifier;
        if (string6 != null) {
            string3 = string6;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string7 = string3.toLowerCase(locale);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        return Intrinsics.areEqual((Object)string2, string);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        String string = this.classifier;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch + (this.classifier != null ? '-' + this.classifier : "");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion$Maturity;", "", "(Ljava/lang/String;I)V", "SNAPSHOT", "DEV", "MILESTONE", "ALPHA", "BETA", "RC", "STABLE", "kotlin-tooling-core"})
    public static final class Maturity
    extends Enum<Maturity> {
        public static final /* enum */ Maturity SNAPSHOT = new Maturity();
        public static final /* enum */ Maturity DEV = new Maturity();
        public static final /* enum */ Maturity MILESTONE = new Maturity();
        public static final /* enum */ Maturity ALPHA = new Maturity();
        public static final /* enum */ Maturity BETA = new Maturity();
        public static final /* enum */ Maturity RC = new Maturity();
        public static final /* enum */ Maturity STABLE = new Maturity();
        private static final /* synthetic */ Maturity[] $VALUES;

        public static Maturity[] values() {
            return (Maturity[])$VALUES.clone();
        }

        public static Maturity valueOf(String value) {
            return Enum.valueOf(Maturity.class, value);
        }

        static {
            $VALUES = maturityArray = new Maturity[]{Maturity.SNAPSHOT, Maturity.DEV, Maturity.MILESTONE, Maturity.ALPHA, Maturity.BETA, Maturity.RC, Maturity.STABLE};
        }
    }
}

