/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlinx.benchmark.BenchmarkReportFormatter;
import kotlinx.benchmark.CommonBenchmarkAnnotationsKt;
import kotlinx.benchmark.ReportBenchmarkResult;
import kotlinx.benchmark.ReportBenchmarksStatisticsKt;
import kotlinx.benchmark.UtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lkotlinx/benchmark/JsonBenchmarkReportFormatter;", "Lkotlinx/benchmark/BenchmarkReportFormatter;", "<init>", "()V", "format", "", "results", "", "Lkotlinx/benchmark/ReportBenchmarkResult;", "result", "escape", "kotlinx-benchmark-runtime"})
@SourceDebugExtension(value={"SMAP\nBenchmarkReportFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkReportFormatter.kt\nkotlinx/benchmark/JsonBenchmarkReportFormatter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,226:1\n1179#2,2:227\n*S KotlinDebug\n*F\n+ 1 BenchmarkReportFormatter.kt\nkotlinx/benchmark/JsonBenchmarkReportFormatter\n*L\n209#1:227,2\n*E\n"})
final class JsonBenchmarkReportFormatter
extends BenchmarkReportFormatter {
    @NotNull
    public static final JsonBenchmarkReportFormatter INSTANCE = new JsonBenchmarkReportFormatter();

    private JsonBenchmarkReportFormatter() {
        super(null);
    }

    @Override
    @NotNull
    public String format(@NotNull Collection<ReportBenchmarkResult> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        return CollectionsKt.joinToString$default((Iterable)results, (CharSequence)",", (CharSequence)"[", (CharSequence)"\n]", (int)0, null, (Function1)((Function1)new Function1<ReportBenchmarkResult, String>((Object)this){

            public final String invoke(ReportBenchmarkResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JsonBenchmarkReportFormatter.access$format((JsonBenchmarkReportFormatter)this.receiver, p0);
            }
        }), (int)24, null);
    }

    private final String format(ReportBenchmarkResult result) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n  {\n    \"benchmark\" : \"").append(this.escape(result.getBenchmark().getName())).append("\",\n    \"mode\" : \"").append(CommonBenchmarkAnnotationsKt.toText(result.getConfig().getMode())).append("\",\n    \"warmupIterations\" : ").append(result.getConfig().getWarmups()).append(",\n    \"warmupTime\" : \"").append(result.getConfig().getIterationTime()).append(' ').append(CommonBenchmarkAnnotationsKt.toText(result.getConfig().getIterationTimeUnit())).append("\",\n    \"measurementIterations\" : ").append(result.getConfig().getIterations()).append(",\n    \"measurementTime\" : \"").append(result.getConfig().getIterationTime()).append(' ').append(CommonBenchmarkAnnotationsKt.toText(result.getConfig().getIterationTimeUnit())).append("\",\n    \"params\" : {\n          ").append(CollectionsKt.joinToString$default((Iterable)result.getParams().entrySet(), (CharSequence)",\n          ", null, null, (int)0, null, JsonBenchmarkReportFormatter::format$lambda$0, (int)30, null)).append("\n    },\n    \"advanced\" : {\n          ").append(CollectionsKt.joinToString$default((Iterable)result.getConfig().getAdvanced().entrySet(), (CharSequence)",\n          ", null, null, (int)0, null, JsonBenchmarkReportFormatter::format$lambda$1, (int)30, null)).append("\n    },\n    \"primaryMetric\" : {\n       \"score\": ").append(result.getScore()).append(",\n       \"scoreError\": ");
        stringBuilder.append(result.getError()).append(",\n       \"scoreConfidence\" : [\n          ").append(((Number)result.getConfidence().getFirst()).doubleValue()).append(",\n          ").append(((Number)result.getConfidence().getSecond()).doubleValue()).append("\n       ],\n       \"scorePercentiles\" : {\n          ").append(CollectionsKt.joinToString$default((Iterable)result.getPercentiles().entrySet(), (CharSequence)",\n          ", null, null, (int)0, null, JsonBenchmarkReportFormatter::format$lambda$2, (int)30, null)).append("\n       },\n       \"scoreUnit\" : \"").append(ReportBenchmarksStatisticsKt.unitText(result.getConfig().getMode(), result.getConfig().getOutputTimeUnit())).append("\",\n       \"rawData\" : [\n           ").append(ArraysKt.joinToString$default((double[])result.getValues(), (CharSequence)",\n             ", (CharSequence)"[\n             ", (CharSequence)"\n           ]", (int)0, null, null, (int)56, null)).append("\n       ]\n    },\n    \"secondaryMetrics\" : {\n    }\n  }");
        return stringBuilder.toString();
    }

    private final String escape(String $this$escape) {
        StringBuilder stringBuilder;
        StringBuilder $this$escape_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharSequence $this$forEach$iv = $this$escape;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    StringBuilder stringBuilder2 = $this$escape_u24lambda_u244.append("\\").append(c);
                    break;
                }
                case '\t': {
                    StringBuilder stringBuilder2 = $this$escape_u24lambda_u244.append("\\t");
                    break;
                }
                case '\b': {
                    StringBuilder stringBuilder2 = $this$escape_u24lambda_u244.append("\\b");
                    break;
                }
                case '\n': {
                    StringBuilder stringBuilder2 = $this$escape_u24lambda_u244.append("\\n");
                    break;
                }
                case '\r': {
                    StringBuilder stringBuilder2 = $this$escape_u24lambda_u244.append("\\r");
                    break;
                }
                case '\f': {
                    StringBuilder stringBuilder2 = $this$escape_u24lambda_u244.append("\\f");
                    break;
                }
                default: {
                    StringBuilder stringBuilder2;
                    if (Intrinsics.compare((int)c, (int)31) <= 0) {
                        StringBuilder stringBuilder3 = new StringBuilder().append("\\u00");
                        String string = Integer.toString(c, CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        stringBuilder2 = $this$escape_u24lambda_u244.append(stringBuilder3.append(string).toString());
                        break;
                    }
                    stringBuilder2 = $this$escape_u24lambda_u244.append(c);
                }
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CharSequence format$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '\"' + INSTANCE.escape((String)it.getKey()) + "\" : \"" + INSTANCE.escape((String)it.getValue()) + '\"';
    }

    private static final CharSequence format$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '\"' + INSTANCE.escape((String)it.getKey()) + "\" : \"" + INSTANCE.escape((String)it.getValue()) + '\"';
    }

    private static final CharSequence format$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '\"' + UtilsKt.format$default(((Number)it.getKey()).doubleValue(), 2, false, 2, null) + "\" : " + ((Number)it.getValue()).doubleValue();
    }

    public static final /* synthetic */ String access$format(JsonBenchmarkReportFormatter $this, ReportBenchmarkResult result) {
        return $this.format(result);
    }
}

