/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.httpClient.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jfrog.artifactory.client.httpClient.http.CloseableHttpClientDecorator;
import org.jfrog.artifactory.client.httpClient.http.DefaultHostSpecificProxyRoutePlanner;
import org.jfrog.artifactory.client.httpClient.http.ProxyConfig;
import org.jfrog.artifactory.client.httpClient.http.TrustSelfSignedMultiChainStrategy;
import org.jfrog.artifactory.client.httpClient.http.auth.ProxyPreemptiveAuthInterceptor;

public abstract class HttpBuilderBase<T extends HttpBuilderBase<?>> {
    private static final String NO_PROXY_HOSTS_ENV = "NO_PROXY";
    private final BasicCredentialsProvider credsProvider;
    private final JFrogAuthScheme chosenAuthScheme = JFrogAuthScheme.BASIC;
    private final RequestConfig.Builder config = RequestConfig.custom();
    protected HttpClientBuilder builder = HttpClients.custom();
    protected HttpHost proxyHost;
    protected String noProxyHosts;
    private HttpHost defaultHost;
    private boolean trustSelfSignCert = false;
    private SSLContextBuilder sslContextBuilder;
    private SSLContext sslContext;
    private int maxConnectionsTotal = 50;
    private int maxConnectionsPerRoute = 50;
    private int connectionPoolTimeToLive = 30;
    private RequestConfig defaultRequestConfig;
    public static final int CONNECTION_POOL_TIME_TO_LIVE = 30;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;

    HttpBuilderBase() {
        this.credsProvider = new BasicCredentialsProvider();
        this.config.setMaxRedirects(20);
    }

    public CloseableHttpClient build() {
        String noProxyHostsList = StringUtils.isBlank((CharSequence)this.noProxyHosts) ? System.getenv(NO_PROXY_HOSTS_ENV) : this.noProxyHosts;
        this.builder.setRoutePlanner(this.buildRoutePlanner(noProxyHostsList));
        PoolingHttpClientConnectionManager connectionMgr = this.configConnectionManager();
        return new CloseableHttpClientDecorator(this.builder.build(), connectionMgr, this.chosenAuthScheme == JFrogAuthScheme.SPNEGO);
    }

    protected HttpRoutePlanner buildRoutePlanner(String noProxyHostsList) {
        return new DefaultHostSpecificProxyRoutePlanner.Builder().defaultHost(this.defaultHost).proxyProvider(() -> this.proxyHost).noProxyHosts(noProxyHostsList).build();
    }

    private T self() {
        return (T)this;
    }

    public T redirectStrategy(RedirectStrategy redirectStrategy) {
        this.builder.setRedirectStrategy(redirectStrategy);
        return this.self();
    }

    public T noProxyHosts(String noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
        return this.self();
    }

    public T userAgent(String userAgent) {
        this.builder.setUserAgent(userAgent);
        return this.self();
    }

    public T host(String host) {
        return this.host(host, 80);
    }

    public T host(String host, int port) {
        String scheme = port != 443 ? "http" : "https";
        return this.host(host, port, scheme);
    }

    public T host(String host, int port, String scheme) {
        this.defaultHost = StringUtils.isNotBlank((CharSequence)host) ? new HttpHost(host, port, scheme) : null;
        return this.self();
    }

    public T hostFromUrl(String urlStr) {
        if (StringUtils.isNotBlank((CharSequence)urlStr)) {
            try {
                URL url = new URL(urlStr);
                this.defaultHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot parse the url " + urlStr, e);
            }
        } else {
            this.defaultHost = null;
        }
        return this.self();
    }

    public T maxConnectionsPerRoute(int maxConnectionsPerHost) {
        this.maxConnectionsPerRoute = maxConnectionsPerHost;
        return this.self();
    }

    public T maxTotalConnections(int maxTotalConnections) {
        this.maxConnectionsTotal = maxTotalConnections;
        return this.self();
    }

    public T connectionTimeout(int connectionTimeout) {
        this.config.setConnectTimeout(connectionTimeout);
        return this.self();
    }

    public T socketTimeout(int soTimeout) {
        this.config.setSocketTimeout(soTimeout);
        return this.self();
    }

    public T addInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        this.builder.addInterceptorLast(httpRequestInterceptor);
        return this.self();
    }

    public T connectionPoolTTL(int seconds) {
        this.connectionPoolTimeToLive = seconds;
        return this.self();
    }

    public T trustSelfSignCert(boolean trustSelfSignCert) {
        this.trustSelfSignCert = trustSelfSignCert;
        return this.self();
    }

    public T sslContextBuilder(SSLContextBuilder sslContextBuilder) {
        this.sslContextBuilder = sslContextBuilder;
        return this.self();
    }

    public T sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this.self();
    }

    public T authentication(String username, String password) {
        return this.authentication(username, password, false);
    }

    public T authentication(String username, String password, boolean allowAnyHost) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            if (this.defaultHost == null || StringUtils.isBlank((CharSequence)this.defaultHost.getHostName())) {
                throw new IllegalStateException("Cannot configure authentication when host is not set.");
            }
            AuthScope authscope = allowAnyHost ? new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM) : new AuthScope(this.defaultHost.getHostName(), -1, AuthScope.ANY_REALM);
            this.credsProvider.setCredentials(authscope, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return this.self();
    }

    public T addInterceptorFirst(HttpRequestInterceptor interceptor) {
        this.builder.addInterceptorFirst(interceptor);
        return this.self();
    }

    public T addInterceptorLast(HttpResponseInterceptor interceptor) {
        this.builder.addInterceptorLast(interceptor);
        return this.self();
    }

    public T proxy(ProxyConfig proxy) {
        if (proxy == null) {
            return this.self();
        }
        this.proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
        ProxyConfigBuilder proxyBuilder = new ProxyConfigBuilder(proxy.getHost(), proxy.getPort());
        if (StringUtils.isNotBlank((CharSequence)proxy.getUsername())) {
            proxyBuilder.authentication(proxy.getUsername(), proxy.getPassword());
        }
        return this.self();
    }

    public HttpHost getProxyHost() {
        return this.proxyHost;
    }

    public boolean isCookieSupportEnabled() {
        return false;
    }

    public static ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return 30000L;
        };
    }

    protected PoolingHttpClientConnectionManager configConnectionManager() {
        this.builder.disableCookieManagement();
        if (this.hasCredentials()) {
            this.builder.setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
        }
        this.defaultRequestConfig = this.config.build();
        this.builder.setDefaultRequestConfig(this.defaultRequestConfig);
        this.builder.setKeepAliveStrategy(HttpBuilderBase.createConnectionKeepAliveStrategy());
        this.builder.setMaxConnTotal(this.maxConnectionsTotal);
        this.builder.setMaxConnPerRoute(this.maxConnectionsPerRoute);
        PoolingHttpClientConnectionManager connectionMgr = this.createConnectionMgr();
        this.builder.setConnectionManager((HttpClientConnectionManager)connectionMgr);
        return connectionMgr;
    }

    private PoolingHttpClientConnectionManager createConnectionMgr() {
        SSLContext sslContext = this.sslContext != null ? this.sslContext : this.buildSslContext();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        Registry r = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager connectionMgr = new PoolingHttpClientConnectionManager(r, null, null, null, (long)this.connectionPoolTimeToLive, TimeUnit.SECONDS);
        connectionMgr.setMaxTotal(this.maxConnectionsTotal);
        connectionMgr.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        HttpHost localhost = new HttpHost("localhost", 80);
        connectionMgr.setMaxPerRoute(new HttpRoute(localhost), this.maxConnectionsPerRoute);
        this.setSocketConfig(connectionMgr);
        return connectionMgr;
    }

    private void setSocketConfig(PoolingHttpClientConnectionManager connectionMgr) {
        int connectTimeout;
        if (this.defaultRequestConfig != null && (connectTimeout = this.defaultRequestConfig.getConnectTimeout()) > 0) {
            connectionMgr.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(connectTimeout).build());
        }
    }

    private SSLContext buildSslContext() {
        SSLContext sslContext = null;
        try {
            SSLContextBuilder sslBuilder = this.sslContextBuilder;
            if (this.trustSelfSignCert) {
                if (sslBuilder == null) {
                    sslBuilder = SSLContexts.custom();
                }
                sslBuilder.loadTrustMaterial((TrustStrategy)TrustSelfSignedMultiChainStrategy.INSTANCE);
            }
            if (sslBuilder != null) {
                sslContext = sslBuilder.build();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error building SSLContext: " + e.getMessage(), e);
        }
        return sslContext != null ? sslContext : SSLContexts.createDefault();
    }

    private boolean hasCredentials() {
        return this.credsProvider.getCredentials(AuthScope.ANY) != null;
    }

    public static class DefaultHostRoutePlanner
    extends DefaultRoutePlanner {
        private final HttpHost defaultHost;

        DefaultHostRoutePlanner(HttpHost defaultHost) {
            super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
            this.defaultHost = defaultHost;
        }

        public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
            if (host == null) {
                host = this.defaultHost;
            }
            return super.determineRoute(host, request, context);
        }
    }

    protected static enum JFrogAuthScheme {
        BASIC,
        SPNEGO;

    }

    private class ProxyConfigBuilder {
        private final String proxyHost;
        private final int proxyPort;
        Credentials creds;

        private ProxyConfigBuilder(String host, int port) {
            this.proxyHost = host;
            this.proxyPort = port;
        }

        private ProxyConfigBuilder authentication(String username, String password) {
            this.creds = new UsernamePasswordCredentials(username, password);
            List<String> authPrefs = Arrays.asList("Digest", "Basic", "NTLM");
            HttpBuilderBase.this.config.setProxyPreferredAuthSchemes(authPrefs);
            HttpBuilderBase.this.builder.addInterceptorFirst((HttpRequestInterceptor)new ProxyPreemptiveAuthInterceptor());
            this.setProxyCreds(this.proxyHost, this.proxyPort);
            return this;
        }

        private void setProxyCreds(String host, int port) {
            if (StringUtils.isBlank((CharSequence)this.proxyHost) || port == 0) {
                throw new IllegalStateException("Proxy host and port must be set before creating authentication");
            }
            HttpBuilderBase.this.credsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM), this.creds);
        }
    }
}

