/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfrog.artifactory.client.model.Plugin;

public class PluginImpl
implements Plugin {
    private String name;
    private String version;
    private String description;
    private List<String> users;
    private List<String> groups;
    private Map<String, String> params;
    private String httpMethod;

    private PluginImpl() {
        this.users = new ArrayList<String>();
        this.groups = new ArrayList<String>();
        this.params = new HashMap<String, String>();
    }

    private PluginImpl(String name) {
        this.name = name;
    }

    private PluginImpl(String name, String version, String description, List<String> users, List<String> groups, Map<String, String> params, String httpMethod) {
        this(name, version, description, users, groups, params);
        this.httpMethod = httpMethod;
    }

    protected PluginImpl(String name, String version, String description, List<String> users, List<String> groups, Map<String, String> params) {
        this.name = name;
        this.version = version;
        this.description = description;
        this.users = users;
        this.groups = groups;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getUsers() {
        return Collections.unmodifiableList(this.users);
    }

    public void addUsers(List<String> users) {
        this.users.addAll(users);
    }

    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void addGroups(List<String> groups) {
        this.groups.addAll(groups);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void addParams(Map<String, String> params) {
        this.params.putAll(params);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginImpl plugin = (PluginImpl)o;
        return this.name.equals(plugin.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "PluginImpl{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", description='" + this.description + '\'' + ", users=" + this.users + ", groups=" + this.groups + ", params=" + this.params + ", httpMethod=" + this.httpMethod + '}';
    }
}

