/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfrog.artifactory.client.model.Principal;
import org.jfrog.artifactory.client.model.Principals;
import org.jfrog.artifactory.client.model.Privilege;
import org.jfrog.artifactory.client.model.impl.PrincipalImpl;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PrincipalsImpl
implements Principals {
    private Map<String, Set<String>> users = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> groups = new HashMap<String, Set<String>>();

    protected void setPrincipals(List<Principal> users, List<Principal> groups) {
        this.users = PrincipalsImpl.setMapPrivilegesFrom(users);
        this.groups = PrincipalsImpl.setMapPrivilegesFrom(groups);
    }

    public List<Principal> getUsers() {
        return PrincipalsImpl.getListPrincipalFrom(this.users);
    }

    public List<Principal> getGroups() {
        return PrincipalsImpl.getListPrincipalFrom(this.groups);
    }

    private static Map<String, Set<String>> setMapPrivilegesFrom(List<Principal> list) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (list != null && !list.isEmpty()) {
            for (Principal principal : list) {
                HashSet<String> strings = new HashSet<String>(principal.getPrivileges().size());
                for (Privilege privilege : principal.getPrivileges()) {
                    strings.add(privilege.getAbbreviation());
                }
                map.put(principal.getName(), strings);
            }
        }
        return map;
    }

    private static List<Principal> getListPrincipalFrom(Map<String, Set<String>> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<Principal> list = new ArrayList<Principal>();
        for (Map.Entry<String, Set<String>> e : map.entrySet()) {
            HashSet<Privilege> set = new HashSet<Privilege>();
            for (String str : e.getValue()) {
                set.add(Privilege.fromAbbreviation((String)str));
            }
            list.add(new PrincipalImpl(e.getKey(), set));
        }
        return list;
    }

    public Principal getUser(String name) {
        for (Principal principal : this.getUsers()) {
            if (!principal.getName().equals(name)) continue;
            return principal;
        }
        return null;
    }

    public Principal getGroup(String name) {
        for (Principal principal : this.getGroups()) {
            if (!principal.getName().equals(name)) continue;
            return principal;
        }
        return null;
    }
}

