/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.aql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jfrog.artifactory.client.aql.AqlBuilderException;
import org.jfrog.artifactory.client.aql.AqlInclude;
import org.jfrog.artifactory.client.aql.AqlItem;
import org.jfrog.artifactory.client.aql.AqlRootElement;

public class AqlQueryBuilder {
    private AqlRootElement root = new AqlRootElement();
    private AqlItem sort;
    private AqlInclude include;
    private Integer limit;
    private Integer offset;

    public AqlQueryBuilder item(AqlItem item) {
        this.root.putAll(item.value());
        return this;
    }

    public AqlQueryBuilder elements(AqlItem ... items) {
        if (ArrayUtils.isNotEmpty((Object[])items)) {
            this.root.putAll(Arrays.stream(items).map(item -> item.value().entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return this;
    }

    public AqlQueryBuilder array(String key, AqlItem ... items) {
        if (ArrayUtils.isNotEmpty((Object[])items)) {
            this.root.put(key, items);
        }
        return this;
    }

    public AqlQueryBuilder and(AqlItem ... items) {
        if (ArrayUtils.isNotEmpty((Object[])items)) {
            this.root.putAll(AqlItem.and(items).value());
        }
        return this;
    }

    public AqlQueryBuilder and(Collection<AqlItem> items) {
        return this.and(this.setToArray(items));
    }

    public AqlQueryBuilder or(AqlItem ... items) {
        if (ArrayUtils.isNotEmpty((Object[])items)) {
            this.root.putAll(AqlItem.or(items).value());
        }
        return this;
    }

    public AqlQueryBuilder match(String key, String pattern) {
        if (key != null) {
            this.root.putAll(AqlItem.match(key, pattern).value());
        }
        return this;
    }

    public AqlQueryBuilder notMatch(String key, String pattern) {
        if (key != null) {
            this.root.putAll(AqlItem.notMatch(key, pattern).value());
        }
        return this;
    }

    public AqlQueryBuilder or(Collection<AqlItem> items) {
        return this.or(this.setToArray(items));
    }

    public AqlQueryBuilder include(String ... elements) {
        if (ArrayUtils.isNotEmpty((Object[])elements)) {
            this.include = AqlInclude.buildWithElements(elements);
        }
        return this;
    }

    public AqlQueryBuilder asc(String ... by) {
        if (ArrayUtils.isNotEmpty((Object[])by)) {
            this.sort = AqlItem.asc(by);
        }
        return this;
    }

    public AqlQueryBuilder desc(String ... by) {
        if (ArrayUtils.isNotEmpty((Object[])by)) {
            this.sort = AqlItem.desc(by);
        }
        return this;
    }

    public AqlQueryBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public AqlQueryBuilder offset(int offset) {
        this.offset = offset;
        return this;
    }

    public String build() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return "items.find(" + this.getRootAsString(mapper) + ")" + this.getIncludeAsString() + this.getSortAsString(mapper) + this.getOffsetAsString(mapper) + this.getLimitAsString(mapper);
        }
        catch (JsonProcessingException e) {
            throw new AqlBuilderException("Error serializing object to json: ", e);
        }
    }

    private String getSortAsString(ObjectMapper mapper) throws JsonProcessingException {
        return this.hasSort() ? ".sort(" + mapper.writeValueAsString((Object)this.sort) + ")" : "";
    }

    private String getIncludeAsString() {
        return this.hasInclude() ? this.include.toString() : "";
    }

    private String getOffsetAsString(ObjectMapper mapper) throws JsonProcessingException {
        return this.hasOffset() ? ".offset(" + mapper.writeValueAsString((Object)this.offset) + ")" : "";
    }

    private String getLimitAsString(ObjectMapper mapper) throws JsonProcessingException {
        return this.hasLimit() ? ".limit(" + mapper.writeValueAsString((Object)this.limit) + ")" : "";
    }

    private String getRootAsString(ObjectMapper mapper) throws JsonProcessingException {
        return this.hasRoot() ? mapper.writeValueAsString((Object)this.root) : "";
    }

    private boolean hasInclude() {
        return this.include != null && this.include.isNotEmpty();
    }

    private boolean hasSort() {
        return this.sort != null && this.sort.isNotEmpty();
    }

    private boolean hasLimit() {
        return this.limit != null;
    }

    private boolean hasOffset() {
        return this.offset != null;
    }

    private boolean hasRoot() {
        return this.root != null && this.root.isNotEmpty();
    }

    private AqlItem[] setToArray(Collection<AqlItem> items) {
        return items.toArray(new AqlItem[0]);
    }
}

