/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.ArtifactoryRequest;
import org.jfrog.artifactory.client.ArtifactoryResponse;
import org.jfrog.artifactory.client.ArtifactoryStreamingResponse;
import org.jfrog.artifactory.client.ArtifactorySystem;
import org.jfrog.artifactory.client.Builds;
import org.jfrog.artifactory.client.Plugins;
import org.jfrog.artifactory.client.Repositories;
import org.jfrog.artifactory.client.RepositoryHandle;
import org.jfrog.artifactory.client.Searches;
import org.jfrog.artifactory.client.Security;
import org.jfrog.artifactory.client.Storage;
import org.jfrog.artifactory.client.impl.ArtifactoryResponseImpl;
import org.jfrog.artifactory.client.impl.ArtifactoryStreamingResponseImpl;
import org.jfrog.artifactory.client.impl.ArtifactorySystemImpl;
import org.jfrog.artifactory.client.impl.BuildsImpl;
import org.jfrog.artifactory.client.impl.PluginsImpl;
import org.jfrog.artifactory.client.impl.RepositoriesImpl;
import org.jfrog.artifactory.client.impl.SearchesImpl;
import org.jfrog.artifactory.client.impl.SecurityImpl;
import org.jfrog.artifactory.client.impl.StorageImpl;
import org.jfrog.artifactory.client.impl.util.Util;

public class ArtifactoryImpl
implements Artifactory {
    private String username;
    private String url;
    private String userAgent;
    private CloseableHttpClient httpClient;
    private String accessToken;

    public ArtifactoryImpl(CloseableHttpClient httpClient, String url, String userAgent, String username, String accessToken) {
        this.url = url;
        this.httpClient = httpClient;
        this.userAgent = userAgent;
        this.username = username;
        this.accessToken = accessToken;
    }

    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getUri() throws MalformedURLException {
        URL url = new URL(this.url);
        String uri = url.getProtocol() + "://" + url.getHost();
        if (url.getPort() == -1) {
            return uri;
        }
        return uri + ":" + url.getPort();
    }

    public String getContextName() throws MalformedURLException {
        URL url = new URL(this.url);
        String urlContext = url.getPath();
        if (urlContext.startsWith("/")) {
            return urlContext.substring(1);
        }
        return urlContext;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Repositories repositories() {
        return new RepositoriesImpl(this, "/api");
    }

    public RepositoryHandle repository(String repo) {
        if (StringUtils.isBlank((CharSequence)repo)) {
            throw new IllegalArgumentException("Repository name is required");
        }
        return new RepositoriesImpl(this, "/api").repository(repo);
    }

    public Searches searches() {
        return new SearchesImpl(this, "/api");
    }

    public Builds builds() {
        return new BuildsImpl(this, "/api");
    }

    public Security security() {
        return new SecurityImpl(this, "/api");
    }

    public Storage storage() {
        return new StorageImpl(this);
    }

    public Plugins plugins() {
        return new PluginsImpl(this, "/api");
    }

    public ArtifactorySystem system() {
        return new ArtifactorySystemImpl(this, "/api");
    }

    public ArtifactoryResponse restCall(ArtifactoryRequest artifactoryRequest) throws IOException {
        HttpResponse httpResponse = this.handleArtifactoryRequest(artifactoryRequest);
        return new ArtifactoryResponseImpl(httpResponse);
    }

    public ArtifactoryStreamingResponse streamingRestCall(ArtifactoryRequest artifactoryRequest) throws IOException {
        HttpResponse httpResponse = this.handleArtifactoryRequest(artifactoryRequest);
        return new ArtifactoryStreamingResponseImpl(httpResponse);
    }

    private HttpResponse handleArtifactoryRequest(ArtifactoryRequest artifactoryRequest) throws IOException {
        HttpGet httpRequest;
        String requestPath = "/" + artifactoryRequest.getApiUrl();
        ContentType contentType = null;
        if (artifactoryRequest.getRequestType() != null) {
            contentType = Util.getContentType(artifactoryRequest.getRequestType());
        }
        String queryPath = "";
        if (!artifactoryRequest.getQueryParams().isEmpty()) {
            queryPath = Util.getQueryPath("?", artifactoryRequest.getQueryParams());
        }
        switch (artifactoryRequest.getMethod()) {
            case GET: {
                httpRequest = new HttpGet();
                break;
            }
            case POST: {
                httpRequest = new HttpPost();
                this.setEntity((HttpEntityEnclosingRequestBase)((HttpPost)httpRequest), artifactoryRequest.getBody(), contentType);
                break;
            }
            case PUT: {
                httpRequest = new HttpPut();
                this.setEntity((HttpEntityEnclosingRequestBase)((HttpPut)httpRequest), artifactoryRequest.getBody(), contentType);
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete();
                break;
            }
            case PATCH: {
                httpRequest = new HttpPatch();
                this.setEntity((HttpEntityEnclosingRequestBase)((HttpPatch)httpRequest), artifactoryRequest.getBody(), contentType);
                break;
            }
            case OPTIONS: {
                httpRequest = new HttpOptions();
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported request method.");
            }
        }
        httpRequest.setURI(URI.create(this.url + requestPath + queryPath));
        if (contentType != null) {
            httpRequest.setHeader("Content-type", contentType.getMimeType());
        }
        Map headers = artifactoryRequest.getHeaders();
        for (String key : headers.keySet()) {
            httpRequest.setHeader(key, (String)headers.get(key));
        }
        HttpResponse httpResponse = this.execute((HttpUriRequest)httpRequest);
        return httpResponse;
    }

    private void setEntity(HttpEntityEnclosingRequestBase httpRequest, Object body, ContentType contentType) throws JsonProcessingException {
        if (body == null) {
            return;
        }
        if (body instanceof InputStream) {
            httpRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)body));
        } else if (body instanceof String) {
            httpRequest.setEntity((HttpEntity)new StringEntity((String)body, contentType));
        } else {
            String bodyText = Util.getStringFromObject(body);
            if (StringUtils.isNotBlank((CharSequence)bodyText)) {
                httpRequest.setEntity((HttpEntity)new StringEntity(bodyText, contentType));
            }
        }
    }

    public InputStream getInputStream(String path) throws IOException {
        HttpResponse httpResponse = (HttpResponse)this.get(path, null, null);
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            return httpResponse.getEntity().getContent();
        }
        throw this.newHttpResponseException(httpResponse);
    }

    public InputStream getInputStreamWithHeaders(String path, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse = (HttpResponse)this.get(path, null, null, headers);
        if (httpResponse.getStatusLine().getStatusCode() == 200 || httpResponse.getStatusLine().getStatusCode() == 206) {
            return httpResponse.getEntity().getContent();
        }
        throw this.newHttpResponseException(httpResponse);
    }

    private HttpResponseException newHttpResponseException(HttpResponse httpResponse) throws IOException {
        String artifactoryResponse = Util.responseToString(httpResponse);
        StatusLine statusLine = httpResponse.getStatusLine();
        if (StringUtils.isBlank((CharSequence)artifactoryResponse)) {
            artifactoryResponse = statusLine.getReasonPhrase() != null ? statusLine.getReasonPhrase() : "";
        }
        return new HttpResponseException(statusLine.getStatusCode(), artifactoryResponse);
    }

    protected Boolean head(String path) throws IOException {
        HttpHead httpHead = new HttpHead();
        httpHead.setURI(URI.create(this.url + path));
        HttpResponse httpResponse = this.execute((HttpUriRequest)httpHead);
        int status = httpResponse.getStatusLine().getStatusCode();
        return status >= 100 && status < 400;
    }

    public <T> T get(String path, Class<? extends T> object, Class<T> interfaceObject) throws IOException {
        return this.get(path, object, interfaceObject, new HashMap<String, String>());
    }

    public <T> T get(String path, Class<? extends T> object, Class<T> interfaceObject, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse;
        int status;
        HttpGet httpGet = new HttpGet();
        httpGet.setURI(URI.create(this.url + path));
        if (headers != null && !headers.isEmpty()) {
            for (String key : headers.keySet()) {
                httpGet.setHeader(key, headers.get(key));
            }
        }
        if ((status = (httpResponse = this.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode()) != 200 && status != 204 && status != 202 && status != 206) {
            throw this.newHttpResponseException(httpResponse);
        }
        if (object == null) {
            return (T)httpResponse;
        }
        if (object == String.class) {
            return (T)Util.responseToString(httpResponse);
        }
        return Util.responseToObject(httpResponse, object, interfaceObject);
    }

    public <T> T post(String path, ContentType contentType, String content, Map<String, String> headers, Class<? extends T> object, Class<T> interfaceObject) throws IOException {
        HttpPost httpPost = new HttpPost();
        httpPost.setURI(URI.create(this.url + path));
        httpPost.setHeader("Content-type", contentType.getMimeType());
        if (headers != null && !headers.isEmpty()) {
            for (String key : headers.keySet()) {
                httpPost.setHeader(key, headers.get(key));
            }
        }
        if (content != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(content, contentType));
        }
        HttpResponse httpResponse = this.execute((HttpUriRequest)httpPost);
        if (object == String.class) {
            return (T)Util.responseToString(httpResponse);
        }
        return Util.responseToObject(httpResponse, object, interfaceObject);
    }

    public <T> T patch(String path, ContentType contentType, String content, Map<String, String> headers, Class<? extends T> object, Class<T> interfaceObject) throws IOException {
        HttpPatch httpPatch = new HttpPatch();
        httpPatch.setURI(URI.create(this.url + path));
        httpPatch.setHeader("Content-type", contentType.getMimeType());
        if (headers != null && !headers.isEmpty()) {
            for (String key : headers.keySet()) {
                httpPatch.setHeader(key, headers.get(key));
            }
        }
        if (content != null) {
            httpPatch.setEntity((HttpEntity)new StringEntity(content, contentType));
        }
        HttpResponse httpResponse = this.execute((HttpUriRequest)httpPatch);
        if (object == String.class) {
            return (T)Util.responseToString(httpResponse);
        }
        return Util.responseToObject(httpResponse, object, interfaceObject);
    }

    public <T> T put(String path, ContentType contentType, String content, Map<String, String> headers, InputStream inputStream, long length, Class<? extends T> object, Class<T> interfaceObject) throws IOException {
        HttpResponse httpResponse;
        int status;
        HttpPut httpPut = new HttpPut();
        httpPut.setURI(URI.create(this.url + path));
        if (contentType != null) {
            httpPut.setHeader("Content-type", contentType.getMimeType());
        } else {
            contentType = ContentType.WILDCARD;
        }
        if (inputStream != null) {
            InputStreamEntity entity = new InputStreamEntity(inputStream, length);
            httpPut.setEntity((HttpEntity)entity);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            httpPut.setEntity((HttpEntity)new StringEntity(content, contentType));
        }
        if (headers != null && !headers.isEmpty()) {
            for (String key : headers.keySet()) {
                httpPut.setHeader(key, String.valueOf(headers.get(key)));
            }
        }
        if ((status = (httpResponse = this.execute((HttpUriRequest)httpPut)).getStatusLine().getStatusCode()) == 200 || status == 204 || status == 202 || status == 201) {
            if (object == String.class) {
                return (T)Util.responseToString(httpResponse);
            }
            return Util.responseToObject(httpResponse, object, interfaceObject);
        }
        throw this.newHttpResponseException(httpResponse);
    }

    public String delete(String path) throws IOException {
        HttpDelete httpDelete = new HttpDelete();
        httpDelete.setURI(URI.create(this.url + path));
        HttpResponse httpResponse = this.execute((HttpUriRequest)httpDelete);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status != 200 && status != 204 && status != 202) {
            throw this.newHttpResponseException(httpResponse);
        }
        return Util.responseToString(httpResponse);
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        HttpClientContext clientContext = HttpClientContext.create();
        if (clientContext.getAttribute("original.host.context.param") == null) {
            clientContext.setAttribute("original.host.context.param", (Object)request.getURI().getHost());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.accessToken)) {
            clientContext.setUserToken((Object)this.accessToken);
        }
        return this.httpClient.execute(request, (HttpContext)clientContext);
    }
}

