package org.jfrog.jade.plugins.common.ant;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.artifact.Artifact;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.jfrog.jade.plugins.common.injectable.MvnInjectable;

import java.io.File;
import java.util.Collection;

/**
 * @author Fred Simon
 */
public interface Maven2AntManager {
    /**
     * @param mvnInjectable
     * @return the Ant project associated with this Mvn Injectable
     */
    Project getAntProject(MvnInjectable mvnInjectable);

    /**
     * Helper method for populating an Ant Path with a list of String (paths)
     *
     * @param path     the Ant path object
     * @param elements a list of String location
     */
    void fillPathFromPaths(Path path, Collection<String> elements);

    /**
     * Helper method for populating an Ant Path with a list of File (locations)
     *
     * @param path     the Ant path object
     * @param elements a list of File location
     */
    void fillPathFromLocations(Path path, Collection<File> elements);

    /**
     * Helper method for populating an Ant Path with a list of Artifacts
     *
     * @param path     the Ant path object
     * @param elements a list of artifact with file
     */
    void fillPathFromArtifacts(Path path, Collection<Artifact> elements);
}